/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che2.data.ResourceLocator;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.IntHashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class VRMap
implements Serializable {
    private static final long serialVersionUID = 6581801202183118918L;
    private static final String USAGE = "Usage: mkvrmap <xml-file> <resource-file>\n         (Store serialized VRMap in <resource-file>.)\n       mkvrmap <xml-file> <resource-name> <zip-file>\n         (Create <zip-file> with serialized VRMap under <resource-name>\n          and appendant META-INF/dcm4che/org.dcm4che2.data.VRMap.)\n";
    private static final VRMap DEFAULT = new VRMap();
    private static VRMap vrMap;
    private static Hashtable<String, VRMap> privVRMaps;
    private transient IntHashtable<VR> table;
    private transient String privateCreator;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(USAGE);
            System.exit(1);
        }
        VRMap vrMap = new VRMap(2300);
        try {
            vrMap.loadXML(new File(args[0]));
            if (args.length > 2) {
                ResourceLocator.createResource(args[1], vrMap, new File(args[2]));
                System.out.println("Create VRMap Resource  - " + args[2]);
            } else {
                ResourceLocator.serializeTo(vrMap, new File(args[1]));
                System.out.println("Serialize VRMap to - " + args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadVRMaps() {
        VRMap newVRMap = null;
        Hashtable<String, VRMap> newPrivVRMaps = new Hashtable<String, VRMap>();
        List<String> list = ResourceLocator.findResources(VRMap.class);
        for (String s : list) {
            VRMap m = (VRMap)ResourceLocator.loadResource(s);
            if (m.getPrivateCreator() == null) {
                newVRMap = m;
                continue;
            }
            newPrivVRMaps.put(m.getPrivateCreator(), m);
        }
        vrMap = newVRMap;
        privVRMaps = newPrivVRMaps;
    }

    public static void loadVRMap(String resourceName) {
        VRMap m = (VRMap)ResourceLocator.loadResource(resourceName);
        if (m.getPrivateCreator() == null) {
            vrMap = m;
        } else {
            privVRMaps.put(m.getPrivateCreator(), m);
        }
    }

    public static VRMap getVRMap() {
        return VRMap.maskNull(vrMap);
    }

    public static VRMap getPrivateVRMap(String creatorID) {
        return VRMap.maskNull(creatorID != null && creatorID.length() != 0 ? privVRMaps.get(creatorID) : vrMap);
    }

    private static VRMap maskNull(VRMap vrMap) {
        return vrMap != null ? vrMap : DEFAULT;
    }

    private VRMap() {
    }

    private VRMap(int initialCapacity) {
        this.table = new IntHashtable(initialCapacity);
    }

    public final String getPrivateCreator() {
        return this.privateCreator;
    }

    private void writeObject(final ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeObject(this.privateCreator);
        os.writeInt(this.table.size());
        try {
            this.table.accept(new IntHashtable.Visitor(){

                public boolean visit(int key, Object value) {
                    try {
                        os.writeInt(key);
                        os.writeShort(((VR)value).code);
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw (IOException)e;
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.privateCreator = (String)is.readObject();
        int size = is.readInt();
        this.table = new IntHashtable(size);
        for (int i = 0; i < size; ++i) {
            int tag = is.readInt();
            int code = is.readUnsignedShort();
            this.table.put(tag, VR.valueOf(code));
        }
    }

    public VR vrOf(int tag) {
        if ((tag & 0xFFFF) == 0) {
            return VR.UL;
        }
        if ((tag & 0xFFFF0000) == 0) {
            return this.vrOfCommand(tag);
        }
        if ((tag & 0x10000) != 0) {
            if ((tag & 0xFF00) == 0) {
                return VR.LO;
            }
            tag &= 0xFFFF00FF;
        } else {
            int ggg00000 = tag & 0xFFE00000;
            if (ggg00000 == 0x50000000 || ggg00000 == 0x60000000) {
                tag &= 0xFF00FFFF;
            }
        }
        if (this.table == null) {
            return VR.UN;
        }
        VR vr = this.table.get(tag);
        return vr != null ? vr : VR.UN;
    }

    private VR vrOfCommand(int tag) {
        switch (tag) {
            case 512: 
            case 768: 
            case 1024: 
            case 1536: 
            case 4144: {
                return VR.AE;
            }
            case 2305: 
            case 4101: 
            case 16384: 
            case 16400: 
            case 20752: 
            case 20768: {
                return VR.AT;
            }
            case 16: 
            case 20784: 
            case 20800: 
            case 20816: 
            case 20832: 
            case 20864: 
            case 20880: 
            case 20896: {
                return VR.CS;
            }
            case 20848: {
                return VR.IS;
            }
            case 2306: {
                return VR.LO;
            }
            case 20496: 
            case 20512: {
                return VR.SH;
            }
            case 2: 
            case 3: 
            case 4096: 
            case 4097: {
                return VR.UI;
            }
            case 1: {
                return VR.UL;
            }
            case 256: 
            case 272: 
            case 288: 
            case 1792: 
            case 2048: 
            case 2128: 
            case 2144: 
            case 2304: 
            case 2307: 
            case 4098: 
            case 4104: 
            case 4128: 
            case 4129: 
            case 4130: 
            case 4131: 
            case 4145: 
            case 20912: {
                return VR.US;
            }
        }
        return VR.UN;
    }

    public void loadXML(File f) throws IOException, SAXException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(f, (DefaultHandler)new SAXAdapter());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    static {
        VRMap.reloadVRMaps();
    }

    private final class SAXAdapter
    extends DefaultHandler {
        private SAXAdapter() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("element".equals(qName)) {
                int tag = (int)Long.parseLong(attributes.getValue("tag").replace('x', '0'), 16);
                String vrstr = attributes.getValue("vr");
                if (vrstr != null && vrstr.length() != 0) {
                    VR vr = "US|SS|OW".equals(vrstr) ? VR.OW : VR.valueOf(vrstr.charAt(0) << 8 | vrstr.charAt(1));
                    VRMap.this.table.put(tag, vr);
                }
            } else if ("dictionary".equals(qName)) {
                VRMap.this.privateCreator = attributes.getValue("creator");
            }
        }
    }
}

