/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.IIORegistry;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import org.weasis.launcher.WeasisLauncher;

public class WebstartLauncher
extends WeasisLauncher
implements SingleInstanceListener {
    private static final WebstartLauncher instance = new WebstartLauncher();

    public static void main(String[] argv) throws Exception {
        WebstartLauncher.launch(argv);
    }

    public void newActivation(String[] argv) {
        if (m_tracker != null && argv.length > 0) {
            m_tracker.open();
            Object commandSession = WebstartLauncher.getCommandSession(m_tracker.getService());
            List<StringBuffer> commandList = WebstartLauncher.splitCommand(argv);
            if (commandSession != null) {
                WebstartLauncher.commandSession_execute(commandSession, "weasis:ui -v");
                for (StringBuffer command : commandList) {
                    WebstartLauncher.commandSession_execute(commandSession, command);
                }
                WebstartLauncher.commandSession_close(commandSession);
            }
            m_tracker.close();
        }
    }

    static {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener((SingleInstanceListener)instance);
        }
        catch (UnavailableServiceException use) {
            // empty catch block
        }
        if (System.getProperty("javawebstart.version", "").equals("javaws-1.6.0_24")) {
            System.setProperty("felix.extensions.enabled", "false");
        }
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<Class<?>> categories = registry.getCategories();
        ArrayList toRemove = new ArrayList();
        while (categories.hasNext()) {
            Class<?> class1 = categories.next();
            Iterator<?> providers = registry.getServiceProviders(class1, false);
            while (providers.hasNext()) {
                Object provider = providers.next();
                if (!provider.getClass().getPackage().getName().startsWith("com.sun.media")) continue;
                toRemove.add(provider);
            }
        }
        for (Object provider : toRemove) {
            registry.deregisterServiceProvider(provider);
        }
    }
}

