/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class FileUtil {
    public static void safeClose(Closeable object) {
        try {
            if (object != null) {
                object.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void safeClose(ImageInputStream stream) {
        try {
            if (stream != null) {
                stream.flush();
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void deleteDirectoryContents(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtil.deleteDirectoryContents(f);
                    continue;
                }
                try {
                    f.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static File getApplicationTempDir() {
        File tdir;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            String dir = System.getProperty("user.home");
            if (dir == null) {
                dir = "";
            }
            tdir = new File(dir);
        } else {
            tdir = new File(tempDir);
        }
        return new File(tdir, "weasis");
    }
}

