/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sling.commons.log.internal.slf4j.FileRotator;

final class ScheduledFileRotator
implements FileRotator {
    private static final String DEFAULT_DATE_PATTERN = "'.'yyyy-MM-dd";
    private static final int TOP_OF_TROUBLE = -1;
    private static final int TOP_OF_MINUTE = 0;
    private static final int TOP_OF_HOUR = 1;
    private static final int HALF_DAY = 2;
    private static final int TOP_OF_DAY = 3;
    private static final int TOP_OF_WEEK = 4;
    private static final int TOP_OF_MONTH = 5;
    private static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    private final String datePattern;
    private final Date now;
    private final SimpleDateFormat sdf;
    private final RollingCalendar rc;
    private String scheduledFilename;
    private long nextCheck;

    ScheduledFileRotator(String datePattern) {
        this.datePattern = datePattern != null && datePattern.length() > 0 ? datePattern : DEFAULT_DATE_PATTERN;
        long currentTime = System.currentTimeMillis();
        int type = ScheduledFileRotator.computeCheckPeriod(this.datePattern);
        this.nextCheck = currentTime - 1L;
        this.now = new Date(currentTime);
        this.sdf = new SimpleDateFormat(this.datePattern);
        this.rc = new RollingCalendar(type);
    }

    String getDatePattern() {
        return this.datePattern;
    }

    public boolean isRotationDue(File file) {
        long n;
        if (this.scheduledFilename == null) {
            this.scheduledFilename = this.sdf.format(new Date(file.lastModified()));
        }
        if ((n = System.currentTimeMillis()) >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            return true;
        }
        return false;
    }

    public void rotate(File file) {
        boolean result;
        String baseFileName = file.getAbsolutePath();
        String dateSuffix = this.sdf.format(this.now);
        if (this.scheduledFilename.equals(dateSuffix)) {
            return;
        }
        File target = new File(baseFileName + this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = file.renameTo(target)) {
            // empty if block
        }
        this.scheduledFilename = dateSuffix;
    }

    public File[] getRotatedFiles(File file) {
        File dir = file.getParentFile();
        final String baseName = file.getName();
        File[] logFiles = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(baseName);
            }
        });
        return logFiles;
    }

    private static int computeCheckPeriod(String datePattern) {
        if (datePattern != null) {
            RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
            Date epoch = new Date(0L);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);
            simpleDateFormat.setTimeZone(gmtTimeZone);
            for (int i = 0; i <= 5; ++i) {
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": datePattern" + this.getDatePattern();
    }

    private static class RollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        int type = -1;

        RollingCalendar(int type) {
            this.setType(type);
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
        }

        void setType(int type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }
}

