/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PrivilegedWriter
extends FilterWriter {
    PrivilegedWriter(Writer delegatee) {
        super(delegatee);
    }

    public void close() throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PrivilegedWriter.super.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.rethrow(e.getCause());
        }
    }

    public void flush() throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PrivilegedWriter.super.flush();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.rethrow(e.getCause());
        }
    }

    public void write(final char[] cbuf, final int off, final int len) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PrivilegedWriter.super.write(cbuf, off, len);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.rethrow(e.getCause());
        }
    }

    private void rethrow(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw (IOException)new IOException(cause.getMessage()).initCause(cause);
    }
}

