/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.imageio.codec;

import java.net.URI;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.weasis.core.api.media.data.Codec;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.imageio.codec.ImageElementIO;

public class ImageioCodec
implements Codec {
    public String[] getReaderMIMETypes() {
        return ImageIO.getReaderMIMETypes();
    }

    public String[] getReaderExtensions() {
        return ImageIO.getReaderFileSuffixes();
    }

    public boolean isMimeTypeSupported(String mimeType) {
        if (mimeType != null) {
            for (String mime : ImageIO.getReaderMIMETypes()) {
                if (!mimeType.equals(mime)) continue;
                return true;
            }
        }
        return false;
    }

    public MediaReader getMediaIO(URI media, String mimeType, Hashtable<String, Object> properties) {
        if (this.isMimeTypeSupported(mimeType)) {
            return new ImageElementIO(media, mimeType, this);
        }
        return null;
    }

    public String getCodecName() {
        return "Sun java imageio";
    }

    public String[] getWriterExtensions() {
        return ImageIO.getWriterFileSuffixes();
    }

    public String[] getWriterMIMETypes() {
        return ImageIO.getWriterMIMETypes();
    }
}

