/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.imageio.codec;

import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.image.util.ImageFiler;
import org.weasis.core.api.image.util.LayoutUtil;
import org.weasis.core.api.media.data.Codec;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;

public class ImageElementIO
implements MediaReader<PlanarImage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageElementIO.class);
    protected URI uri;
    protected final String mimeType;
    private ImageElement image = null;
    private final Codec codec;

    public ImageElementIO(URI media, String mimeType, Codec codec) {
        if (media == null) {
            throw new IllegalArgumentException("media uri is null");
        }
        this.uri = media;
        this.mimeType = mimeType == null ? "application/x-unknown-mime-type" : mimeType;
        this.codec = codec;
    }

    public PlanarImage getMediaFragment(MediaElement<PlanarImage> media) throws Exception {
        if (media != null && media.getFile() != null) {
            RenderedOp img;
            ImageReader reader = this.getDefaultReader(this.mimeType);
            if (reader == null) {
                LOGGER.info("Cannot find a reader for the mime type: {}", (Object)this.mimeType);
                return null;
            }
            RenderingHints hints = LayoutUtil.createTiledLayoutHints();
            if ("it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader".equals(reader.getClass().getName())) {
                ParameterBlockJAI pb = new ParameterBlockJAI("ImageReadMT");
                pb.setParameter("Input", (Object)media.getFile());
                pb.setParameter("ImageChoice", 0);
                pb.setParameter("ReadMetadata", true);
                pb.setParameter("ReadThumbnails", false);
                pb.setParameter("VerifyInput", true);
                pb.setParameter("Listeners", null);
                pb.setParameter("Locale", null);
                pb.setParameter("ReadParam", (Object)reader.getDefaultReadParam());
                pb.setParameter("Reader", (Object)reader);
                img = JAI.create((String)"ImageReadMT", (ParameterBlock)pb, (RenderingHints)hints);
            } else {
                FileImageInputStream in = new FileImageInputStream(new RandomAccessFile(media.getFile(), "r"));
                ParameterBlockJAI pb = new ParameterBlockJAI("ImageRead");
                pb.setParameter("Input", (Object)in);
                pb.setParameter("Reader", (Object)reader);
                img = JAI.create((String)"ImageRead", (ParameterBlock)pb, (RenderingHints)hints);
            }
            img = ImageFiler.getReadableImage((PlanarImage)img);
            return img;
        }
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    public void reset() {
    }

    public MediaElement<PlanarImage> getPreview() {
        return this.getSingleImage();
    }

    public boolean delegate(DataExplorerModel explorerModel) {
        return false;
    }

    public MediaElement[] getMediaElement() {
        ImageElement element = this.getSingleImage();
        if (element != null) {
            return new MediaElement[]{element};
        }
        return null;
    }

    public MediaSeries<ImageElement> getMediaSeries() {
        Series<ImageElement> series = new Series<ImageElement>(TagW.CurrentFolder, (Object)this.toString(), null){

            public String getMimeType() {
                return null;
            }

            public void addMedia(MediaElement media) {
            }
        };
        series.add((Object)this.getSingleImage());
        return series;
    }

    public int getMediaElementNumber() {
        return 0;
    }

    private ImageElement getSingleImage() {
        if (this.image == null) {
            this.image = new ImageElement((MediaReader)this, (Object)0);
        }
        return this.image;
    }

    public String getMediaFragmentMimeType(Object key) {
        return this.mimeType;
    }

    public HashMap<TagW, Object> getMediaFragmentTags(Object key) {
        return new HashMap<TagW, Object>();
    }

    public URI getMediaFragmentURI(Object key) {
        return this.uri;
    }

    public void close() {
    }

    public Codec getCodec() {
        return this.codec;
    }

    public String[] getReaderDescription() {
        return new String[]{"Image Codec: " + this.codec.getCodecName()};
    }

    public ImageReader getDefaultReader(String mimeType) {
        Iterator<ImageReader> readers;
        if (mimeType != null && (readers = ImageIO.getImageReadersByMIMEType(mimeType)).hasNext()) {
            return readers.next();
        }
        return null;
    }

    public Object getTagValue(TagW tag) {
        return null;
    }

    public void replaceURI(URI uri) {
    }
}

