/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.io.File;
import org.weasis.core.api.image.util.Unit;
import org.weasis.core.api.media.data.AudioVideoElement;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.DicomMediaIO;

public class DicomVideoElement
extends AudioVideoElement {
    public static final String MPEG_MIMETYPE = "video/mpeg";
    private double pixelSizeX = 1.0;
    private double pixelSizeY = 1.0;
    private File videoFile = null;
    private Unit pixelSpacingUnit;

    public DicomVideoElement(DicomMediaIO mediaIO, Object key) {
        super((MediaReader)mediaIO, key);
        double[] val = (double[])mediaIO.getTagValue(TagW.PixelSpacing);
        if (val == null) {
            val = (double[])mediaIO.getTagValue(TagW.ImagerPixelSpacing);
        }
        if (val != null) {
            this.pixelSizeX = val[0];
            this.pixelSizeY = val[1];
            this.pixelSpacingUnit = Unit.MILLIMETER;
        }
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    public Unit getPixelSpacingUnit() {
        return this.pixelSpacingUnit;
    }

    public File getVideoFile() {
        return this.videoFile;
    }

    public void setVideoFile(File videoFile) {
        this.videoFile = videoFile;
    }
}

