/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.image.PartialComponentColorModel;
import org.dcm4che2.image.SimpleYBRColorSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorModelFactory {
    private static final Logger log = LoggerFactory.getLogger(ColorModelFactory.class);
    private static final String MONOCHROME1 = "MONOCHROME1";
    private static final String MONOCHROME2 = "MONOCHROME2";
    private static final String PALETTE_COLOR = "PALETTE COLOR";
    private static final String RGB = "RGB";
    private static final String YBR_FULL = "YBR_FULL";
    private static final String YBR_FULL_422 = "YBR_FULL_422";
    private static final String YBR_PARTIAL_422 = "YBR_PARTIAL_422";
    private static final String YBR_PARTIAL_420 = "YBR_PARTIAL_420";

    public static ColorModel createColorModel(DicomObject ds) {
        int dataType;
        int samples = ds.getInt(0x280002, 1);
        if (samples != 1 && samples != 3) {
            throw new IllegalArgumentException("Unsupported Samples per Pixel: " + samples);
        }
        int allocated = ds.getInt(2621696, 8);
        int stored = ds.getInt(2621697, allocated);
        int n = allocated <= 8 ? 0 : (dataType = ds.getInt(2621699) != 0 ? 2 : 1);
        if (allocated > 16 && samples == 1) {
            dataType = 3;
        }
        int[] bits = new int[samples];
        Arrays.fill(bits, stored);
        ColorSpace cs = null;
        String pmi = null;
        if (samples == 1) {
            pmi = ds.getString(2621444, MONOCHROME2);
            if (pmi.equals(MONOCHROME2) || pmi.equals(MONOCHROME1)) {
                cs = ColorSpace.getInstance(1003);
            } else if (pmi.equals(PALETTE_COLOR)) {
                return ColorModelFactory.createPaletteColorModel(ds);
            }
        } else if (samples == 3) {
            pmi = ds.getString(2621444, RGB);
            if (pmi.equals(RGB)) {
                log.debug("Color space is RGB.");
                cs = ColorModelFactory.createRGBColorSpace(ds);
            } else if (pmi.equals(YBR_FULL) || pmi.equals(YBR_FULL_422)) {
                log.debug("Color space is YBR full");
                cs = SimpleYBRColorSpace.createYBRFullColorSpace(ColorModelFactory.createRGBColorSpace(ds));
            } else if (pmi.equals(YBR_PARTIAL_422) || pmi.equals(YBR_PARTIAL_420)) {
                log.debug("Color space is YBR partial");
                cs = SimpleYBRColorSpace.createYBRPartialColorSpace(ColorModelFactory.createRGBColorSpace(ds));
            }
            if (pmi.endsWith("422")) {
                return new PartialComponentColorModel(cs, 2, 1);
            }
            if (pmi.endsWith("420")) {
                return new PartialComponentColorModel(cs, 2, 2);
            }
        } else {
            throw new IllegalArgumentException("Unsupported Samples per Pixel: " + samples);
        }
        if (cs == null) {
            throw new IllegalArgumentException("Unsupported Photometric Interpretation: " + pmi + " with Samples per Pixel: " + samples);
        }
        return new ComponentColorModel(cs, bits, false, false, 1, dataType);
    }

    private static ColorSpace createRGBColorSpace(DicomObject ds) {
        byte[] iccProfile = ds.getBytes(0x282000);
        return iccProfile != null ? new ICC_ColorSpace(ICC_Profile.getInstance(iccProfile)) : ColorSpace.getInstance(1000);
    }

    public static boolean isMonochrome(DicomObject ds) {
        return ds.getInt(0x280002, 1) == 1 && !ColorModelFactory.isPaletteColor(ds);
    }

    public static boolean isPaletteColor(DicomObject ds) {
        return PALETTE_COLOR.equals(ds.getString(2621444));
    }

    public static ColorModel createPaletteColorModel(DicomObject ds) {
        int bits = ds.getInt(2621697, 8);
        int size = 1 << bits;
        byte[] r = ColorModelFactory.decodePaletteColorLut(size, ds, 2625793, 2626049, 0x281221);
        byte[] g = ColorModelFactory.decodePaletteColorLut(size, ds, 2625794, 2626050, 0x281222);
        byte[] b = ColorModelFactory.decodePaletteColorLut(size, ds, 2625795, 2626051, 2626083);
        return new IndexColorModel(bits, size, r, g, b);
    }

    private static void throwLutLengthMismatch(int lutLen, int descLen) {
        throw new IllegalArgumentException("LUT Data length: " + lutLen + " mismatch entry value: " + descLen + " in LUT Descriptor");
    }

    private static byte[] decodePaletteColorLut(int size, DicomObject ds, int descTag, int dataTag, int segmTag) {
        int[] desc = ds.getInts(descTag);
        if (desc == null) {
            throw new IllegalArgumentException("Missing LUT Descriptor!");
        }
        if (desc.length != 3) {
            throw new IllegalArgumentException("Illegal number of LUT Descriptor values: " + desc.length);
        }
        int len = desc[0] == 0 ? 65536 : desc[0];
        int off = desc[1];
        int bits = desc[2];
        if (len < 0) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: len=" + len);
        }
        if (off < 0) {
            throw new IllegalArgumentException("Unsupported LUT Descriptor: off=" + off);
        }
        if (bits != 8 && bits != 16) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: bits=" + bits);
        }
        byte[] out = new byte[size];
        byte[] data = ds.getBytes(dataTag);
        if (data == null) {
            short[] segm = ds.getShorts(segmTag);
            if (segm == null) {
                throw new IllegalArgumentException("Missing LUT Data!");
            }
            if (bits == 8) {
                throw new IllegalArgumentException("Segmented LUT Data with LUT Descriptor: bits=8");
            }
            ColorModelFactory.inflateSegmentedLut(segm, out, off, len);
        } else if (bits == 8) {
            if (data.length != len) {
                short[] data16;
                if (data.length == 2 * len && (data16 = ds.getShorts(dataTag)) != null) {
                    data = new byte[len];
                    for (int i = 0; i < len; ++i) {
                        data[i] = (byte)data16[i];
                    }
                }
                if (data.length != len) {
                    ColorModelFactory.throwLutLengthMismatch(data.length, len);
                }
            }
            System.arraycopy(data, 0, out, off, len);
        } else {
            if (data.length != len << 1) {
                ColorModelFactory.throwLutLengthMismatch(data.length, len);
            }
            int hibyte = ds.bigEndian() ? 0 : 1;
            for (int i = 0; i < len; ++i) {
                out[i + off] = data[(i << 1) + hibyte];
            }
        }
        Arrays.fill(out, 0, off, out[off]);
        Arrays.fill(out, off + len, size, out[off + len - 1]);
        return out;
    }

    private static void inflateSegmentedLut(short[] in, byte[] out, int off, int len) {
        int x0 = off;
        int y0 = 0;
        int i = 0;
        block9: while (i < in.length) {
            short op = in[i++];
            int n = in[i++] & 0xFFFF;
            switch (op) {
                case 0: {
                    int j;
                    for (j = 0; j < n; ++j) {
                        int n2 = x0++;
                        y0 = in[i++] & 0xFFFF;
                        out[n2] = (byte)(y0 >> 8);
                    }
                    continue block9;
                }
                case 1: {
                    int y1 = in[i++] & 0xFFFF;
                    int dy = y1 - y0;
                    int j = 0;
                    while (j < n) {
                        out[x0++] = (byte)(y0 + dy * ++j / n >> 8);
                    }
                    y0 = y1;
                    break;
                }
                case 2: {
                    int dy;
                    int y1;
                    int i1 = in[i++] & 0xFFFF | in[i++] << 16;
                    block12: for (int j = 0; j < n; ++j) {
                        short op2 = in[i1++];
                        int n2 = in[i1++] & 0xFFFF;
                        switch (op2) {
                            case 0: {
                                int j2;
                                for (j2 = 0; j2 < n2; ++j2) {
                                    int n3 = x0++;
                                    y0 = in[i1++] & 0xFFFF;
                                    out[n3] = (byte)(y0 >> 8);
                                }
                                continue block12;
                            }
                            case 1: {
                                y1 = in[i1++] & 0xFFFF;
                                dy = y1 - y0;
                                int j2 = 0;
                                while (j2 < n2) {
                                    out[x0++] = (byte)(y0 + dy * ++j2 / n2 >> 8);
                                }
                                y0 = y1;
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("illegal op code:" + op2 + ", index:" + (i1 - 4));
                            }
                        }
                    }
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("illegal op code:" + op + ", index:" + (i - 4));
                }
            }
        }
        if (x0 - off != len) {
            ColorModelFactory.throwLutLengthMismatch(x0 - off, len);
        }
    }
}

