/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.media;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.media.DicomDirReader;
import org.dcm4che2.media.FileSetInformation;
import org.dcm4che2.util.ByteUtils;
import org.dcm4che2.util.TagUtils;

public class DicomDirWriter
extends DicomDirReader {
    protected final long firstRecordPos;
    protected final byte[] dirInfoHeader = new byte[]{4, 0, 0, 18, 85, 76, 4, 0, 0, 0, 0, 0, 4, 0, 2, 18, 85, 76, 4, 0, 0, 0, 0, 0, 4, 0, 18, 18, 85, 83, 2, 0, -1, -1, 4, 0, 32, 18, 83, 81, 0, 0, 0, 0, 0, 0};
    protected final byte[] dirRecordHeader = new byte[]{4, 0, 0, 20, 85, 76, 4, 0, 0, 0, 0, 0, 4, 0, 16, 20, 85, 83, 2, 0, 0, 0, 4, 0, 32, 20, 85, 76, 4, 0, 0, 0, 0, 0};
    protected long recordSeqLen;
    protected long rollbackLen = -1L;
    protected ArrayList<DicomObject> dirtyRecords = new ArrayList();
    protected DicomObject cachedParentRecord;
    protected DicomObject cachedLastChildRecord;
    protected final DicomOutputStream out;
    private static final Comparator<DicomObject> offsetComparator = new Comparator<DicomObject>(){

        @Override
        public int compare(DicomObject item1, DicomObject item2) {
            long d = item1.getItemOffset() - item2.getItemOffset();
            return d < 0L ? -1 : (d > 0L ? 1 : 0);
        }
    };

    public DicomDirWriter(File file) throws IOException {
        super(new RandomAccessFile(DicomDirWriter.checkExists(file), "rw"));
        this.file = file;
        this.offsetFirstRootRecord(this.filesetInfo.getOffsetFirstRootRecord());
        this.offsetLastRootRecord(this.filesetInfo.getOffsetLastRootRecord());
        this.firstRecordPos = this.in.getStreamPosition();
        this.recordSeqLen = this.in.valueLength();
        this.out = new DicomOutputStream(this.raf);
        this.out.setExplicitSequenceLength(this.recordSeqLen != -1L);
        this.out.setExplicitItemLength(this.recordSeqLen != -1L);
        if (this.filesetInfo.isEmpty()) {
            this.recordSeqLen = 0L;
        }
    }

    private static File checkExists(File f) throws FileNotFoundException {
        if (!f.isFile()) {
            throw new FileNotFoundException(f.getPath());
        }
        return f;
    }

    public DicomDirWriter(File file, FileSetInformation fileSetInfo) throws IOException {
        super(new RandomAccessFile(file, "rw"), fileSetInfo);
        this.file = file;
        fileSetInfo.setOffsetFirstRootRecord(0);
        fileSetInfo.setOffsetLastRootRecord(0);
        this.raf.setLength(0L);
        this.out = new DicomOutputStream(this.raf);
        this.out.setExplicitSequenceLength(true);
        this.out.setExplicitItemLength(true);
        this.out.writeDicomFile(fileSetInfo.getDicomObject());
        this.out.writeHeader(266784, VR.SQ, 0);
        this.firstRecordPos = (int)this.out.getStreamPosition();
        this.recordSeqLen = 0L;
    }

    private void offsetFirstRootRecord(int val) {
        ByteUtils.int2bytesLE(val, this.dirInfoHeader, 8);
    }

    private int offsetFirstRootRecord() {
        return ByteUtils.bytesLE2int(this.dirInfoHeader, 8);
    }

    private void offsetLastRootRecord(int val) {
        ByteUtils.int2bytesLE(val, this.dirInfoHeader, 20);
    }

    private int offsetLastRootRecord() {
        return ByteUtils.bytesLE2int(this.dirInfoHeader, 20);
    }

    private void recordSeqLen(int val) {
        ByteUtils.int2bytesLE(this.isExplicitSequenceLength() ? val : -1, this.dirInfoHeader, 42);
    }

    public final boolean isExplicitItemLength() {
        return this.out.isExplicitItemLength();
    }

    public final void setExplicitItemLength(boolean explicitItemLength) {
        this.out.setExplicitItemLength(explicitItemLength);
    }

    public final boolean isExplicitItemLengthIfZero() {
        return this.out.isExplicitItemLengthIfZero();
    }

    public final void setExplicitItemLengthIfZero(boolean explicitItemLengthIfZero) {
        this.out.setExplicitItemLengthIfZero(explicitItemLengthIfZero);
    }

    public final boolean isExplicitSequenceLength() {
        return this.out.isExplicitSequenceLength();
    }

    public final void setExplicitSequenceLength(boolean explicitSequenceLength) {
        this.out.setExplicitSequenceLength(explicitSequenceLength);
    }

    public final boolean isExplicitSequenceLengthIfZero() {
        return this.out.isExplicitSequenceLengthIfZero();
    }

    public final void setExplicitSequenceLengthIfZero(boolean explicitSequenceLengthIfZero) {
        this.out.setExplicitSequenceLengthIfZero(explicitSequenceLengthIfZero);
    }

    public final boolean isIncludeGroupLength() {
        return this.out.isIncludeGroupLength();
    }

    public final void setIncludeGroupLength(boolean includeGroupLength) {
        this.out.setIncludeGroupLength(includeGroupLength);
    }

    public synchronized void addRootRecord(DicomObject rec) throws IOException {
        DicomObject lastRootRecord = this.lastRootRecord();
        if (lastRootRecord == null) {
            this.writeRecord(this.firstRecordPos, rec);
            this.filesetInfo.setOffsetFirstRootRecord((int)this.firstRecordPos);
        } else {
            this.addRecord(267264, lastRootRecord, rec);
        }
        this.filesetInfo.setOffsetLastRootRecord((int)rec.getItemOffset());
    }

    public synchronized DicomObject addPatientRecord(DicomObject patrec) throws IOException {
        DicomObject other = this.findPatientRecord(patrec.getString(0x100020));
        if (other != null) {
            return other;
        }
        this.addRootRecord(patrec);
        return patrec;
    }

    public synchronized void addSiblingRecord(DicomObject prevRec, DicomObject dcmobj) throws IOException {
        prevRec = this.lastSiblingOrThis(prevRec);
        this.addRecord(267264, prevRec, dcmobj);
        if (this.cachedLastChildRecord == prevRec) {
            this.cachedLastChildRecord = dcmobj;
        } else {
            this.cachedParentRecord = null;
            this.cachedLastChildRecord = null;
        }
        if ((long)this.filesetInfo.getOffsetLastRootRecord() == prevRec.getItemOffset()) {
            this.filesetInfo.setOffsetLastRootRecord((int)dcmobj.getItemOffset());
        }
    }

    public synchronized void addChildRecord(DicomObject parentRec, DicomObject dcmobj) throws IOException {
        if (parentRec == this.cachedParentRecord) {
            log.debug("Hit Parent/LastChild cache");
            this.addRecord(267264, this.cachedLastChildRecord, dcmobj);
        } else {
            DicomObject prevRec = this.lastChildRecord(parentRec);
            if (prevRec != null) {
                this.addRecord(267264, prevRec, dcmobj);
            } else {
                this.addRecord(267296, parentRec, dcmobj);
            }
            this.cachedParentRecord = parentRec;
        }
        this.cachedLastChildRecord = dcmobj;
    }

    public synchronized DicomObject addStudyRecord(DicomObject patrec, DicomObject styrec) throws IOException {
        DicomObject other = this.findStudyRecord(patrec, styrec.getString(0x20000D));
        if (other != null) {
            return other;
        }
        this.addChildRecord(patrec, styrec);
        return styrec;
    }

    public synchronized DicomObject addSeriesRecord(DicomObject styrec, DicomObject serrec) throws IOException {
        DicomObject other = this.findSeriesRecord(styrec, serrec.getString(0x20000E));
        if (other != null) {
            return other;
        }
        this.addChildRecord(styrec, serrec);
        return serrec;
    }

    public synchronized void deleteRecord(DicomObject rec) throws IOException {
        if (rec.getInt(267280) == 0) {
            return;
        }
        DicomObject child = this.readRecord(rec.getInt(267296));
        while (child != null) {
            this.deleteRecord(child);
            child = this.readRecord(child.getInt(267264));
        }
        rec.putInt(267280, VR.US, 0);
        this.markAsDirty(rec);
    }

    public synchronized void rollback() throws IOException {
        this.filesetInfo.setOffsetFirstRootRecord(this.offsetFirstRootRecord());
        this.filesetInfo.setOffsetLastRootRecord(this.offsetLastRootRecord());
        this.cache.clear();
        this.cachedParentRecord = null;
        this.cachedLastChildRecord = null;
        this.dirtyRecords.clear();
        if (this.rollbackLen != -1L) {
            this.recordSeqLen = this.rollbackLen - this.firstRecordPos;
            this.raf.seek(this.rollbackLen);
            if (!this.out.isExplicitSequenceLength() && !this.isEmpty()) {
                this.out.writeHeader(-73507, null, 0);
            }
            this.raf.setLength(this.raf.getFilePointer());
            this.rollbackLen = -1L;
            this.raf.seek(this.firstRecordPos - 14L);
            this.raf.writeShort(0);
            this.filesetInfo.setFileSetConsistencyFlag(0);
        }
    }

    public synchronized void commit() throws IOException {
        if (this.rollbackLen != -1L && !this.out.isExplicitSequenceLength()) {
            this.raf.seek(this.endPos());
            this.out.writeHeader(-73507, null, 0);
        }
        if (this.offsetFirstRootRecord() != this.filesetInfo.getOffsetFirstRootRecord()) {
            this.offsetFirstRootRecord(this.filesetInfo.getOffsetFirstRootRecord());
        }
        if (this.offsetLastRootRecord() != this.filesetInfo.getOffsetLastRootRecord()) {
            this.offsetLastRootRecord(this.filesetInfo.getOffsetLastRootRecord());
        }
        this.filesetInfo.setFileSetConsistencyFlag(65535);
        this.recordSeqLen((int)this.recordSeqLen);
        this.raf.seek(this.firstRecordPos - (long)this.dirInfoHeader.length);
        this.raf.write(this.dirInfoHeader, 0, this.dirInfoHeader.length);
        this.rollbackLen = -1L;
        int n = this.dirtyRecords.size();
        for (int i = 0; i < n; ++i) {
            this.writeDirRecordHeader(this.dirtyRecords.get(i));
        }
        this.dirtyRecords.clear();
        this.raf.seek(this.firstRecordPos - 14L);
        this.raf.writeShort(0);
        this.filesetInfo.setFileSetConsistencyFlag(0);
    }

    public void close() throws IOException {
        this.commit();
        super.close();
    }

    private void writeDirRecordHeader(DicomObject rec) throws IOException {
        ByteUtils.int2bytesLE(rec.getInt(267264), this.dirRecordHeader, 8);
        ByteUtils.ushort2bytesLE(rec.getInt(267280), this.dirRecordHeader, 20);
        ByteUtils.int2bytesLE(rec.getInt(267296), this.dirRecordHeader, 30);
        this.raf.seek(rec.getItemOffset() + 8L);
        this.raf.write(this.dirRecordHeader);
    }

    private void addRecord(int tag, DicomObject prevRecord, DicomObject dcmobj) throws IOException {
        long endPos = this.endPos();
        this.writeRecord(endPos, dcmobj);
        prevRecord.putInt(tag, VR.UL, (int)endPos);
        this.markAsDirty(prevRecord);
    }

    private long endPos() throws IOException {
        if (this.recordSeqLen == -1L) {
            long endPos = this.raf.length() - 12L;
            this.raf.seek(endPos);
            if (this.in.readHeader() == -73507) {
                this.recordSeqLen = (int)(endPos - this.firstRecordPos);
            } else {
                endPos = this.filesetInfo.getOffsetLastRootRecord();
                this.raf.seek(endPos);
                this.in.setStreamPosition(endPos);
                BasicDicomObject dcmobj = new BasicDicomObject();
                while (this.in.readHeader() == -73728) {
                    this.in.readDicomObject(dcmobj, this.in.valueLength());
                    dcmobj.clear();
                    endPos = this.in.getStreamPosition();
                }
                if (this.in.tag() != -73507) {
                    throw new IOException("Unexpected Tag " + TagUtils.toString(this.in.tag()) + " at offset " + endPos);
                }
                this.recordSeqLen = (int)(endPos - this.firstRecordPos);
            }
        }
        return this.firstRecordPos + this.recordSeqLen;
    }

    private void markAsDirty(DicomObject rec) {
        int index = Collections.binarySearch(this.dirtyRecords, rec, offsetComparator);
        if (index < 0) {
            this.dirtyRecords.add(-(index + 1), rec);
        }
    }

    private void writeRecord(long offset, DicomObject dcmobj) throws IOException {
        log.debug("Write record @ {} to file {}", (Object)new Long(offset), (Object)this.file);
        if (this.rollbackLen == -1L) {
            this.rollbackLen = offset;
            this.filesetInfo.setFileSetConsistencyFlag(65535);
            this.raf.seek(this.firstRecordPos - 14L);
            this.raf.writeShort(65535);
        }
        this.raf.seek(offset);
        this.out.setStreamPosition(offset);
        dcmobj.putInt(267264, VR.UL, 0);
        dcmobj.putInt(267280, VR.US, 65535);
        dcmobj.putInt(267296, VR.UL, 0);
        this.out.writeItem(dcmobj, this.in.getTransferSyntax());
        this.recordSeqLen = (int)(this.out.getStreamPosition() - this.firstRecordPos);
        this.cache.put((int)dcmobj.getItemOffset(), dcmobj);
    }

    public synchronized int purge() throws IOException {
        int[] purged = new int[]{0};
        DicomObject rec = this.readRecord(this.filesetInfo.getOffsetFirstRootRecord());
        while (rec != null) {
            if (rec.getInt(267280) != 0) {
                this.purge(rec, purged);
            }
            rec = this.readRecord(rec.getInt(267264));
        }
        return purged[0];
    }

    private boolean purge(DicomObject rec, int[] purged) throws IOException {
        boolean purge = !rec.containsValue(267520);
        DicomObject child = this.readRecord(rec.getInt(267296));
        while (child != null) {
            if (child.getInt(267280) != 0) {
                purge = this.purge(child, purged) && purge;
            }
            child = this.readRecord(child.getInt(267264));
        }
        if (purge) {
            this.deleteRecord(rec);
            purged[0] = purged[0] + 1;
        }
        return purge;
    }
}

