/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import org.dcm4che2.image.PartialComponentSampleModel;

public class PartialComponentColorModel
extends ColorModel {
    int subsampleX;
    int subsampleY;

    public PartialComponentColorModel(ColorSpace cspace, int subsampleX, int subsampleY) {
        super(24, new int[]{8, 8, 8}, cspace, false, false, 1, 0);
        this.subsampleX = subsampleX;
        this.subsampleY = subsampleY;
    }

    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm instanceof PartialComponentSampleModel;
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new PartialComponentSampleModel(w, h, this.subsampleX, this.subsampleY);
    }

    public int getAlpha(int pixel) {
        return 255;
    }

    public int getBlue(int pixel) {
        return pixel & 0xFF;
    }

    public int getGreen(int pixel) {
        return pixel & 0xFF00;
    }

    public int getRed(int pixel) {
        return pixel & 0xFF0000;
    }

    public int getAlpha(Object inData) {
        return 255;
    }

    public int getBlue(Object inData) {
        return this.getRGB(inData) & 0xFF;
    }

    public int getGreen(Object inData) {
        return this.getRGB(inData) >> 8 & 0xFF;
    }

    public int getRed(Object inData) {
        return this.getRGB(inData) >> 16;
    }

    public int getRGB(Object inData) {
        byte[] ba = (byte[])inData;
        ColorSpace cs = this.getColorSpace();
        float[] fba = new float[]{(float)(ba[0] & 0xFF) / 255.0f, (float)(ba[1] & 0xFF) / 255.0f, (float)(ba[2] & 0xFF) / 255.0f};
        float[] rgb = cs.toRGB(fba);
        int ret = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
        return ret;
    }

    public String toString(float[] rgb) {
        return "" + rgb[0] + "," + rgb[1] + "," + rgb[2];
    }

    public String toString(byte[] rgb) {
        return "" + rgb[0] + "," + rgb[1] + "," + rgb[2];
    }
}

