/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.MouseActionAdapter;
import org.weasis.core.api.image.ZoomOperation;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.dicom.viewer2d.EventManager;
import org.weasis.dicom.viewer2d.Messages;
import org.weasis.dicom.viewer2d.View2dContainer;
import org.weasis.dicom.viewer2d.View2dFactory;

public class ViewerPrefView
extends AbstractItemDialogPage {
    private final Hashtable labels = new Hashtable();
    private JSlider sliderWindow;
    private JSlider sliderLevel;
    private JSlider sliderZoom;
    private JSlider sliderRotation;
    private JSlider sliderScroll;
    private final JComboBox comboBoxInterpolation;

    public ViewerPrefView() {
        ActionState seqAction;
        ActionState rotateAction;
        ActionState zoomlAction;
        ActionState levelAction;
        this.setTitle(View2dFactory.NAME);
        this.labels.put(-100, new JLabel(Messages.getString("ViewerPrefView.low")));
        this.labels.put(0, new JLabel(Messages.getString("ViewerPrefView.mid")));
        this.labels.put(100, new JLabel(Messages.getString("ViewerPrefView.high")));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, Messages.getString("ViewerPrefView.mouse_sens"), 4, 2, null, null));
        this.add(panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        panel.setLayout(gbl_panel);
        JPanel panel_1 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel_1.getLayout();
        flowLayout.setAlignment(3);
        panel_1.setBorder(new TitledBorder(null, Messages.getString("ViewerPrefView.zoom"), 4, 2, null, null));
        this.add(panel_1);
        JLabel lblInterpolation = new JLabel(Messages.getString("ViewerPrefView.interp"));
        panel_1.add(lblInterpolation);
        EventManager eventManager = EventManager.getInstance();
        this.comboBoxInterpolation = new JComboBox<String>(ZoomOperation.INTERPOLATIONS);
        this.comboBoxInterpolation.setSelectedIndex(eventManager.getZoomSetting().getInterpolation());
        panel_1.add(this.comboBoxInterpolation);
        ActionState winAction = eventManager.getAction(ActionW.WINDOW);
        if (winAction instanceof MouseActionAdapter) {
            JLabel lblWindow = new JLabel(Messages.getString("ViewerPrefView.win"));
            GridBagConstraints gbc_lblWindow = new GridBagConstraints();
            gbc_lblWindow.anchor = 12;
            gbc_lblWindow.insets = new Insets(5, 0, 0, 0);
            gbc_lblWindow.gridx = 0;
            gbc_lblWindow.gridy = 0;
            panel.add((Component)lblWindow, gbc_lblWindow);
            this.sliderWindow = new JSlider(-100, 100, this.realValueToslider(((MouseActionAdapter)winAction).getMouseSensivity()));
            GridBagConstraints gbc_slider = new GridBagConstraints();
            gbc_slider.fill = 2;
            gbc_slider.anchor = 17;
            gbc_slider.insets = new Insets(5, 2, 0, 0);
            gbc_slider.gridx = 1;
            gbc_slider.gridy = 0;
            this.formatSlider(this.sliderWindow);
            panel.add((Component)this.sliderWindow, gbc_slider);
        }
        if ((levelAction = eventManager.getAction(ActionW.LEVEL)) instanceof MouseActionAdapter) {
            JLabel lblLevel = new JLabel(Messages.getString("ViewerPrefView.level"));
            GridBagConstraints gbc_lblLevel = new GridBagConstraints();
            gbc_lblLevel.anchor = 12;
            gbc_lblLevel.insets = new Insets(5, 15, 0, 0);
            gbc_lblLevel.gridx = 0;
            gbc_lblLevel.gridy = 1;
            panel.add((Component)lblLevel, gbc_lblLevel);
            this.sliderLevel = new JSlider(-100, 100, this.realValueToslider(((MouseActionAdapter)levelAction).getMouseSensivity()));
            GridBagConstraints gbc_slider_2 = new GridBagConstraints();
            gbc_slider_2.fill = 2;
            gbc_slider_2.anchor = 17;
            gbc_slider_2.insets = new Insets(5, 2, 0, 0);
            gbc_slider_2.gridx = 1;
            gbc_slider_2.gridy = 1;
            this.formatSlider(this.sliderLevel);
            panel.add((Component)this.sliderLevel, gbc_slider_2);
        }
        if ((zoomlAction = eventManager.getAction(ActionW.ZOOM)) instanceof MouseActionAdapter) {
            JLabel lblZoom = new JLabel(Messages.getString("ViewerPrefView.zoom"));
            GridBagConstraints gbc_lblZoom = new GridBagConstraints();
            gbc_lblZoom.anchor = 12;
            gbc_lblZoom.insets = new Insets(5, 0, 0, 0);
            gbc_lblZoom.gridx = 0;
            gbc_lblZoom.gridy = 2;
            panel.add((Component)lblZoom, gbc_lblZoom);
            this.sliderZoom = new JSlider(-100, 100, this.realValueToslider(((MouseActionAdapter)zoomlAction).getMouseSensivity()));
            GridBagConstraints gbc_slider = new GridBagConstraints();
            gbc_slider.fill = 2;
            gbc_slider.anchor = 17;
            gbc_slider.insets = new Insets(5, 2, 0, 0);
            gbc_slider.gridx = 1;
            gbc_slider.gridy = 2;
            this.formatSlider(this.sliderZoom);
            panel.add((Component)this.sliderZoom, gbc_slider);
        }
        if ((rotateAction = eventManager.getAction(ActionW.ROTATION)) instanceof MouseActionAdapter) {
            JLabel lblRotation = new JLabel(Messages.getString("ResetTools.rotation"));
            GridBagConstraints gbc_lblRotation = new GridBagConstraints();
            gbc_lblRotation.anchor = 12;
            gbc_lblRotation.insets = new Insets(5, 15, 0, 0);
            gbc_lblRotation.gridx = 0;
            gbc_lblRotation.gridy = 3;
            panel.add((Component)lblRotation, gbc_lblRotation);
            this.sliderRotation = new JSlider(-100, 100, this.realValueToslider(((MouseActionAdapter)rotateAction).getMouseSensivity()));
            GridBagConstraints gbc_slider_3 = new GridBagConstraints();
            gbc_slider_3.fill = 2;
            gbc_slider_3.anchor = 17;
            gbc_slider_3.insets = new Insets(5, 2, 0, 0);
            gbc_slider_3.gridx = 1;
            gbc_slider_3.gridy = 3;
            this.formatSlider(this.sliderRotation);
            panel.add((Component)this.sliderRotation, gbc_slider_3);
        }
        if ((seqAction = eventManager.getAction(ActionW.SCROLL_SERIES)) instanceof MouseActionAdapter) {
            JLabel lblImageScroll = new JLabel(Messages.getString("ViewerPrefView.scrool"));
            GridBagConstraints gbc_lblImageScroll = new GridBagConstraints();
            gbc_lblImageScroll.anchor = 12;
            gbc_lblImageScroll.insets = new Insets(5, 0, 5, 5);
            gbc_lblImageScroll.gridx = 0;
            gbc_lblImageScroll.gridy = 4;
            panel.add((Component)lblImageScroll, gbc_lblImageScroll);
            this.sliderScroll = new JSlider(-100, 100, this.realValueToslider(((MouseActionAdapter)seqAction).getMouseSensivity()));
            GridBagConstraints gbc_slider_1 = new GridBagConstraints();
            gbc_slider_1.fill = 2;
            gbc_slider_1.anchor = 17;
            gbc_slider_1.insets = new Insets(5, 2, 5, 0);
            gbc_slider_1.gridx = 1;
            gbc_slider_1.gridy = 4;
            this.formatSlider(this.sliderScroll);
            panel.add((Component)this.sliderScroll, gbc_slider_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAdditionalWindow() {
        ActionState seqAction;
        ActionState rotateAction;
        ActionState zoomlAction;
        ActionState levelAction;
        EventManager eventManager = EventManager.getInstance();
        ActionState winAction = eventManager.getAction(ActionW.WINDOW);
        if (winAction instanceof MouseActionAdapter) {
            ((MouseActionAdapter)winAction).setMouseSensivity(this.sliderToRealValue(this.sliderWindow.getValue()));
        }
        if ((levelAction = eventManager.getAction(ActionW.LEVEL)) instanceof MouseActionAdapter) {
            ((MouseActionAdapter)levelAction).setMouseSensivity(this.sliderToRealValue(this.sliderLevel.getValue()));
        }
        if ((zoomlAction = eventManager.getAction(ActionW.ZOOM)) instanceof MouseActionAdapter) {
            ((MouseActionAdapter)zoomlAction).setMouseSensivity(this.sliderToRealValue(this.sliderZoom.getValue()));
        }
        if ((rotateAction = eventManager.getAction(ActionW.ROTATION)) instanceof MouseActionAdapter) {
            ((MouseActionAdapter)rotateAction).setMouseSensivity(this.sliderToRealValue(this.sliderRotation.getValue()));
        }
        if ((seqAction = eventManager.getAction(ActionW.SCROLL_SERIES)) instanceof MouseActionAdapter) {
            ((MouseActionAdapter)seqAction).setMouseSensivity(this.sliderToRealValue(this.sliderScroll.getValue()));
        }
        int interpolation = this.comboBoxInterpolation.getSelectedIndex();
        eventManager.getZoomSetting().setInterpolation(interpolation);
        List list = UIManager.VIEWER_PLUGINS;
        synchronized (list) {
            for (ViewerPlugin p : UIManager.VIEWER_PLUGINS) {
                if (!(p instanceof View2dContainer)) continue;
                View2dContainer viewer = (View2dContainer)p;
                for (DefaultView2d v : viewer.getImagePanels()) {
                    v.changeZoomInterpolation(interpolation);
                }
            }
        }
    }

    public void resetoDefaultValues() {
    }

    private void formatSlider(JSlider slider) {
        slider.setPaintTicks(true);
        slider.setMajorTickSpacing(100);
        slider.setMinorTickSpacing(5);
        slider.setLabelTable(this.labels);
        slider.setPaintLabels(true);
    }

    private double sliderToRealValue(int value) {
        return Math.pow(10.0, (double)value * 3.0 / 100.0);
    }

    private int realValueToslider(double value) {
        return (int)(Math.log10(value) * 100.0 / 3.0);
    }
}

