/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.image.GridBagLayoutModel;
import org.weasis.core.api.image.LayoutConstraints;
import org.weasis.core.api.media.MimeInspector;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.dicom.explorer.DicomExplorer;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.viewer2d.EventManager;
import org.weasis.dicom.viewer2d.Messages;
import org.weasis.dicom.viewer2d.View2dContainer;

public class View2dFactory
implements SeriesViewerFactory {
    public static final String NAME = Messages.getString("View2dFactory.title");
    public static final Icon ICON = new ImageIcon(MimeInspector.class.getResource("/icon/16x16/dicom.png"));

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return NAME;
    }

    public String getDescription() {
        return "";
    }

    public SeriesViewer createSeriesViewer(Hashtable<String, Object> properties) {
        Object obj;
        GridBagLayoutModel model = ImageViewerPlugin.VIEWS_1x1;
        if (properties != null) {
            Object obj2 = properties.get(GridBagLayoutModel.class.getName());
            if (obj2 instanceof GridBagLayoutModel) {
                model = (GridBagLayoutModel)obj2;
            } else {
                ActionState layout;
                obj2 = properties.get(DefaultView2d.class.getName());
                if (obj2 instanceof Integer && (layout = EventManager.getInstance().getAction(ActionW.LAYOUT)) instanceof ComboItemListener) {
                    Object[] list;
                    for (Object m : list = ((ComboItemListener)layout).getAllItem()) {
                        if (!(m instanceof GridBagLayoutModel) || View2dFactory.getViewTypeNumber((GridBagLayoutModel)m, DefaultView2d.class) < (Integer)obj2) continue;
                        model = (GridBagLayoutModel)m;
                        break;
                    }
                }
            }
        }
        View2dContainer instance = new View2dContainer(model);
        if (properties != null && (obj = properties.get(DataExplorerModel.class.getName())) instanceof DicomModel) {
            DicomModel m = (DicomModel)obj;
            m.addPropertyChangeListener((PropertyChangeListener)instance);
        }
        return instance;
    }

    public static int getViewTypeNumber(GridBagLayoutModel layout, Class defaultClass) {
        int val = 0;
        if (layout != null && defaultClass != null) {
            Iterator enumVal = layout.getConstraints().keySet().iterator();
            while (enumVal.hasNext()) {
                try {
                    Class<?> clazz = Class.forName(((LayoutConstraints)enumVal.next()).getType());
                    if (!defaultClass.isAssignableFrom(clazz)) continue;
                    ++val;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return val;
    }

    public static void closeSeriesViewer(View2dContainer view2dContainer) {
        DataExplorerView dicomView = UIManager.getExplorerplugin((String)DicomExplorer.NAME);
        if (dicomView != null) {
            dicomView.getDataExplorerModel().removePropertyChangeListener((PropertyChangeListener)view2dContainer);
        }
    }

    public boolean canReadMimeType(String mimeType) {
        return "series/dicom".equals(mimeType);
    }

    public boolean isViewerCreatedByThisFactory(SeriesViewer viewer) {
        return viewer instanceof View2dContainer;
    }

    public int getLevel() {
        return 5;
    }
}

