/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.media.jai.PlanarImage;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.DecFormater;
import org.weasis.core.api.image.op.ByteLut;
import org.weasis.core.api.image.util.Unit;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.util.FontTools;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.image.AnnotationsLayer;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.display.CornerDisplay;
import org.weasis.dicom.codec.display.CornerInfoData;
import org.weasis.dicom.codec.display.Modality;
import org.weasis.dicom.codec.display.ModalityInfoData;
import org.weasis.dicom.codec.geometry.ImageOrientation;
import org.weasis.dicom.explorer.DicomExplorer;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.pref.ModalityPrefView;
import org.weasis.dicom.viewer2d.Messages;

public class InfoLayer
implements AnnotationsLayer {
    private final HashMap<String, Boolean> displayPreferences = new HashMap();
    private boolean visible = true;
    private final Color color = Color.yellow;
    private static final int BORDER = 10;
    private final DefaultView2d view2DPane;
    private final DicomModel model;
    private String pixelInfo = "";
    private final Rectangle pixelInfoBound;
    private final Rectangle preloadingProgressBound;

    public InfoLayer(DefaultView2d view2DPane) {
        this.view2DPane = view2DPane;
        this.displayPreferences.put(ANNOTATIONS, true);
        this.displayPreferences.put(IMAGE_ORIENTATION, true);
        this.displayPreferences.put(SCALE, true);
        this.displayPreferences.put(LUT, false);
        this.displayPreferences.put(PIXEL, true);
        this.displayPreferences.put(WINDOW_LEVEL, true);
        this.displayPreferences.put(ZOOM, true);
        this.displayPreferences.put(ROTATION, false);
        this.displayPreferences.put(FRAME, true);
        this.pixelInfoBound = new Rectangle();
        this.preloadingProgressBound = new Rectangle();
        DataExplorerView dicomView = UIManager.getExplorerplugin((String)DicomExplorer.NAME);
        this.model = dicomView != null ? (DicomModel)dicomView.getDataExplorerModel() : null;
    }

    public void paint(Graphics2D g2) {
        ImageElement image = this.view2DPane.getImage();
        if (!this.visible || image == null) {
            return;
        }
        Modality mod = Modality.getModality((String)((String)this.view2DPane.getSeries().getTagValue(TagW.Modality)));
        ModalityInfoData modality = ModalityPrefView.getModlatityInfos((Modality)mod);
        Rectangle bound = this.view2DPane.getBounds();
        float midx = (float)bound.width / 2.0f;
        float midy = (float)bound.height / 2.0f;
        g2.setPaint(this.color);
        float fontHeight = FontTools.getAccurateFontHeight((Graphics)g2);
        float midfontHeight = fontHeight * FontTools.getMidFontHeightFactor();
        float drawY = bound.height - 10;
        DicomImageElement dcm = null;
        if (image instanceof DicomImageElement) {
            dcm = (DicomImageElement)image;
        }
        if (!image.isReadable()) {
            String[] desc;
            String message = Messages.getString("InfoLayer.msg_not_read");
            float y = midy;
            this.paintRedFontOutline(g2, message, midx - (float)(g2.getFontMetrics().stringWidth(message) / 2), y);
            String tsuid = (String)image.getTagValue(TagW.TransferSyntaxUID);
            if (tsuid != null) {
                tsuid = Messages.getString("InfoLayer.tsuid") + tsuid;
                this.paintRedFontOutline(g2, tsuid, midx - (float)(g2.getFontMetrics().stringWidth(tsuid) / 2), y += fontHeight);
            }
            if ((desc = image.getMediaReader().getReaderDescription()) != null) {
                for (String str : desc) {
                    if (str == null) continue;
                    this.paintRedFontOutline(g2, str, midx - (float)(g2.getFontMetrics().stringWidth(str) / 2), y += fontHeight);
                }
            }
        }
        if (image.isReadable() && this.getDisplayPreferences(SCALE)) {
            this.drawScale(g2, bound, fontHeight);
        }
        if (image.isReadable() && this.getDisplayPreferences(LUT)) {
            this.drawLUT(g2, bound, midfontHeight);
        }
        if (dcm != null) {
            drawY -= fontHeight;
            String tsuid = this.getLossyTransferSyntaxUID((String)dcm.getTagValue(TagW.TransferSyntaxUID));
            if (tsuid != null) {
                Integer rate = (Integer)this.view2DPane.getSeries().getTagValue(TagW.WadoCompressionRate);
                this.paintRedFontOutline(g2, Messages.getString("InfoLayer.lossy") + tsuid + (rate == null || rate < 1 ? "" : " " + rate + Messages.getString("InfoLayer.percent_symb")), 10.0f, drawY);
                drawY -= fontHeight;
            }
        }
        if (this.getDisplayPreferences(PIXEL)) {
            String str = Messages.getString("InfoLayer.pixel") + this.pixelInfo;
            this.paintFontOutline(g2, str, 10.0f, drawY - 1.0f);
            this.pixelInfoBound.setBounds(8, (int)(drawY -= fontHeight + 2.0f) + 3, g2.getFontMetrics().stringWidth(str) + 4, (int)fontHeight + 2);
        }
        if (this.getDisplayPreferences(WINDOW_LEVEL)) {
            this.paintFontOutline(g2, Messages.getString("InfoLayer.win") + this.view2DPane.getActionValue(ActionW.WINDOW.cmd()) + Messages.getString("InfoLayer.level") + this.view2DPane.getActionValue(ActionW.LEVEL.cmd()), 10.0f, drawY);
            drawY -= fontHeight;
        }
        if (this.getDisplayPreferences(ZOOM)) {
            this.paintFontOutline(g2, Messages.getString("InfoLayer.zoom") + DecFormater.twoDecimal((double)(this.view2DPane.getViewModel().getViewScale() * 100.0)) + Messages.getString("InfoLayer.percent_symb"), 10.0f, drawY);
            drawY -= fontHeight;
        }
        if (this.getDisplayPreferences(ROTATION)) {
            this.paintFontOutline(g2, Messages.getString("InfoLayer.angle") + this.view2DPane.getActionValue(ActionW.ROTATION.cmd()) + Messages.getString("InfoLayer.angle_symb"), 10.0f, drawY);
            drawY -= fontHeight;
        }
        if (this.getDisplayPreferences(FRAME)) {
            Integer inst;
            String instance = "";
            if (dcm != null && (inst = (Integer)dcm.getTagValue(TagW.InstanceNumber)) != null && inst != 0) {
                instance = "[" + inst + "] ";
            }
            this.paintFontOutline(g2, Messages.getString("InfoLayer.frame") + instance + (this.view2DPane.getFrameIndex() + 1) + " / " + this.view2DPane.getSeries().size(), 10.0f, drawY);
            drawY -= fontHeight;
            Double imgProgression = (Double)this.view2DPane.getActionValue(ActionW.PROGRESSION.cmd());
            if (imgProgression != null) {
                int pColor = (int)(510.0 * imgProgression);
                g2.setPaint(new Color(510 - pColor > 255 ? 255 : 510 - pColor, pColor > 255 ? 255 : pColor, 0));
                g2.fillOval(10, (int)(drawY -= 13.0f), 13, 13);
                drawY -= 2.0f;
            }
        }
        if (this.getDisplayPreferences(ANNOTATIONS) && dcm != null) {
            int j;
            String str;
            Series series = (Series)this.view2DPane.getSeries();
            MediaSeriesGroup study = this.model.getParent((MediaSeriesGroup)series, DicomModel.study);
            MediaSeriesGroup patient = this.model.getParent((MediaSeriesGroup)series, DicomModel.patient);
            CornerInfoData corner = modality.getCornerInfo(CornerDisplay.TOP_LEFT);
            drawY = fontHeight;
            TagW[] infos = corner.getInfos();
            for (j = 0; j < infos.length; ++j) {
                Object value;
                if (infos[j] == null || (value = this.getTagValue(infos[j], patient, study, series, (ImageElement)dcm)) == null) continue;
                this.paintFontOutline(g2, infos[j].getFormattedText(value), 10.0f, drawY);
                drawY += fontHeight;
            }
            corner = modality.getCornerInfo(CornerDisplay.TOP_RIGHT);
            drawY = fontHeight;
            infos = corner.getInfos();
            for (j = 0; j < infos.length; ++j) {
                Object value;
                if (infos[j] == null || (value = this.getTagValue(infos[j], patient, study, series, (ImageElement)dcm)) == null) continue;
                str = infos[j].getFormattedText(value);
                this.paintFontOutline(g2, str, bound.width - g2.getFontMetrics().stringWidth(str) - 10, drawY);
                drawY += fontHeight;
            }
            corner = modality.getCornerInfo(CornerDisplay.BOTTOM_RIGHT);
            drawY = bound.height - 10;
            infos = corner.getInfos();
            for (j = infos.length - 1; j >= 0; --j) {
                Object value;
                if (infos[j] == null || (value = this.getTagValue(infos[j], patient, study, series, (ImageElement)dcm)) == null) continue;
                str = infos[j].getFormattedText(value);
                this.paintFontOutline(g2, str, bound.width - g2.getFontMetrics().stringWidth(str) - 10, drawY);
                drawY -= fontHeight;
            }
            this.drawSeriesInMemoryState(g2, this.view2DPane.getSeries(), bound.width - 10, (int)(drawY - 5.0f));
            drawY -= 8.0f;
            double[] v = (double[])dcm.getTagValue(TagW.ImageOrientationPatient);
            Integer rows = (Integer)dcm.getTagValue(TagW.Rows);
            Integer columns = (Integer)dcm.getTagValue(TagW.Columns);
            StringBuffer orientation = new StringBuffer(mod.name());
            if (rows != null && columns != null) {
                orientation.append(" (");
                orientation.append(dcm.getTagValue(TagW.Columns));
                orientation.append("x");
                orientation.append(dcm.getTagValue(TagW.Rows));
                orientation.append(")");
            }
            if (this.getDisplayPreferences(IMAGE_ORIENTATION) && v != null && v.length == 6) {
                int angle;
                orientation.append(" - ");
                orientation.append(ImageOrientation.makeImageOrientationLabelFromImageOrientationPatient((double)v[0], (double)v[1], (double)v[2], (double)v[3], (double)v[4], (double)v[5]));
                char colLeft = InfoLayer.getMajorAxisFromPatientRelativeDirectionCosine(v[0], v[1], v[2]);
                char rowTop = InfoLayer.getMajorAxisFromPatientRelativeDirectionCosine(v[3], v[4], v[5]);
                if (((Boolean)this.view2DPane.getActionValue(ActionW.FLIP.cmd())).booleanValue()) {
                    colLeft = InfoLayer.getImageOrientationOposite(colLeft);
                }
                if ((angle = ((Integer)this.view2DPane.getActionValue(ActionW.ROTATION.cmd())).intValue()) > 45) {
                    char rowBottom = InfoLayer.getImageOrientationOposite(rowTop);
                    char colRight = InfoLayer.getImageOrientationOposite(colLeft);
                    if (angle <= 135) {
                        rowTop = colLeft;
                        colLeft = rowBottom;
                    } else if (angle <= 225) {
                        rowTop = rowBottom;
                        colLeft = colRight;
                    } else if (angle <= 315) {
                        colLeft = rowTop;
                        rowTop = colRight;
                    }
                }
                this.paintFontOutline(g2, "[" + rowTop + "]", midx, 15.0f);
                this.paintFontOutline(g2, "[" + colLeft + "]", 10.0f, midy + fontHeight / 2.0f);
            }
            this.paintFontOutline(g2, orientation.toString(), 10.0f, bound.height - 10);
        }
    }

    private void drawSeriesInMemoryState(Graphics2D g2d, MediaSeries series, int x, int y) {
        if (series instanceof DicomSeries) {
            DicomSeries s = (DicomSeries)series;
            boolean[] list = s.getImageInMemoryList();
            int length = list.length > 120 ? 120 : list.length;
            this.preloadingProgressBound.setBounds((x -= list.length) - 1, y - 1, length + 1, 6);
            g2d.fillRect(x, y, length, 5);
            g2d.setPaint(Color.BLACK);
            g2d.draw(this.preloadingProgressBound);
            double factorResize = list.length > 120 ? 120.0 / (double)list.length : 1.0;
            for (int i = 0; i < list.length; ++i) {
                if (list[i]) continue;
                int val = x + (int)((double)i * factorResize);
                g2d.drawLine(val, y, val, y + 3);
            }
        }
    }

    private String getLossyTransferSyntaxUID(String tsuid) {
        if (tsuid != null) {
            if ("1.2.840.10008.1.2.4.50".equals(tsuid)) {
                return "JPEG Baseline";
            }
            if ("1.2.840.10008.1.2.4.51".equals(tsuid)) {
                return "JPEG Extended";
            }
            if ("1.2.840.10008.1.2.4.81".equals(tsuid)) {
                return "JPEG-LS (Near-Lossless)";
            }
            if ("1.2.840.10008.1.2.4.91".equals(tsuid)) {
                return "JPEG 2000";
            }
        }
        return null;
    }

    private Object getTagValue(TagW tag, MediaSeriesGroup patient, MediaSeriesGroup study, Series series, ImageElement image) {
        if (image.containTagKey(tag)) {
            return image.getTagValue(tag);
        }
        if (series.containTagKey(tag)) {
            return series.getTagValue(tag);
        }
        if (study.containTagKey(tag)) {
            return study.getTagValue(tag);
        }
        if (patient.containTagKey(tag)) {
            return patient.getTagValue(tag);
        }
        return null;
    }

    public void paintFontOutline(Graphics2D g2, String str, float x, float y) {
        g2.setPaint(Color.BLACK);
        g2.drawString(str, x - 1.0f, y - 1.0f);
        g2.drawString(str, x - 1.0f, y);
        g2.drawString(str, x - 1.0f, y + 1.0f);
        g2.drawString(str, x, y - 1.0f);
        g2.drawString(str, x, y + 1.0f);
        g2.drawString(str, x + 1.0f, y - 1.0f);
        g2.drawString(str, x + 1.0f, y);
        g2.drawString(str, x + 1.0f, y + 1.0f);
        g2.setPaint(Color.WHITE);
        g2.drawString(str, x, y);
    }

    public void paintRedFontOutline(Graphics2D g2, String str, float x, float y) {
        g2.setPaint(Color.BLACK);
        g2.drawString(str, x - 1.0f, y - 1.0f);
        g2.drawString(str, x - 1.0f, y);
        g2.drawString(str, x - 1.0f, y + 1.0f);
        g2.drawString(str, x, y - 1.0f);
        g2.drawString(str, x, y + 1.0f);
        g2.drawString(str, x + 1.0f, y - 1.0f);
        g2.drawString(str, x + 1.0f, y);
        g2.drawString(str, x + 1.0f, y + 1.0f);
        g2.setPaint(Color.RED);
        g2.drawString(str, x, y);
    }

    public Rectangle2D getOutLine(Line2D l) {
        Rectangle2D r = l.getBounds2D();
        r.setFrame(r.getX() - 1.0, r.getY() - 1.0, r.getWidth() + 2.0, r.getHeight() + 2.0);
        return r;
    }

    public void drawLUT(Graphics2D g2, Rectangle bound, float midfontHeight) {
        ByteLut lut = (ByteLut)this.view2DPane.getActionValue(ActionW.LUT.cmd());
        if (lut != null && bound.height > 350) {
            if (lut.getLutTable() == null) {
                lut = ByteLut.grayLUT;
            }
            byte[][] table = (Boolean)this.view2DPane.getActionValue(ActionW.INVERSELUT.cmd()) != false ? lut.getInvertedLutTable() : lut.getLutTable();
            float length = table[0].length;
            float x = (float)bound.width - 30.0f;
            float y = (float)bound.height / 2.0f - length / 2.0f;
            g2.setPaint(Color.black);
            Rectangle2D.Float rect = new Rectangle2D.Float(x - 11.0f, y - 2.0f, 12.0f, 2.0f);
            g2.draw(rect);
            int separation = 4;
            float step = length / (float)separation;
            for (int i = 1; i < separation; ++i) {
                float posY = y + (float)i * step;
                rect.setRect(x - 6.0f, posY - 1.0f, 7.0f, 2.0f);
                g2.draw(rect);
            }
            rect.setRect(x - 11.0f, y + length, 12.0f, 2.0f);
            g2.draw(rect);
            rect.setRect(x - 2.0f, y - 2.0f, 23.0f, length + 4.0f);
            g2.draw(rect);
            g2.setPaint(Color.white);
            Line2D.Float line = new Line2D.Float(x - 10.0f, y - 1.0f, x - 1.0f, y - 1.0f);
            g2.draw(line);
            float stepWindow = ((Float)this.view2DPane.getActionValue(ActionW.WINDOW.cmd())).floatValue() / (float)separation;
            float firstlevel = ((Float)this.view2DPane.getActionValue(ActionW.LEVEL.cmd())).floatValue() - stepWindow * 2.0f;
            String str = "" + (int)firstlevel;
            this.paintFontOutline(g2, str, x - (float)g2.getFontMetrics().stringWidth(str) - 12.0f, y + midfontHeight);
            for (int i = 1; i < separation; ++i) {
                float posY = y + (float)i * step;
                line.setLine(x - 5.0f, posY, x - 1.0f, posY);
                g2.draw(line);
                str = "" + (int)(firstlevel + (float)i * stepWindow);
                this.paintFontOutline(g2, str, x - (float)g2.getFontMetrics().stringWidth(str) - 7.0f, posY + midfontHeight);
            }
            line.setLine(x - 10.0f, y + length + 1.0f, x - 1.0f, y + length + 1.0f);
            g2.draw(line);
            str = "" + (int)(firstlevel + 4.0f * stepWindow);
            this.paintFontOutline(g2, str, x - (float)g2.getFontMetrics().stringWidth(str) - 12.0f, y + length + midfontHeight);
            rect.setRect(x - 1.0f, y - 1.0f, 21.0f, length + 2.0f);
            g2.draw(rect);
            int k = 0;
            while ((float)k < length) {
                g2.setPaint(new Color(table[0][k] & 0xFF, table[1][k] & 0xFF, table[2][k] & 0xFF));
                rect.setRect(x, y + (float)k, 19.0f, 1.0f);
                g2.draw(rect);
                ++k;
            }
        }
    }

    public void drawScale(Graphics2D g2d, Rectangle bound, float fontHeight) {
        double scaleSizeY;
        int i;
        ImageElement image = this.view2DPane.getImage();
        PlanarImage source = image.getImage();
        if (source == null) {
            return;
        }
        double zoomFactor = this.view2DPane.getViewModel().getViewScale();
        double scale = image.getPixelSize() / zoomFactor;
        double scaleSizex = this.ajustShowScale(scale, (int)Math.min(zoomFactor * (double)source.getWidth() * image.getRescaleX(), (double)bound.width / 2.0));
        if (scaleSizex > 30.0) {
            double secBar;
            int k;
            int i2;
            Unit[] unit = new Unit[]{image.getPixelSpacingUnit()};
            String str = this.ajustLengthDisplay(scaleSizex * scale, unit);
            g2d.setPaint(this.color);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(Color.black);
            double posx = (double)bound.width / 2.0 - scaleSizex / 2.0;
            double posy = bound.height - 10;
            Line2D.Double line = new Line2D.Double(posx, posy, posx + scaleSizex, posy);
            g2d.draw(this.getOutLine(line));
            ((Line2D)line).setLine(posx, posy - 15.0, posx, posy);
            g2d.draw(this.getOutLine(line));
            ((Line2D)line).setLine(posx + scaleSizex, posy - 15.0, posx + scaleSizex, posy);
            g2d.draw(this.getOutLine(line));
            int divisor = str.indexOf("5") == -1 ? (str.indexOf("2") == -1 ? 10 : 2) : 5;
            double divSquare = scaleSizex / (double)divisor;
            for (i2 = 1; i2 < divisor; ++i2) {
                ((Line2D)line).setLine(posx + divSquare * (double)i2, posy, posx + divSquare * (double)i2, posy - 10.0);
                g2d.draw(this.getOutLine(line));
            }
            if (divSquare > 90.0) {
                double secondSquare = divSquare / 10.0;
                for (i = 0; i < divisor; ++i) {
                    for (k = 1; k < 10; ++k) {
                        secBar = posx + divSquare * (double)i + secondSquare * (double)k;
                        ((Line2D)line).setLine(secBar, posy, secBar, posy - 5.0);
                        g2d.draw(this.getOutLine(line));
                    }
                }
            }
            g2d.setPaint(Color.white);
            ((Line2D)line).setLine(posx, posy, posx + scaleSizex, posy);
            g2d.draw(line);
            ((Line2D)line).setLine(posx, posy - 15.0, posx, posy);
            g2d.draw(line);
            ((Line2D)line).setLine(posx + scaleSizex, posy - 15.0, posx + scaleSizex, posy);
            g2d.draw(line);
            for (i2 = 0; i2 < divisor; ++i2) {
                ((Line2D)line).setLine(posx + divSquare * (double)i2, posy, posx + divSquare * (double)i2, posy - 10.0);
                g2d.draw(line);
            }
            if (divSquare > 90.0) {
                double secondSquare = divSquare / 10.0;
                for (i = 0; i < divisor; ++i) {
                    for (k = 1; k < 10; ++k) {
                        secBar = posx + divSquare * (double)i + secondSquare * (double)k;
                        ((Line2D)line).setLine(secBar, posy, secBar, posy - 5.0);
                        g2d.draw(line);
                    }
                }
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            String pixSizeDesc = image.getPixelSizeCalibrationDescription();
            if (pixSizeDesc != null) {
                this.paintFontOutline(g2d, pixSizeDesc, (float)(posx + scaleSizex + 5.0), (float)posy - fontHeight);
            }
            str = str + " " + unit[0].getAbbreviation();
            this.paintFontOutline(g2d, str, (float)(posx + scaleSizex + 5.0), (float)posy);
        }
        if ((scaleSizeY = this.ajustShowScale(scale, (int)Math.min(zoomFactor * (double)source.getHeight() * image.getRescaleY(), (double)bound.height / 2.0))) > 30.0) {
            double secBar;
            int k;
            Unit[] unit = new Unit[]{image.getPixelSpacingUnit()};
            String str = this.ajustLengthDisplay(scaleSizeY * scale, unit);
            g2d.setPaint(this.color);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(Color.black);
            double posx = 30.0;
            double posy = (double)bound.height / 2.0 - scaleSizeY / 2.0;
            Line2D.Double line = new Line2D.Double(posx, posy, posx, posy + scaleSizeY);
            g2d.draw(this.getOutLine(line));
            ((Line2D)line).setLine(posx, posy, posx + 15.0, posy);
            g2d.draw(this.getOutLine(line));
            ((Line2D)line).setLine(posx, posy + scaleSizeY, posx + 15.0, posy + scaleSizeY);
            g2d.draw(this.getOutLine(line));
            int divisor = str.indexOf("5") == -1 ? (str.indexOf("2") == -1 ? 10 : 2) : 5;
            double divSquare = scaleSizeY / (double)divisor;
            for (i = 0; i < divisor; ++i) {
                ((Line2D)line).setLine(posx, posy + divSquare * (double)i, posx + 10.0, posy + divSquare * (double)i);
                g2d.draw(this.getOutLine(line));
            }
            if (divSquare > 90.0) {
                double secondSquare = divSquare / 10.0;
                for (int i3 = 0; i3 < divisor; ++i3) {
                    for (k = 1; k < 10; ++k) {
                        secBar = posy + divSquare * (double)i3 + secondSquare * (double)k;
                        ((Line2D)line).setLine(posx, secBar, posx + 5.0, secBar);
                        g2d.draw(this.getOutLine(line));
                    }
                }
            }
            g2d.setPaint(Color.white);
            ((Line2D)line).setLine(posx, posy, posx, posy + scaleSizeY);
            g2d.draw(line);
            ((Line2D)line).setLine(posx, posy, posx + 15.0, posy);
            g2d.draw(line);
            ((Line2D)line).setLine(posx, posy + scaleSizeY, posx + 15.0, posy + scaleSizeY);
            g2d.draw(line);
            for (int i4 = 0; i4 < divisor; ++i4) {
                ((Line2D)line).setLine(posx, posy + divSquare * (double)i4, posx + 10.0, posy + divSquare * (double)i4);
                g2d.draw(line);
            }
            if (divSquare > 90.0) {
                double secondSquare = divSquare / 10.0;
                for (int i5 = 0; i5 < divisor; ++i5) {
                    for (k = 1; k < 10; ++k) {
                        secBar = posy + divSquare * (double)i5 + secondSquare * (double)k;
                        ((Line2D)line).setLine(posx, secBar, posx + 5.0, secBar);
                        g2d.draw(line);
                    }
                }
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            this.paintFontOutline(g2d, str + " " + unit[0].getAbbreviation(), (int)posx, (int)(posy - 5.0));
        }
    }

    private double ajustShowScale(double ratio, int maxLength) {
        int digits = (int)(Math.log((double)maxLength * ratio) / Math.log(10.0) + 1.0);
        double scaleLength = Math.pow(10.0, digits);
        double scaleSize = scaleLength / ratio;
        int loop = 0;
        while ((int)scaleSize > maxLength) {
            scaleLength /= this.findGeometricSuite(scaleLength);
            scaleSize = scaleLength / ratio;
            if (++loop <= 50) continue;
            return 0.0;
        }
        return scaleSize;
    }

    public double findGeometricSuite(double length) {
        int shift = (int)(Math.log(length) / Math.log(10.0) + 0.1);
        int firstDigit = (int)(length / Math.pow(10.0, shift) + 0.5);
        if (firstDigit == 5) {
            return 2.5;
        }
        return 2.0;
    }

    public String ajustLengthDisplay(double scaleLength, Unit[] unit) {
        double ajustScaleLength = scaleLength;
        Unit ajustUnit = unit[0];
        if (scaleLength < 1.0) {
            Unit down = ajustUnit;
            while ((down = down.getDownUnit()) != null) {
                double length = scaleLength * down.getConversionRatio(unit[0].getConvFactor());
                if (!(length > 1.0)) continue;
                ajustUnit = down;
                ajustScaleLength = length;
                break;
            }
        } else if (scaleLength > 10.0) {
            double length;
            Unit up = ajustUnit;
            while ((up = up.getUpUnit()) != null && !((length = scaleLength * up.getConversionRatio(unit[0].getConvFactor())) < 1.0)) {
                ajustUnit = up;
                ajustScaleLength = length;
            }
        }
        unit[0] = ajustUnit;
        if (ajustScaleLength < 1.0) {
            return ajustScaleLength < 0.001 ? DecFormater.scientificFormat((double)ajustScaleLength) : DecFormater.fourDecimal((double)ajustScaleLength);
        }
        return ajustScaleLength > 50000.0 ? DecFormater.scientificFormat((double)ajustScaleLength) : DecFormater.twoDecimal((double)ajustScaleLength);
    }

    public static final char getImageOrientationOposite(char c) {
        switch (c) {
            case 'L': {
                return 'R';
            }
            case 'R': {
                return 'L';
            }
            case 'P': {
                return 'A';
            }
            case 'A': {
                return 'P';
            }
            case 'H': {
                return 'F';
            }
            case 'F': {
                return 'H';
            }
        }
        return ' ';
    }

    public static final char getMajorAxisFromPatientRelativeDirectionCosine(double x, double y, double z) {
        int axis = 32;
        int orientationX = x < 0.0 ? 76 : 82;
        int orientationY = y < 0.0 ? 80 : 65;
        int orientationZ = z < 0.0 ? 72 : 70;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        if (absX > 0.8 && absX > absY && absX > absZ) {
            axis = orientationX;
        } else if (absY > 0.8 && absY > absX && absY > absZ) {
            axis = orientationY;
        } else if (absZ > 0.8 && absZ > absX && absZ > absY) {
            axis = orientationZ;
        }
        return (char)axis;
    }

    public boolean getDisplayPreferences(String item) {
        Boolean val = this.displayPreferences.get(item);
        return val == null ? false : val;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getLevel() {
        return 0;
    }

    public void setLevel(int i) {
    }

    public boolean setDisplayPreferencesValue(String displayItem, boolean selected) {
        boolean selected2 = this.getDisplayPreferences(displayItem);
        this.displayPreferences.put(displayItem, selected);
        return selected != selected2;
    }

    public Rectangle getPreloadingProgressBound() {
        return this.preloadingProgressBound;
    }

    public Rectangle getPixelInfoBound() {
        return this.pixelInfoBound;
    }

    public void setPixelInfo(String pixelInfo) {
        this.pixelInfo = pixelInfo;
    }
}

