/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer.wado;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.service.BundleTools;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.wado.DownloadManager;
import org.weasis.dicom.explorer.wado.DownloadPriority;
import org.weasis.dicom.explorer.wado.LoadSeries;

public class LoadRemoteDicom
extends SwingWorker<Boolean, String> {
    public static final String CODOWNLOAD_SERIES_NB = "wado.codownload.series.nb";
    public static final BlockingQueue<Runnable> loadingQueue = new PriorityBlockingQueue<Runnable>(10, new PriorityTaskComparator());
    public static final ThreadPoolExecutor executor = new ThreadPoolExecutor(BundleTools.SYSTEM_PREFERENCES.getIntProperty("wado.codownload.series.nb", 3), BundleTools.SYSTEM_PREFERENCES.getIntProperty("wado.codownload.series.nb", 3), 0L, TimeUnit.MILLISECONDS, loadingQueue);
    public static final ArrayList<LoadSeries> currentTasks = new ArrayList();
    private final String[] xmlFiles;
    private final DicomModel dicomModel;

    public LoadRemoteDicom(String[] xmlFiles, DataExplorerModel explorerModel) {
        if (xmlFiles == null || !(explorerModel instanceof DicomModel)) {
            throw new IllegalArgumentException("invalid parameters");
        }
        this.xmlFiles = xmlFiles;
        this.dicomModel = (DicomModel)explorerModel;
    }

    public LoadRemoteDicom(File[] xmlFiles, DataExplorerModel explorerModel) {
        if (xmlFiles == null || !(explorerModel instanceof DicomModel)) {
            throw new IllegalArgumentException("invalid parameters");
        }
        String[] xmlRef = new String[xmlFiles.length];
        for (int i = 0; i < xmlFiles.length; ++i) {
            if (xmlFiles[i] == null) continue;
            xmlRef[i] = xmlFiles[i].getAbsolutePath();
        }
        this.xmlFiles = xmlRef;
        this.dicomModel = (DicomModel)explorerModel;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        for (int i = 0; i < this.xmlFiles.length; ++i) {
            if (this.xmlFiles[i] == null) continue;
            URI uri = null;
            try {
                ArrayList<LoadSeries> wadoTasks;
                if (!this.xmlFiles[i].startsWith("http")) {
                    try {
                        File file = new File(this.xmlFiles[i]);
                        if (file.canRead()) {
                            uri = file.toURI();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (uri == null) {
                    uri = new URL(this.xmlFiles[i]).toURI();
                }
                if ((wadoTasks = DownloadManager.buildDicomSeriesFromXml(uri, this.dicomModel)) == null) continue;
                for (LoadSeries s : wadoTasks) {
                    loadingQueue.offer(s);
                }
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        Runnable[] tasks = loadingQueue.toArray(new Runnable[loadingQueue.size()]);
        for (int i = 0; i < tasks.length; ++i) {
            currentTasks.add((LoadSeries)tasks[i]);
        }
        executor.prestartAllCoreThreads();
        return true;
    }

    @Override
    protected void done() {
    }

    public static void stopDownloading(DicomSeries series) {
        if (series != null) {
            for (LoadSeries loading : currentTasks) {
                if (loading.getDicomSeries() != series) continue;
                currentTasks.remove(loading);
                loadingQueue.remove(loading);
                if (!SwingWorker.StateValue.STARTED.equals((Object)loading.getState())) break;
                loading.cancel(true);
                break;
            }
        }
    }

    private static class PriorityTaskComparator
    implements Comparator<Runnable>,
    Serializable {
        private static final long serialVersionUID = 513213203958362767L;

        private PriorityTaskComparator() {
        }

        @Override
        public int compare(Runnable r1, Runnable r2) {
            LoadSeries o1 = (LoadSeries)r1;
            LoadSeries o2 = (LoadSeries)r2;
            DownloadPriority val1 = o1.getPriority();
            DownloadPriority val2 = o2.getPriority();
            int rep = val1.getPriority().compareTo(val2.getPriority());
            if (rep != 0) {
                return rep;
            }
            rep = val1.getPatientName().compareTo(val2.getPatientName());
            if (rep != 0) {
                return rep;
            }
            if (val1.getStudyDate() != null && val2.getStudyDate() != null && (rep = val2.getStudyDate().compareTo(val1.getStudyDate())) != 0) {
                return rep;
            }
            rep = val1.getStudyInstanceUID().compareTo(val2.getStudyInstanceUID());
            if (rep != 0) {
                return rep;
            }
            rep = val1.getSeriesNumber().compareTo(val2.getSeriesNumber());
            if (rep != 0) {
                return rep;
            }
            String s1 = (String)o1.getDicomSeries().getTagValue(TagW.SubseriesInstanceUID);
            String s2 = (String)o2.getDicomSeries().getTagValue(TagW.SubseriesInstanceUID);
            return s1.compareTo(s2);
        }
    }
}

