/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer.pref;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.dicom.codec.TransferSyntax;
import org.weasis.dicom.explorer.Messages;
import org.weasis.dicom.explorer.wado.DicomManager;

public class WadoPrefView
extends AbstractItemDialogPage {
    private final ItemListener changeViewListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                WadoPrefView.this.selectTSUID((TransferSyntax)WadoPrefView.this.comboBox.getSelectedItem());
            }
        }
    };
    private final JPanel panel = new JPanel();
    private final JComboBox comboBox;
    private final JSpinner spinnerScroll = new JSpinner();
    private JLabel lblCompression;

    public WadoPrefView() {
        this.setTitle(Messages.getString("WadoPrefView.wado"));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.lblCompression = new JLabel(Messages.getString("WadoPrefView.compr"));
        this.add(this.panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.panel.setBorder(new TitledBorder(null, Messages.getString("WadoPrefView.compr2"), 4, 2, null, null));
        JLabel lblTranscodingTo = new JLabel(Messages.getString("WadoPrefView.trans"));
        GridBagConstraints gbc_lblTranscodingTo = new GridBagConstraints();
        gbc_lblTranscodingTo.insets = new Insets(0, 0, 5, 5);
        gbc_lblTranscodingTo.anchor = 17;
        gbc_lblTranscodingTo.gridx = 0;
        gbc_lblTranscodingTo.gridy = 0;
        this.panel.add((Component)lblTranscodingTo, gbc_lblTranscodingTo);
        this.comboBox = new JComboBox<TransferSyntax>(TransferSyntax.values());
        this.comboBox.addItemListener(this.changeViewListener);
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.anchor = 17;
        gbc_comboBox.insets = new Insets(0, 2, 5, 5);
        gbc_comboBox.gridx = 1;
        gbc_comboBox.gridy = 0;
        this.panel.add((Component)this.comboBox, gbc_comboBox);
        GridBagConstraints gbc_lblstrut = new GridBagConstraints();
        gbc_lblstrut.insets = new Insets(0, 0, 5, 0);
        gbc_lblstrut.anchor = 17;
        gbc_lblstrut.fill = 2;
        gbc_lblstrut.weightx = 1.0;
        gbc_lblstrut.gridx = 2;
        gbc_lblstrut.gridy = 0;
        this.panel.add(Box.createHorizontalStrut(2), gbc_lblstrut);
        JTextArea txtpnNoteWhenThe = new JTextArea(Messages.getString("WadoPrefView.mes"));
        GridBagConstraints gbc_txtpnNoteWhenThe = new GridBagConstraints();
        gbc_txtpnNoteWhenThe.weighty = 1.0;
        gbc_txtpnNoteWhenThe.fill = 1;
        gbc_txtpnNoteWhenThe.anchor = 18;
        gbc_txtpnNoteWhenThe.gridwidth = 3;
        gbc_txtpnNoteWhenThe.gridx = 0;
        gbc_txtpnNoteWhenThe.gridy = 2;
        txtpnNoteWhenThe.setPreferredSize(new Dimension(250, 25));
        txtpnNoteWhenThe.setEditable(false);
        txtpnNoteWhenThe.setBorder(new EmptyBorder(2, 2, 2, 2));
        txtpnNoteWhenThe.setOpaque(false);
        txtpnNoteWhenThe.setLineWrap(true);
        txtpnNoteWhenThe.setWrapStyleWord(true);
        txtpnNoteWhenThe.setBackground(lblTranscodingTo.getBackground());
        txtpnNoteWhenThe.setForeground(lblTranscodingTo.getForeground());
        this.panel.add((Component)txtpnNoteWhenThe, gbc_txtpnNoteWhenThe);
        this.comboBox.setSelectedItem(DicomManager.getInstance().getWadoTSUID());
    }

    private void selectTSUID(TransferSyntax tsuid) {
        if (tsuid != null && tsuid.getCompression() != null) {
            GridBagConstraints gbc_lblCompression = new GridBagConstraints();
            gbc_lblCompression.anchor = 13;
            gbc_lblCompression.insets = new Insets(0, 0, 5, 5);
            gbc_lblCompression.gridx = 0;
            gbc_lblCompression.gridy = 1;
            this.panel.add((Component)this.lblCompression, gbc_lblCompression);
            this.spinnerScroll.setModel(new SpinnerNumberModel(tsuid.getCompression(), 0, 100, 1));
            GridBagConstraints gbc_spinner_1 = new GridBagConstraints();
            gbc_spinner_1.anchor = 17;
            gbc_spinner_1.insets = new Insets(0, 2, 5, 5);
            gbc_spinner_1.gridx = 1;
            gbc_spinner_1.gridy = 1;
            this.panel.add((Component)this.spinnerScroll, gbc_spinner_1);
        } else {
            this.panel.remove(this.lblCompression);
            this.panel.remove(this.spinnerScroll);
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void closeAdditionalWindow() {
        TransferSyntax tsuid = (TransferSyntax)this.comboBox.getSelectedItem();
        if (tsuid != null) {
            tsuid.setCompression((Integer)this.spinnerScroll.getValue());
            DicomManager.getInstance().setWadoTSUID(tsuid);
        }
    }

    public void resetoDefaultValues() {
    }
}

