/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.awt.Color;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.media.data.Thumbnail;

public class SeriesSelectionModel
extends ArrayList<Series> {
    private static final Color selectedColor = new Color(82, 152, 219);

    public SeriesSelectionModel(int initialCapacity) {
        super(initialCapacity);
    }

    public SeriesSelectionModel() {
    }

    @Override
    public void add(int index, Series element) {
        if (!this.contains(element)) {
            super.add(index, element);
            this.setBackgroundColor(element, false);
        }
    }

    @Override
    public boolean add(Series e) {
        if (!this.contains(e)) {
            this.setBackgroundColor(e, true);
            return super.add(e);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Series> c) {
        for (Series series : c) {
            this.setBackgroundColor(series, true);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Series> c) {
        for (Series series : c) {
            this.setBackgroundColor(series, true);
        }
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        for (Series s : this) {
            this.setBackgroundColor(s, false);
        }
        super.clear();
    }

    @Override
    public Series remove(int index) {
        Series s = (Series)super.remove(index);
        if (s != null) {
            this.setBackgroundColor(s, false);
        }
        return s;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Series) {
            this.setBackgroundColor((Series)o, false);
        }
        return super.remove(o);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int start;
        int length;
        int seriesSize = this.size();
        int n = length = toIndex > seriesSize ? seriesSize : toIndex;
        for (int i = start = fromIndex < 0 ? 0 : (fromIndex > length - 1 ? length - 1 : fromIndex); i < length; ++i) {
            this.setBackgroundColor((Series)this.get(i), false);
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public Series set(int index, Series element) {
        Series s = super.set(index, element);
        if (s != null) {
            this.setBackgroundColor(s, false);
        }
        if (element != null) {
            this.setBackgroundColor(element, true);
        }
        return s;
    }

    private void setBackgroundColor(Series series, boolean selected) {
        Container parent;
        Thumbnail thumb;
        if (series != null && (thumb = (Thumbnail)series.getTagValue(TagW.Thumbnail)) != null && (parent = thumb.getParent()) instanceof JPanel) {
            Color color = selected ? selectedColor : (Color)UIManager.get("Panel.background");
            parent.setBackground(color);
        }
    }
}

