/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.ImportDicom;
import org.weasis.dicom.explorer.LoadLocalDicom;
import org.weasis.dicom.explorer.Messages;

public class LocalImport
extends AbstractItemDialogPage
implements ImportDicom {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalImport.class);
    private JCheckBox chckbxSearch;
    private JLabel lblImportAFolder;
    private JTextField textField;
    private JButton button;
    private File[] files;

    public LocalImport() {
        this.setTitle(Messages.getString("LocalImport.local_dev"));
        this.initGUI();
        this.initialize(true);
    }

    public void initGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.lblImportAFolder = new JLabel(Messages.getString("LocalImport.imp_files"));
        GridBagConstraints gbc_lblImportAFolder = new GridBagConstraints();
        gbc_lblImportAFolder.anchor = 17;
        gbc_lblImportAFolder.insets = new Insets(5, 5, 0, 0);
        gbc_lblImportAFolder.gridx = 0;
        gbc_lblImportAFolder.gridy = 0;
        this.add(this.lblImportAFolder, gbc_lblImportAFolder);
        this.textField = new JTextField();
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.anchor = 17;
        gbc_textField.insets = new Insets(5, 2, 0, 0);
        gbc_textField.fill = 2;
        gbc_textField.gridx = 1;
        gbc_textField.gridy = 0;
        JMVUtils.setPreferredWidth((JComponent)this.textField, (int)375, (int)375);
        this.add(this.textField, gbc_textField);
        this.button = new JButton(" ... ");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalImport.this.browseImgFile();
            }
        });
        GridBagConstraints gbc_button = new GridBagConstraints();
        gbc_button.anchor = 17;
        gbc_button.insets = new Insets(5, 5, 0, 5);
        gbc_button.gridx = 2;
        gbc_button.gridy = 0;
        this.add(this.button, gbc_button);
        this.chckbxSearch = new JCheckBox(Messages.getString("LocalImport.recursive"));
        this.chckbxSearch.setSelected(true);
        GridBagConstraints gbc_chckbxSearch = new GridBagConstraints();
        gbc_chckbxSearch.gridwidth = 3;
        gbc_chckbxSearch.insets = new Insets(5, 5, 0, 0);
        gbc_chckbxSearch.anchor = 18;
        gbc_chckbxSearch.gridx = 0;
        gbc_chckbxSearch.gridy = 1;
        this.add(this.chckbxSearch, gbc_chckbxSearch);
        JLabel label = new JLabel();
        GridBagConstraints gridBagConstraints_4 = new GridBagConstraints();
        gridBagConstraints_4.weighty = 1.0;
        gridBagConstraints_4.weightx = 1.0;
        gridBagConstraints_4.gridy = 4;
        gridBagConstraints_4.gridx = 2;
        this.add(label, gridBagConstraints_4);
    }

    protected void initialize(boolean afirst) {
        if (afirst) {
            // empty if block
        }
    }

    public void browseImgFile() {
        String directory = "";
        if (this.files != null && this.files.length > 0) {
            directory = this.files[0].isDirectory() ? this.files[0].getPath() : this.files[0].getParent();
        } else {
            File file;
            String path = this.textField.getText().trim();
            if (path != null && !path.equals("") && !path.equals(Messages.getString("LocalImport.multi_dir")) && (file = new File(path)).canRead()) {
                directory = file.isDirectory() ? file.getPath() : file.getParent();
            }
        }
        JFileChooser fileChooser = new JFileChooser(directory);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        File[] selectedFiles = null;
        if (fileChooser.showOpenDialog((Component)((Object)this)) != 0 || (selectedFiles = fileChooser.getSelectedFiles()) == null) {
            this.files = null;
            return;
        }
        this.files = selectedFiles;
        this.textField.setText(this.files.length == 1 ? this.files[0].getPath() : Messages.getString("LocalImport.multi_dir"));
    }

    public void resetSettingsToDefault() {
        this.initialize(false);
    }

    public void applyChange() {
    }

    protected void updateChanges() {
    }

    public void closeAdditionalWindow() {
        this.applyChange();
    }

    public void resetoDefaultValues() {
    }

    @Override
    public void importDICOM(DicomModel dicomModel, JProgressBar info) {
        String path;
        if (this.files == null && (path = this.textField.getText().trim()) != null && !path.equals("") && !path.equals(Messages.getString("LocalImport.multi_dir"))) {
            File file = new File(path);
            if (file.canRead()) {
                this.files = new File[]{file};
            } else {
                try {
                    file = new File(new URI(path));
                    if (file.canRead()) {
                        this.files = new File[]{file};
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot import DICOM from {}", (Object)path);
                }
            }
        }
        if (this.files != null) {
            LoadLocalDicom dicom = new LoadLocalDicom(this.files, this.chckbxSearch.isSelected(), dicomModel, false);
            dicom.setProgressBar(info);
            DicomModel.loadingExecutor.execute(dicom);
        }
    }
}

