/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputStream;
import org.weasis.core.api.explorer.model.TreeModel;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.util.FileUtil;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.ExportDicom;
import org.weasis.dicom.explorer.Messages;

public class LocalExport
extends AbstractItemDialogPage
implements ExportDicom {
    private JLabel lblImportAFolder;
    private JTextField textField;
    private JButton button;
    private File outputFolder;

    public LocalExport() {
        this.setTitle(Messages.getString("LocalExport.local_dev"));
        this.initGUI();
        this.initialize(true);
    }

    public void initGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.lblImportAFolder = new JLabel(Messages.getString("LocalExport.exp"));
        GridBagConstraints gbc_lblImportAFolder = new GridBagConstraints();
        gbc_lblImportAFolder.anchor = 17;
        gbc_lblImportAFolder.insets = new Insets(5, 5, 0, 0);
        gbc_lblImportAFolder.gridx = 0;
        gbc_lblImportAFolder.gridy = 0;
        this.add(this.lblImportAFolder, gbc_lblImportAFolder);
        this.textField = new JTextField();
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.anchor = 17;
        gbc_textField.insets = new Insets(5, 2, 0, 0);
        gbc_textField.fill = 2;
        gbc_textField.gridx = 1;
        gbc_textField.gridy = 0;
        JMVUtils.setPreferredWidth((JComponent)this.textField, (int)375, (int)375);
        this.add(this.textField, gbc_textField);
        this.button = new JButton(" ... ");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalExport.this.browseImgFile();
            }
        });
        GridBagConstraints gbc_button = new GridBagConstraints();
        gbc_button.anchor = 17;
        gbc_button.insets = new Insets(5, 5, 0, 5);
        gbc_button.gridx = 2;
        gbc_button.gridy = 0;
        this.add(this.button, gbc_button);
        JLabel label = new JLabel();
        GridBagConstraints gridBagConstraints_4 = new GridBagConstraints();
        gridBagConstraints_4.weighty = 1.0;
        gridBagConstraints_4.weightx = 1.0;
        gridBagConstraints_4.gridy = 4;
        gridBagConstraints_4.gridx = 2;
        this.add(label, gridBagConstraints_4);
    }

    protected void initialize(boolean afirst) {
        if (afirst) {
            // empty if block
        }
    }

    public void browseImgFile() {
        String directory = "";
        if (this.outputFolder != null) {
            directory = this.outputFolder.isDirectory() ? this.outputFolder.getPath() : this.outputFolder.getParent();
        }
        JFileChooser fileChooser = new JFileChooser(directory);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        File selectedFiles = null;
        if (fileChooser.showOpenDialog((Component)((Object)this)) != 0 || (selectedFiles = fileChooser.getSelectedFile()) == null) {
            this.outputFolder = null;
            return;
        }
        this.outputFolder = selectedFiles;
        this.textField.setText(selectedFiles.getPath());
    }

    public void resetSettingsToDefault() {
        this.initialize(false);
    }

    public void applyChange() {
    }

    protected void updateChanges() {
    }

    public void closeAdditionalWindow() {
        this.applyChange();
    }

    public void resetoDefaultValues() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportDICOM(DicomModel dicomModel, JProgressBar info) {
        if (this.outputFolder != null) {
            DicomModel dicomModel2 = dicomModel;
            synchronized (dicomModel2) {
                for (MediaSeriesGroup pt : dicomModel.getChildren(TreeModel.rootNode)) {
                    Collection<MediaSeriesGroup> studies = dicomModel.getChildren(pt);
                    for (MediaSeriesGroup study : studies) {
                        Collection<MediaSeriesGroup> seriesList = dicomModel.getChildren(study);
                        for (MediaSeriesGroup item : seriesList) {
                            if (!(item instanceof DicomSeries)) continue;
                            DicomSeries series = (DicomSeries)item;
                            for (DicomImageElement dicom : series.getMedias()) {
                                this.writeFile(dicom);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean writeFile(DicomImageElement dicom) {
        File file = new File(this.outputFolder, (String)dicom.getTagValue(TagW.SOPInstanceUID) + ".j2k");
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            DicomInputStream in = new DicomInputStream(dicom.getFile());
            DicomObject dcmObj = in.readDicomObject();
            DicomElement pixelDataDcmElement = dcmObj.get(2145386512);
            byte[] pixelData = pixelDataDcmElement.getFragment(1);
            ((OutputStream)os).write(pixelData);
        }
        catch (OutOfMemoryError e) {
            boolean bl = false;
            FileUtil.safeClose((Closeable)os);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    FileUtil.safeClose(os);
                    throw throwable;
                }
            }
            FileUtil.safeClose((Closeable)os);
            return bl;
        }
        FileUtil.safeClose((Closeable)os);
        return true;
    }
}

