/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.weasis.core.ui.util.ToolBarButtonBorder;
import org.weasis.core.ui.util.VLButtonUI;

public class WtoolBar
extends JPanel {
    public static final Dimension SEPARATOR_2x24 = new Dimension(2, 24);
    private final TYPE type;
    private final String barName;
    private boolean rolloverBorderPainted = true;
    private boolean rolloverContentAreaFilled = true;
    private boolean useCustomUI = true;
    private transient MouseListener buttonMouseHandler = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractButton btn = (AbstractButton)e.getSource();
            if ((e.getModifiersEx() & 0x400) == 0) {
                if (WtoolBar.this.rolloverBorderPainted) {
                    btn.setBorderPainted(true);
                }
                if (WtoolBar.this.rolloverContentAreaFilled) {
                    btn.setContentAreaFilled(true);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractButton btn = (AbstractButton)e.getSource();
            btn.setBorderPainted(false);
            btn.setContentAreaFilled(false);
        }
    };

    public WtoolBar(String barName, TYPE type) {
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        flowLayout.setAlignment(3);
        this.barName = barName;
        this.type = type;
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setOpaque(false);
        this.addSeparator(SEPARATOR_2x24);
    }

    public TYPE getType() {
        return this.type;
    }

    public void addSeparator(Dimension dim) {
        JSeparator s = new JSeparator(1);
        s.setPreferredSize(dim);
        this.add(s);
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof AbstractButton) {
            return this.add((AbstractButton)comp);
        }
        return super.add(comp);
    }

    public Component add(AbstractButton button) {
        boolean substanceLaf = UIManager.getLookAndFeel().getName().startsWith("Substance");
        if (this.useCustomUI && !substanceLaf) {
            WtoolBar.installButtonUI(button);
        }
        super.add(button);
        if (substanceLaf) {
            button.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        } else {
            WtoolBar.configureButton(button);
            this.installMouseHandler(button);
        }
        return button;
    }

    public Component add(JButton button) {
        return this.add((AbstractButton)button);
    }

    public static void installButtonUI(AbstractButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setUI(new VLButtonUI());
        button.setBorder(new ToolBarButtonBorder());
    }

    public void installMouseHandler(AbstractButton button) {
        button.addMouseListener(this.buttonMouseHandler);
    }

    public static void configureButton(AbstractButton button) {
        button.setRolloverEnabled(true);
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        button.setBorderPainted(false);
    }

    public void setRolloverBorderPainted(boolean painted) {
        this.rolloverBorderPainted = painted;
    }

    public boolean isRolloverBorderPainter() {
        return this.rolloverBorderPainted;
    }

    public void setRolloverContentAreaFilled(boolean filled) {
        this.rolloverContentAreaFilled = filled;
    }

    public boolean isRolloverContentAreaFilled() {
        return this.rolloverContentAreaFilled;
    }

    public void setUseCustomUI(boolean useCustomUI) {
        this.useCustomUI = useCustomUI;
    }

    public boolean isUseCustomUI() {
        return this.useCustomUI;
    }

    @Override
    public String toString() {
        return "WtoolBar " + this.getName();
    }

    public String getBarName() {
        return this.barName;
    }

    public static enum TYPE {
        main,
        explorer,
        tool;

    }
}

