/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic.model;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.JComponent;
import org.weasis.core.api.gui.model.ViewModel;
import org.weasis.core.api.gui.model.ViewModelChangeListener;
import org.weasis.core.ui.graphic.model.AbstractLayerModel;
import org.weasis.core.ui.graphic.model.DefaultViewModel;
import org.weasis.core.ui.graphic.model.LayerModel;
import org.weasis.core.ui.graphic.model.LayerModelChangeAdapter;
import org.weasis.core.ui.graphic.model.MainLayerModel;

public class GraphicsPane
extends JComponent {
    protected AbstractLayerModel layerModel;
    private final LayerModelHandler layerModelHandler;
    private ViewModel viewModel;
    private final ViewModelHandler viewModelHandler;
    protected final DrawingsKeyListeners drawingsKeyListeners = new DrawingsKeyListeners();
    protected final HashMap<String, Object> actionsInView = new HashMap();
    protected final AffineTransform affineTransform = new AffineTransform();
    protected final AffineTransform inverseTransform = new AffineTransform();

    public GraphicsPane() {
        this(null, null);
    }

    public GraphicsPane(AbstractLayerModel layerModel, ViewModel viewModel) {
        this.setOpaque(false);
        this.viewModel = viewModel == null ? new DefaultViewModel() : viewModel;
        this.viewModelHandler = new ViewModelHandler();
        this.viewModel.addViewModelChangeListener((ViewModelChangeListener)this.viewModelHandler);
        this.layerModel = layerModel == null ? new MainLayerModel(this) : layerModel;
        this.layerModelHandler = new LayerModelHandler();
        this.layerModel.addLayerModelChangeListener(this.layerModelHandler);
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public AffineTransform getInverseTransform() {
        return this.inverseTransform;
    }

    public void dispose() {
        if (this.viewModel != null) {
            this.viewModel.removeViewModelChangeListener((ViewModelChangeListener)this.viewModelHandler);
            this.viewModel = null;
        }
        if (this.layerModel != null) {
            this.layerModel.removeLayerModelChangeListener(this.layerModelHandler);
            this.layerModel.dispose();
            this.layerModel = null;
        }
    }

    public ViewModel getViewModel() {
        return this.viewModel;
    }

    public void setViewModel(ViewModel viewModel) {
        ViewModel viewModelOld = this.viewModel;
        if (viewModelOld != viewModel) {
            if (viewModelOld != null) {
                viewModelOld.removeViewModelChangeListener((ViewModelChangeListener)this.viewModelHandler);
            }
            this.viewModel = viewModel;
            if (this.viewModel != null) {
                this.viewModel.addViewModelChangeListener((ViewModelChangeListener)this.viewModelHandler);
            }
            this.firePropertyChange("viewModel", viewModelOld, this.viewModel);
        }
    }

    public AbstractLayerModel getLayerModel() {
        return this.layerModel;
    }

    public void setLayerModel(AbstractLayerModel layerModel) {
        AbstractLayerModel layerModelOld = this.layerModel;
        if (layerModelOld != layerModel) {
            if (layerModelOld != null) {
                layerModelOld.removeLayerModelChangeListener(this.layerModelHandler);
            }
            this.layerModel = layerModel;
            if (this.layerModel != null) {
                this.layerModel.addLayerModelChangeListener(this.layerModelHandler);
            }
            this.firePropertyChange("layerModel", layerModelOld, layerModel);
        }
    }

    public Object getActionValue(String action) {
        if (action == null) {
            return null;
        }
        return this.actionsInView.get(action);
    }

    public void zoom(double viewScale) {
        double modelOffsetXOld = this.viewModel.getModelOffsetX();
        double modelOffsetYOld = this.viewModel.getModelOffsetY();
        double viewScaleOld = this.viewModel.getViewScale();
        double viewportWidth = this.getWidth() - 1;
        double viewportHeight = this.getHeight() - 1;
        double centerX = modelOffsetXOld + 0.5 * viewportWidth / viewScaleOld;
        double centerY = modelOffsetYOld + 0.5 * viewportHeight / viewScaleOld;
        this.zoom(centerX, centerY, viewScale);
    }

    public void zoom(double centerX, double centerY, double viewScale) {
        viewScale = this.cropViewScale(viewScale);
        double viewportWidth = this.getWidth() - 1;
        double viewportHeight = this.getHeight() - 1;
        double modelOffsetX = centerX - 0.5 * viewportWidth / viewScale;
        double modelOffsetY = centerY - 0.5 * viewportHeight / viewScale;
        this.getViewModel().setModelOffset(modelOffsetX, modelOffsetY, viewScale);
    }

    public void zoom(Rectangle2D zoomRect) {
        double viewportWidth = this.getWidth() - 1;
        double viewportHeight = this.getHeight() - 1;
        this.zoom(zoomRect.getCenterX(), zoomRect.getCenterY(), Math.min(viewportWidth / zoomRect.getWidth(), viewportHeight / zoomRect.getHeight()));
    }

    public double getBestFitViewScale() {
        double viewportWidth = this.getWidth() - 1;
        double viewportHeight = this.getHeight() - 1;
        Rectangle2D modelArea = this.viewModel.getModelArea();
        return this.cropViewScale(Math.min(viewportWidth / modelArea.getWidth(), viewportHeight / modelArea.getHeight()));
    }

    public double viewToModelX(double viewX) {
        return this.viewModel.getModelOffsetX() + this.viewToModelLength(viewX);
    }

    public double viewToModelY(double viewY) {
        return this.viewModel.getModelOffsetY() + this.viewToModelLength(viewY);
    }

    public double viewToModelLength(double viewLength) {
        return viewLength / this.viewModel.getViewScale();
    }

    public double modelToViewX(double modelX) {
        return this.modelToViewLength(modelX - this.viewModel.getModelOffsetX());
    }

    public double modelToViewY(double modelY) {
        return this.modelToViewLength(modelY - this.viewModel.getModelOffsetY());
    }

    public double modelToViewLength(double modelLength) {
        return modelLength * this.viewModel.getViewScale();
    }

    public Point2D getImageCoordinatesFromMouse(int x, int y) {
        double viewScale = this.getViewModel().getViewScale();
        Point2D.Double p2 = new Point2D.Double((double)x + this.getViewModel().getModelOffsetX() * viewScale, (double)y + this.getViewModel().getModelOffsetY() * viewScale);
        this.inverseTransform.transform(p2, p2);
        return p2;
    }

    public Point getMouseCoordinatesFromImage(double x, double y) {
        Point2D.Double p2 = new Point2D.Double(x, y);
        this.affineTransform.transform(p2, p2);
        double viewScale = this.getViewModel().getViewScale();
        return new Point((int)Math.floor(((Point2D)p2).getX() - this.getViewModel().getModelOffsetX() * viewScale + 0.5), (int)Math.floor(((Point2D)p2).getY() - this.getViewModel().getModelOffsetY() * viewScale + 0.5));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (g instanceof Graphics2D) {
            this.drawLayers((Graphics2D)g, null, null);
        }
    }

    public void drawLayers(Graphics2D g2d, AffineTransform transform, AffineTransform inverseTransform) {
        Graphics2D g2dClone = (Graphics2D)g2d.create();
        this.transformGraphics(g2dClone, true);
        this.getLayerModel().draw(g2dClone, transform, inverseTransform);
        g2dClone.dispose();
    }

    public void transformGraphics(Graphics2D g2d, boolean forward) {
        if (forward) {
            g2d.scale(this.viewModel.getViewScale(), this.viewModel.getViewScale());
            g2d.translate(-this.viewModel.getModelOffsetX(), -this.viewModel.getModelOffsetY());
        } else {
            g2d.translate(this.viewModel.getModelOffsetX(), this.viewModel.getModelOffsetY());
            g2d.scale(1.0 / this.viewModel.getViewScale(), 1.0 / this.viewModel.getViewScale());
        }
    }

    private double cropViewScale(double viewScale) {
        return DefaultViewModel.cropViewScale(viewScale, this.viewModel.getViewScaleMin(), this.viewModel.getViewScaleMax());
    }

    private class DrawingsKeyListeners
    implements KeyListener {
        private DrawingsKeyListeners() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                GraphicsPane.this.layerModel.deleteSelectedGraphics();
            } else if (e.isControlDown() && e.getKeyCode() == 68) {
                GraphicsPane.this.layerModel.setSelectedGraphics(null);
            } else if (e.isControlDown() && e.getKeyCode() == 65) {
                GraphicsPane.this.layerModel.setSelectedGraphics(GraphicsPane.this.layerModel.getdAllGraphics());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class ViewModelHandler
    implements ViewModelChangeListener {
        private ViewModelHandler() {
        }

        public void handleViewModelChanged(ViewModel viewModel) {
            GraphicsPane.this.repaint();
        }
    }

    private class LayerModelHandler
    extends LayerModelChangeAdapter {
        private LayerModelHandler() {
        }

        @Override
        public void handleLayerModelChanged(LayerModel layerModel) {
            GraphicsPane.this.repaint();
        }
    }
}

