/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.weasis.core.ui.graphic.ChainPoint;

public class RasterizeGraphicsToCoord {
    public static ArrayList<ChainPoint> rasterizeSegment(int x0, int y0, int x1, int y1) {
        ArrayList<ChainPoint> list = new ArrayList<ChainPoint>();
        int dx = x1 - x0;
        int dy = y1 - y0;
        int stepy = 1;
        int stepx = 1;
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        }
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        }
        list.add(new ChainPoint(x0, y0));
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                list.add(new ChainPoint(x0 += stepx, y0));
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                list.add(new ChainPoint(x0, y0 += stepy));
            }
        }
        list.trimToSize();
        return list;
    }

    public static ArrayList<ChainPoint> rasterizeFreehandline(float[] coord) {
        ArrayList<ChainPoint> list = new ArrayList<ChainPoint>();
        if (coord != null && coord.length > 2) {
            ChainPoint last = new ChainPoint((int)coord[0], (int)coord[1]);
            for (int m = 2; m < coord.length; m += 2) {
                if (Math.abs(coord[m] - coord[m - 2]) > 1.0f || Math.abs(coord[m + 1] - coord[m - 1]) > 1.0f) {
                    list.addAll(RasterizeGraphicsToCoord.rasterizeSegment(last.x, last.y, (int)coord[m], (int)coord[m + 1]));
                    last = list.remove(list.size() - 1);
                    continue;
                }
                list.add(last);
                last = new ChainPoint((int)coord[m], (int)coord[m + 1]);
            }
        }
        list.trimToSize();
        return list;
    }

    public static byte[] getFreemanCodeFromFreehandline(float[] coord) {
        ArrayList<ChainPoint> list = RasterizeGraphicsToCoord.rasterizeFreehandline(coord);
        byte[] tab = new byte[list.size() - 1];
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = RasterizeGraphicsToCoord.getFreemanDirection(list.get(i), list.get(i + 1));
        }
        return tab;
    }

    private static byte getFreemanDirection(ChainPoint last, ChainPoint next) {
        int x = next.x - last.x;
        int y = next.y - last.y;
        if (x == 1) {
            if (y == 1) {
                return 7;
            }
            if (y == -1) {
                return 1;
            }
            return 0;
        }
        if (x == -1) {
            if (y == 1) {
                return 5;
            }
            if (y == -1) {
                return 3;
            }
            return 4;
        }
        if (y == 1) {
            return 6;
        }
        return 2;
    }

    public static ArrayList<ChainPoint> rasterizeRectangle(int x, int y, int width, int height) {
        int i;
        ArrayList<ChainPoint> list = new ArrayList<ChainPoint>((width + height - 2) * 2);
        int limit = y + height;
        int staticVal = x;
        for (i = y; i < limit; ++i) {
            list.add(new ChainPoint(staticVal, i));
        }
        limit = x + width;
        staticVal = y + height - 1;
        for (i = x + 1; i < limit; ++i) {
            list.add(new ChainPoint(i, staticVal));
        }
        limit = y;
        staticVal = x + width - 1;
        for (i = y + height - 2; i >= limit; --i) {
            list.add(new ChainPoint(staticVal, i));
        }
        limit = x + 1;
        staticVal = y;
        for (i = x + width - 2; i >= limit; --i) {
            list.add(new ChainPoint(i, staticVal));
        }
        return list;
    }

    public static ArrayList<ChainPoint> rasterizeEllipse(int mx, int my, int a, int b) {
        ArrayList<ChainPoint>[] list1 = RasterizeGraphicsToCoord.drawEllipsePart(mx, my, a, b, false);
        ArrayList<ChainPoint>[] list2 = RasterizeGraphicsToCoord.drawEllipsePart(mx, my, b, a, true);
        for (int i = 0; i < list1.length; ++i) {
            ArrayList<ChainPoint> chain2;
            ArrayList<ChainPoint> chain1;
            if (i % 2 == 0) {
                chain1 = list1[i];
                chain2 = list2[i];
            } else {
                chain1 = list2[i];
                chain2 = list1[i];
            }
            if (!chain1.get(chain1.size() - 1).equals(chain2.get(chain2.size() - 1))) {
                chain1.add(chain2.get(chain2.size() - 1));
            }
            for (int j = chain2.size() - 2; j > 0; --j) {
                chain1.add(chain2.get(j));
            }
        }
        list1[0].addAll(list2[1]);
        list1[0].addAll(list1[2]);
        list1[0].addAll(list2[3]);
        int miny = list1[0].get((int)0).y;
        int k = 1;
        while (list1[0].get((int)k).y <= miny && ++k < list1[0].size()) {
        }
        if (k > 1) {
            int i;
            for (i = 0; i < k - 1; ++i) {
                list1[0].add(list1[0].get(i));
            }
            for (i = k - 2; i >= 0; --i) {
                list1[0].remove(i);
            }
        }
        list1[0].trimToSize();
        return list1[0];
    }

    private static ArrayList<ChainPoint>[] drawEllipsePart(int mx, int my, int a, int b, boolean mirror) {
        ArrayList[] list = new ArrayList[4];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new ArrayList();
        }
        int x = 0;
        int y = b;
        int a2 = a * a;
        int b2 = b * b;
        int d = b2 - a2 * b + a2 / 4;
        while (b2 * x <= a2 * y) {
            RasterizeGraphicsToCoord.drawEllipsePoint(list, mx, my, x, y, mirror);
            d += 2 * (b2 * x++ - (d >= 0 ? a2 * --y : 0)) + 3 * b2;
        }
        return list;
    }

    private static void drawEllipsePoint(ArrayList<ChainPoint>[] list, int mx, int my, int x, int y, boolean mirror) {
        if (mirror) {
            list[0].add(new ChainPoint(mx - y, my - x));
            list[1].add(new ChainPoint(mx - y, my + x));
            list[2].add(new ChainPoint(mx + y, my + x));
            list[3].add(new ChainPoint(mx + y, my - x));
        } else {
            list[0].add(new ChainPoint(mx - x, my - y));
            list[1].add(new ChainPoint(mx - x, my + y));
            list[2].add(new ChainPoint(mx + x, my + y));
            list[3].add(new ChainPoint(mx + x, my - y));
        }
    }

    public static ArrayList<ChainPoint> convertToBackgroundLine(ArrayList<ChainPoint> points) {
        int size = points.size();
        ArrayList<ChainPoint> bckPts = new ArrayList<ChainPoint>(size);
        if (size > 0) {
            bckPts.add(points.get(0));
            for (int i = 1; i < size; ++i) {
                ChainPoint p1 = points.get(i - 1);
                ChainPoint p2 = points.get(i);
                bckPts.add(p2);
                int val = (p2.x - p1.x) * (p2.y - p1.y);
                if (val == 0) continue;
                if (val == 1) {
                    bckPts.add(new ChainPoint(p1.y, p2.x));
                    continue;
                }
                bckPts.add(new ChainPoint(p1.x, p2.y));
            }
        }
        bckPts.trimToSize();
        return bckPts;
    }

    public static float[] transformToCounterCockWiseCoord(float[] coord) {
        int i;
        if (coord == null || coord.length < 6) {
            return coord;
        }
        int index = 0;
        float miny = Float.MAX_VALUE;
        float minx = Float.MIN_VALUE;
        for (int m = 1; m < coord.length; m += 2) {
            if (!(coord[m] < miny) && (coord[m] != miny || !(coord[m - 1] < minx))) continue;
            miny = coord[m];
            minx = coord[m - 1];
            index = m - 1;
        }
        float[] newCoord = new float[coord.length];
        for (i = index; i < coord.length; ++i) {
            newCoord[i - index] = coord[i];
        }
        for (i = 0; i < index; ++i) {
            newCoord[i + coord.length - index] = coord[i];
        }
        if (newCoord[coord.length - 2] < newCoord[2]) {
            float[] newCoord2 = new float[coord.length];
            newCoord2[0] = newCoord[0];
            newCoord2[1] = newCoord[1];
            int m = 3;
            int k = coord.length - 1;
            while (m < coord.length) {
                newCoord2[m] = newCoord[k];
                newCoord2[m - 1] = newCoord[--k];
                m += 2;
                --k;
            }
            newCoord = newCoord2;
        }
        return newCoord;
    }

    public static ArrayList<ChainPoint> rasterizePolygon(float[] coord) {
        ArrayList<ChainPoint> list = new ArrayList<ChainPoint>();
        if (coord != null && coord.length > 5) {
            coord = RasterizeGraphicsToCoord.transformToCounterCockWiseCoord(coord);
            ChainPoint last = new ChainPoint((int)coord[0], (int)coord[1]);
            for (int m = 2; m < coord.length; m += 2) {
                list.addAll(RasterizeGraphicsToCoord.rasterizeSegment(last.x, last.y, (int)coord[m], (int)coord[m + 1]));
                last = list.remove(list.size() - 1);
            }
            if (!last.equals(list.get(0))) {
                ChainPoint first = list.get(0);
                list.addAll(RasterizeGraphicsToCoord.rasterizeSegment(last.x, last.y, first.x, first.y));
            }
        }
        return list;
    }

    public static ArrayList<ChainPoint> transformShapeToContour(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Line2D) {
            Line2D pt = (Line2D)shape;
            return RasterizeGraphicsToCoord.rasterizeSegment(RasterizeGraphicsToCoord.floorInt(pt.getX1()), RasterizeGraphicsToCoord.floorInt(pt.getY1()), RasterizeGraphicsToCoord.floorInt(pt.getX2()), RasterizeGraphicsToCoord.floorInt(pt.getY2()));
        }
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            return RasterizeGraphicsToCoord.rasterizeRectangle(rect.x, rect.y, rect.width, rect.height);
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            return RasterizeGraphicsToCoord.rasterizeRectangle(RasterizeGraphicsToCoord.floorInt(rect.getX()), RasterizeGraphicsToCoord.floorInt(rect.getY()), RasterizeGraphicsToCoord.floorInt(rect.getWidth()), RasterizeGraphicsToCoord.floorInt(rect.getHeight()));
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D rect = (Ellipse2D)shape;
            return RasterizeGraphicsToCoord.rasterizeEllipse(RasterizeGraphicsToCoord.floorInt(rect.getCenterX()), RasterizeGraphicsToCoord.floorInt(rect.getCenterY()), RasterizeGraphicsToCoord.floorInt(rect.getWidth() / 2.0), RasterizeGraphicsToCoord.floorInt(rect.getHeight() / 2.0));
        }
        ArrayList<ChainPoint> list = new ArrayList<ChainPoint>();
        Rectangle bounds = shape.getBounds();
        int matrixWidth = bounds.width + 1;
        int matrixHeight = bounds.height + 1;
        boolean[] matrix = new boolean[matrixWidth * matrixHeight];
        PathIterator iterator = shape.getPathIterator(null);
        float[] floats = new float[6];
        float x = 0.0f;
        float y = 0.0f;
        int nbSeg = 0;
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(floats);
            switch (segType) {
                case 0: {
                    x = floats[0];
                    y = floats[1];
                    break;
                }
                case 1: 
                case 4: {
                    x = floats[0];
                    y = floats[1];
                    ++nbSeg;
                    break;
                }
                case 3: {
                    break;
                }
            }
            iterator.next();
        }
        return list;
    }

    public static int floorInt(double x) {
        return (int)Math.floor(x);
    }
}

