/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class PerpendicularLineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(PerpendicularLineGraphic.class.getResource("/icon/22x22/draw-perpendicular.png"));
    public static final Measurement LineLength = new Measurement("Line length", true, true, true);
    public static final Measurement Orientation = new Measurement("Orientation", true, true, false);
    public static final Measurement Azimuth = new Measurement("Azimuth", true, true, false);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true, true, false);

    public PerpendicularLineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(4, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.perpendicular");
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        if (handlePointIndex == -1) {
            handlePointIndex = super.moveAndResizeOnDrawing(handlePointIndex, deltaX, deltaY, mouseEvent);
        } else if (!this.isGraphicComplete()) {
            ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getImageCoordinates());
            if (this.handlePointList.size() >= 3) {
                Point2D A = (Point2D)this.handlePointList.get(0);
                Point2D B = (Point2D)this.handlePointList.get(1);
                Point2D C = (Point2D)this.handlePointList.get(2);
                while (this.handlePointList.size() < this.handlePointTotalNumber) {
                    this.handlePointList.add(new Point2D.Double());
                }
                Point2D D = (Point2D)this.handlePointList.get(3);
                D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)C));
            }
        } else {
            Point2D A = (Point2D)this.handlePointList.get(0);
            Point2D B = (Point2D)this.handlePointList.get(1);
            Point2D C = (Point2D)this.handlePointList.get(2);
            Point2D D = (Point2D)this.handlePointList.get(3);
            if (handlePointIndex == 0 || handlePointIndex == 1) {
                double theta = GeomUtil.getAngleRad((Point2D)A, (Point2D)B);
                ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getImageCoordinates());
                Point2D anchor = handlePointIndex == 0 ? B : A;
                AffineTransform transform = AffineTransform.getRotateInstance(theta -= GeomUtil.getAngleRad((Point2D)A, (Point2D)B), anchor.getX(), anchor.getY());
                transform.transform(C, C);
                transform.transform(D, D);
            } else if (handlePointIndex == 2) {
                ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getImageCoordinates());
                D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)C));
            } else if (handlePointIndex == 3) {
                double tx = D.getX();
                double ty = D.getY();
                D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)mouseEvent.getImageCoordinates()));
                AffineTransform.getTranslateInstance(-(tx -= D.getX()), -(ty -= D.getY())).transform(C, C);
            }
        }
        return handlePointIndex;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                AbstractDragGraphic.AdvancedShape newShape = new AbstractDragGraphic.AdvancedShape(3);
                if (!A.equals(B)) {
                    GeneralPath generalpath = new GeneralPath(1, this.handlePointList.size() / 2);
                    newShape.addShape(generalpath);
                    generalpath.moveTo(A.getX(), A.getY());
                    generalpath.lineTo(B.getX(), B.getY());
                    if (this.handlePointList.size() >= 3) {
                        Point2D D;
                        Point2D C = (Point2D)this.handlePointList.get(2);
                        if (this.handlePointList.size() == 4 && !C.equals(D = (Point2D)this.handlePointList.get(3))) {
                            generalpath.moveTo(C.getX(), C.getY());
                            generalpath.lineTo(D.getX(), D.getY());
                            if (Math.signum(GeomUtil.getAngleDeg((Point2D)D, (Point2D)A)) == Math.signum(GeomUtil.getAngleDeg((Point2D)D, (Point2D)B))) {
                                Point2D E;
                                Point2D point2D = E = D.distance(A) < D.distance(B) ? A : B;
                                if (!D.equals(E)) {
                                    newShape.addShape(new Line2D.Double(D, E), this.getDashStroke(1.0f), true);
                                }
                            }
                            double cornerLength = 10.0;
                            double dMin = 0.6666666666666666 * Math.min(D.distance(C), Math.max(D.distance(A), D.distance(B)));
                            double scalingMin = cornerLength / dMin;
                            Point2D F = GeomUtil.getMidPoint((Point2D)A, (Point2D)B);
                            if (!D.equals(C) && !F.equals(D)) {
                                newShape.addInvShape(GeomUtil.getCornerShape((Point2D)F, (Point2D)D, (Point2D)C, (double)cornerLength), (Point2D)D.clone(), scalingMin, this.getStroke(1.0f), true);
                            }
                        }
                    }
                }
                this.setShape(newShape, mouseEvent);
                this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
            }
        }
    }

    public Double getSegmentLength(double scalex, double scaley) {
        if (this.handlePointList.size() >= 3) {
            Point2D A = (Point2D)this.handlePointList.get(2);
            if (this.handlePointList.size() >= 4) {
                Point2D B = (Point2D)this.handlePointList.get(3);
                return Point2D.distance(scalex * A.getX(), scaley * A.getY(), scalex * B.getX(), scaley * B.getY());
            }
        }
        return null;
    }

    public Double getSegmentOrientation() {
        if (this.handlePointList.size() >= 3) {
            Point2D p1 = (Point2D)this.handlePointList.get(2);
            if (this.handlePointList.size() >= 4) {
                Point2D p2 = (Point2D)this.handlePointList.get(3);
                return MathUtil.getOrientation((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
            }
        }
        return null;
    }

    public Double getSegmentAzimuth() {
        if (this.handlePointList.size() >= 3) {
            Point2D p1 = (Point2D)this.handlePointList.get(2);
            if (this.handlePointList.size() >= 4) {
                Point2D p2 = (Point2D)this.handlePointList.get(3);
                return MathUtil.getAzimuth((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
            }
        }
        return null;
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() >= 4 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (LineLength.isComputed() && (!drawOnLabel || LineLength.isGraphicLabel())) {
                val = releaseEvent || LineLength.isQuickComputing() ? this.getSegmentLength(adapter.getCalibRatio(), adapter.getCalibRatio()) : null;
                measVal.add(new MeasureItem(LineLength, val, adapter.getUnit()));
            }
            if (Orientation.isComputed() && (!drawOnLabel || Orientation.isGraphicLabel())) {
                val = releaseEvent || Orientation.isQuickComputing() ? this.getSegmentOrientation() : null;
                measVal.add(new MeasureItem(Orientation, val, "deg"));
            }
            if (Azimuth.isComputed() && (!drawOnLabel || Azimuth.isGraphicLabel())) {
                val = releaseEvent || Azimuth.isQuickComputing() ? this.getSegmentAzimuth() : null;
                measVal.add(new MeasureItem(Azimuth, val, "deg"));
            }
            return measVal;
        }
        return null;
    }
}

