/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.image.util.Statistics;
import org.weasis.core.ui.graphic.BlobAnalyse2D;

public class Measure2DAnalyse {
    public static final String[] measurList = new String[]{"Box X min", "Box Y min", "Box X width", "Box Y height", "Area", "Perimeter", "Barycenter x", "Barycenter y", "Orientation", "Length", "width", "Eccentricity", "Color (RGB)"};
    public static final int[] positionParameters = new int[]{0, 1, 2, 3, 6, 7};
    public static final int[] basicParameters = new int[]{4, 5, 8, 9, 10, 11};
    private Statistics stat;
    private Shape shape;
    private MeasurementsAdapter adapter;
    private BlobAnalyse2D blob = null;
    private Color color = null;

    public Measure2DAnalyse(Shape shape, MeasurementsAdapter adapter, Color color) {
        this.shape = shape;
        this.adapter = adapter;
        this.color = color;
    }

    public List getAnalyse(boolean[] selected, int nbMeasures) {
        ArrayList<Object> measVal = new ArrayList<Object>(nbMeasures);
        if (selected[0]) {
            measVal.add(this.adapter.getXCalibratedValue(this.shape.getBounds().getX()));
        }
        if (selected[1]) {
            measVal.add(this.adapter.getYCalibratedValue(this.shape.getBounds().getY()));
        }
        if (selected[2]) {
            measVal.add(this.adapter.getXCalibratedValue(this.shape.getBounds().getWidth()));
        }
        if (selected[3]) {
            measVal.add(this.adapter.getYCalibratedValue(this.shape.getBounds().getHeight()));
        }
        if (selected[4]) {
            measVal.add(this.adapter.getCalibRatio() * this.adapter.getCalibRatio() * this.getArea());
        }
        if (selected[5]) {
            measVal.add(this.adapter.getCalibRatio() * this.getPerimeter());
        }
        if (selected[6] || selected[7] || selected[8] || selected[9] || selected[10] || selected[11]) {
            if (this.getArea() == 0.0) {
                Double[] corruptGraph = new Double[nbMeasures];
                for (int i = 0; i < nbMeasures; ++i) {
                    corruptGraph[i] = 0.0;
                }
                return Arrays.asList(corruptGraph);
            }
            if (selected[6]) {
                measVal.add(this.adapter.getXCalibratedValue((double)this.shape.getBounds().x + this.getBaryCenterX()));
            }
            if (selected[7]) {
                measVal.add(this.adapter.getYCalibratedValue((double)this.shape.getBounds().y + this.getBaryCenterY()));
            }
            if (selected[8]) {
                measVal.add(Measure2DAnalyse.convertOrientationToTrigoDegree(this.getOrientation()));
            }
            if (selected[9] || selected[10]) {
                double[] minorAndMajorAxis = Measure2DAnalyse.getLengthAndWidth(this.shape, this.getOrientation());
                if (selected[9]) {
                    measVal.add(this.adapter.getCalibRatio() * minorAndMajorAxis[0]);
                }
                if (selected[10]) {
                    measVal.add(this.adapter.getCalibRatio() * minorAndMajorAxis[1]);
                }
            }
            if (selected[11]) {
                measVal.add(this.getEccentricity());
            }
            if (selected[12]) {
                measVal.add(JMVUtils.getValueRGBasText2((Color)this.color));
            }
        }
        return measVal;
    }

    public double getArea() {
        if (this.shape instanceof Rectangle2D) {
            Rectangle2D rectangle = this.shape.getBounds2D();
            return rectangle.getWidth() * rectangle.getHeight();
        }
        if (this.shape instanceof Ellipse2D) {
            Rectangle2D rectangle = this.shape.getBounds2D();
            return Math.PI * rectangle.getWidth() * rectangle.getHeight() / 4.0;
        }
        return this.getBlob().getArea();
    }

    public BlobAnalyse2D getBlob() {
        return this.blob == null ? (this.blob = new BlobAnalyse2D(this.shape)) : this.blob;
    }

    private double getPerimeter() {
        if (this.shape instanceof Rectangle2D) {
            Rectangle2D rectangle = this.shape.getBounds2D();
            return (rectangle.getWidth() + rectangle.getHeight()) * 2.0;
        }
        if (this.shape instanceof Ellipse2D) {
            Rectangle2D rectangle = this.shape.getBounds2D();
            double a = rectangle.getWidth() / 2.0;
            double b = rectangle.getHeight() / 2.0;
            return Math.PI * 2 * Math.sqrt((a * a + b * b) / 2.0);
        }
        return this.getBlob().getPerimeter();
    }

    private Statistics getStatistics() {
        return this.stat == null ? (this.stat = new Statistics(this.getBlob().getBlobSumCoorXY())) : this.stat;
    }

    private double getBaryCenterX() {
        if (this.shape instanceof Rectangle2D || this.shape instanceof Ellipse2D) {
            return this.shape.getBounds2D().getWidth() / 2.0;
        }
        return this.getStatistics().getBarycenterX();
    }

    private double getBaryCenterY() {
        if (this.shape instanceof Rectangle2D || this.shape instanceof Ellipse2D) {
            return this.shape.getBounds2D().getHeight() / 2.0;
        }
        return this.getStatistics().getBarycentery();
    }

    private double getOrientation() {
        if (this.shape instanceof Rectangle2D || this.shape instanceof Ellipse2D) {
            Rectangle2D rectangle = this.shape.getBounds2D();
            return rectangle.getWidth() < rectangle.getHeight() ? 1.5707963267948966 : 0.0;
        }
        return this.getStatistics().orientationInRadian();
    }

    private double getEccentricity() {
        if (this.shape instanceof Rectangle2D || this.shape instanceof Ellipse2D) {
            Rectangle2D rectangle = this.shape.getBounds2D();
            double ratio = rectangle.getWidth() < rectangle.getHeight() ? (rectangle.getHeight() + 1.0) / (rectangle.getWidth() + 1.0) : (rectangle.getWidth() + 1.0) / (rectangle.getHeight() + 1.0);
            return ratio * ratio;
        }
        return this.getStatistics().eccentricity();
    }

    public static double[] getLengthAndWidth(Shape shape, double teta) {
        double[] sum = new double[2];
        if (shape == null) {
            return sum;
        }
        if (shape.getBounds().width == 1 && shape.getBounds().width == 1) {
            sum[0] = 1.0;
            sum[1] = 1.0;
        } else {
            AffineTransform trans = AffineTransform.getRotateInstance(-teta);
            Shape shapeRotate = trans.createTransformedShape(shape);
            sum[0] = shapeRotate.getBounds2D().getHeight();
            sum[1] = shapeRotate.getBounds2D().getWidth();
            if (sum[1] > sum[0]) {
                double temp = sum[1];
                sum[1] = sum[0];
                sum[0] = temp;
            }
        }
        return sum;
    }

    public static double convertOrientationToTrigoDegree(double tetaAngle) {
        double angle = Math.toDegrees(tetaAngle);
        angle = angle < 0.0 ? -1.0 * angle : 180.0 - angle;
        return angle;
    }

    public static ArrayList<String> getObjectMeasureList(boolean[] select) {
        ArrayList<String> list = new ArrayList<String>(select.length);
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            list.add(measurList[i]);
        }
        list.trimToSize();
        return list;
    }

    public static String[] createHeaders(boolean[] selected) {
        ArrayList<String> measures = Measure2DAnalyse.getObjectMeasureList(selected);
        return measures.toArray(new String[measures.size()]);
    }
}

