/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.ui.editor.image.DefaultView2d;

public class GraphicLabel
implements Cloneable {
    protected static final int GROWING_BOUND = 3;
    protected String[] labelStringArray;
    protected Rectangle2D labelBounds;
    protected double labelWidth;
    protected double labelHeight;
    protected double offsetX = 0.0;
    protected double offsetY = 0.0;

    protected void reset() {
        this.labelStringArray = null;
        this.labelBounds = null;
        this.labelWidth = 0.0;
        this.labelHeight = 0.0;
    }

    public String[] getLabels() {
        return this.labelStringArray;
    }

    public Rectangle2D getBounds(AffineTransform transform) {
        return this.getArea(transform).getBounds2D();
    }

    public Area getArea(AffineTransform transform) {
        if (this.labelBounds == null) {
            return new Area();
        }
        if (transform == null) {
            return new Area(this.labelBounds);
        }
        AffineTransform invTransform = new AffineTransform();
        Point2D.Double anchorPt = new Point2D.Double(this.labelBounds.getX(), this.labelBounds.getY());
        double scale = GeomUtil.extractScalingFactor((AffineTransform)transform);
        double angleRad = GeomUtil.extractAngleRad((AffineTransform)transform);
        invTransform.translate(((Point2D)anchorPt).getX(), ((Point2D)anchorPt).getY());
        if (scale != 1.0) {
            invTransform.scale(1.0 / scale, 1.0 / scale);
        }
        if (angleRad != 0.0) {
            invTransform.rotate(-angleRad);
        }
        invTransform.translate(-((Point2D)anchorPt).getX(), -((Point2D)anchorPt).getY());
        if ((transform.getType() & 0x40) != 0) {
            invTransform.translate(0.0, -this.labelBounds.getHeight());
        }
        Area areaBounds = new Area(invTransform.createTransformedShape(this.labelBounds));
        areaBounds.transform(AffineTransform.getTranslateInstance(this.offsetX, this.offsetY));
        return areaBounds;
    }

    public Rectangle2D getTransformedBounds(AffineTransform transform) {
        Point2D.Double anchorPoint = new Point2D.Double(this.labelBounds.getX() + this.offsetX, this.labelBounds.getY() + this.offsetY);
        if (transform != null) {
            transform.transform(anchorPoint, anchorPoint);
        }
        return new Rectangle2D.Double(anchorPoint.getX(), anchorPoint.getY(), this.labelBounds.getWidth(), this.labelBounds.getHeight());
    }

    public void setLabel(DefaultView2d view2d, double xPos, double yPos, String ... labels) {
        if (view2d == null || labels == null || labels.length == 0) {
            this.reset();
        } else {
            this.labelStringArray = labels;
            Font defaultFont = view2d.getEventManager().getViewSetting().getFont();
            FontRenderContext fontRenderContext = ((Graphics2D)view2d.getGraphics()).getFontRenderContext();
            this.updateBoundsSize(defaultFont, fontRenderContext);
            this.labelBounds = new Rectangle2D.Double(xPos + 3.0, yPos + 3.0, this.labelWidth + 3.0, this.labelHeight * (double)labels.length + 3.0);
            GeomUtil.growRectangle((Rectangle2D)this.labelBounds, (double)3.0);
        }
    }

    protected void updateBoundsSize(Font defaultFont, FontRenderContext fontRenderContext) {
        if (defaultFont == null) {
            throw new RuntimeException("Font should not be null");
        }
        if (fontRenderContext == null) {
            throw new RuntimeException("FontRenderContext should not be null");
        }
        if (this.labelStringArray == null || this.labelStringArray.length == 0) {
            this.reset();
        } else {
            double maxWidth = 0.0;
            for (String label : this.labelStringArray) {
                if (label.length() <= 0) continue;
                TextLayout layout = new TextLayout(label, defaultFont, fontRenderContext);
                maxWidth = Math.max(layout.getBounds().getWidth(), maxWidth);
            }
            this.labelHeight = new TextLayout("Tg", defaultFont, fontRenderContext).getBounds().getHeight() + 2.0;
            this.labelWidth = maxWidth;
        }
    }

    protected void move(double deltaX, double deltaY) {
        this.offsetX += deltaX;
        this.offsetY += deltaY;
    }

    public void paint(Graphics2D g2d, AffineTransform transform, boolean selected) {
        if (this.labelStringArray != null && this.labelBounds != null) {
            Paint oldPaint = g2d.getPaint();
            Point2D.Double pt = new Point2D.Double(this.labelBounds.getX() + this.offsetX, this.labelBounds.getY() + this.offsetY);
            if (transform != null) {
                transform.transform(pt, pt);
            }
            float px = (float)((Point2D)pt).getX() + 3.0f;
            float py = (float)((Point2D)pt).getY() + 3.0f;
            for (String label : this.labelStringArray) {
                if (label.length() <= 0) continue;
                py = (float)((double)py + this.labelHeight);
                this.paintFontOutline(g2d, label, px, py);
            }
            if (selected) {
                this.paintBoundOutline(g2d, transform);
            }
            g2d.setPaint(oldPaint);
        }
    }

    protected void paintBoundOutline(Graphics2D g2d, AffineTransform transform) {
        Rectangle2D boundingRect = this.getTransformedBounds(transform);
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(Color.BLACK);
        g2d.draw(boundingRect);
        GeomUtil.growRectangle((Rectangle2D)boundingRect, (double)-1.0);
        g2d.setPaint(Color.WHITE);
        g2d.draw(boundingRect);
        g2d.setPaint(oldPaint);
    }

    protected void paintFontOutline(Graphics2D g2d, String str, float x, float y) {
        Paint oldPaint = g2d.getPaint();
        TextLayout layout = new TextLayout(str, g2d.getFont(), g2d.getFontRenderContext());
        g2d.setPaint(Color.BLACK);
        layout.draw(g2d, x - 1.0f, y - 1.0f);
        layout.draw(g2d, x - 1.0f, y);
        layout.draw(g2d, x - 1.0f, y + 1.0f);
        layout.draw(g2d, x, y - 1.0f);
        layout.draw(g2d, x, y + 1.0f);
        layout.draw(g2d, x + 1.0f, y - 1.0f);
        layout.draw(g2d, x + 1.0f, y);
        layout.draw(g2d, x + 1.0f, y + 1.0f);
        g2d.setPaint(Color.WHITE);
        layout.draw(g2d, x, y);
        g2d.setPaint(oldPaint);
    }

    protected GraphicLabel clone() {
        GraphicLabel cloneLabel = null;
        try {
            cloneLabel = (GraphicLabel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return cloneLabel;
    }
}

