/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.graphic.RectangleGraphic;
import org.weasis.core.ui.util.MouseEventDouble;

public class EllipseGraphic
extends RectangleGraphic {
    public static final Icon ICON = new ImageIcon(EllipseGraphic.class.getResource("/icon/22x22/draw-eclipse.png"));
    public static final Measurement CenterX = new Measurement("Center X", true, true, false);
    public static final Measurement CenterY = new Measurement("Center Y", true, true, false);
    public static final Measurement Width = new Measurement("Width", true, true, false);
    public static final Measurement Height = new Measurement("Height", true, true, false);
    public static final Measurement Area = new Measurement("Area", true, true, true);
    public static final Measurement Perimeter = new Measurement("Perimeter", true, true, false);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true, true, false);

    public EllipseGraphic(float lineThickness, Color paint, boolean labelVisible) {
        super(lineThickness, paint, labelVisible);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getUIName() {
        return Messages.getString("MeasureToolBar.ellipse");
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseevent) {
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.setFrameFromDiagonal((Point2D)this.handlePointList.get(RectangleGraphic.eHandlePoint.NW.index), (Point2D)this.handlePointList.get(RectangleGraphic.eHandlePoint.SE.index));
        this.setShape(new Ellipse2D.Double(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight()), mouseevent);
        this.updateLabel(mouseevent, this.getDefaultView2d(mouseevent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() > 1 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            List<MeasureItem> stats;
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrameFromDiagonal((Point2D)this.handlePointList.get(RectangleGraphic.eHandlePoint.NW.index), (Point2D)this.handlePointList.get(RectangleGraphic.eHandlePoint.SE.index));
            double ratio = adapter.getCalibRatio();
            if (CenterX.isComputed() && (!drawOnLabel || CenterX.isGraphicLabel())) {
                val = releaseEvent || CenterX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(rect.getCenterX())) : null;
                measVal.add(new MeasureItem(CenterX, val, adapter.getUnit()));
            }
            if (CenterY.isComputed() && (!drawOnLabel || CenterY.isGraphicLabel())) {
                val = releaseEvent || CenterY.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(rect.getCenterY())) : null;
                measVal.add(new MeasureItem(CenterY, val, adapter.getUnit()));
            }
            if (Width.isComputed() && (!drawOnLabel || Width.isGraphicLabel())) {
                val = releaseEvent || Width.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getWidth()) : null;
                measVal.add(new MeasureItem(Width, val, adapter.getUnit()));
            }
            if (Height.isComputed() && (!drawOnLabel || Height.isGraphicLabel())) {
                val = releaseEvent || Height.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getHeight()) : null;
                measVal.add(new MeasureItem(Height, val, adapter.getUnit()));
            }
            if (Area.isComputed() && (!drawOnLabel || Area.isGraphicLabel())) {
                val = releaseEvent || Area.isQuickComputing() ? Double.valueOf(Math.PI * ((RectangularShape)rect).getWidth() * ratio * ((RectangularShape)rect).getHeight() * ratio / 4.0) : null;
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(Area, val, unit));
            }
            if ((stats = this.getImageStatistics(imageElement, releaseEvent)) != null) {
                measVal.addAll(stats);
            }
            return measVal;
        }
        return null;
    }
}

