/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class AngleToolGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(AngleToolGraphic.class.getResource("/icon/22x22/draw-angle.png"));
    public static final Measurement Angle = new Measurement("Angle", true);
    public static final Measurement ComplementaryAngle = new Measurement("Compl. Angle", true);
    public static final int ARC_RADIUS = 32;

    public AngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(3, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Angle measure";
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                AbstractDragGraphic.AdvancedShape newShape = new AbstractDragGraphic.AdvancedShape(2);
                Path2D.Double generalpath = new Path2D.Double(1, this.handlePointList.size());
                newShape.addShape(generalpath);
                Point2D P = (Point2D)this.handlePointList.get(1);
                ((Path2D)generalpath).moveTo(A.getX(), A.getY());
                ((Path2D)generalpath).lineTo(P.getX(), P.getY());
                if (this.handlePointList.size() >= 3) {
                    Point2D B = (Point2D)this.handlePointList.get(2);
                    ((Path2D)generalpath).lineTo(B.getX(), B.getY());
                    double angularExtent = GeomUtil.getAngleDeg((Point2D)A, (Point2D)P, (Point2D)B);
                    angularExtent = GeomUtil.getSmallestRotationAngleDeg((double)angularExtent);
                    double startingAngle = GeomUtil.getAngleDeg((Point2D)P, (Point2D)A);
                    double radius = 32.0;
                    Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(P.getX() - radius, P.getY() - radius, 2.0 * radius, 2.0 * radius);
                    Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, angularExtent, 0);
                    double rMax = 0.6666666666666666 * Math.min(P.distance(A), P.distance(B));
                    double scalingMin = radius / rMax;
                    newShape.addInvShape((Shape)arcAngle, (Point2D)P.clone(), scalingMin, false);
                }
                this.setShape(newShape, mouseEvent);
                this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
            }
        }
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() >= 3 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (Angle.isComputed() || ComplementaryAngle.isComputed()) {
                Point2D At = (Point2D)this.handlePointList.get(0);
                Point2D Ot = (Point2D)this.handlePointList.get(1);
                Point2D Bt = (Point2D)this.handlePointList.get(2);
                double realAngle = Math.abs(GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)At, (Point2D)Ot, (Point2D)Bt)));
                if (Angle.isComputed() && (!drawOnLabel || Angle.isGraphicLabel())) {
                    measVal.add(new MeasureItem(Angle, realAngle, "deg"));
                }
                if (ComplementaryAngle.isComputed() && (!drawOnLabel || ComplementaryAngle.isGraphicLabel())) {
                    measVal.add(new MeasureItem(ComplementaryAngle, 180.0 - realAngle, "deg"));
                }
            }
            return measVal;
        }
        return null;
    }
}

