/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ZoomWin;

public class PopUpMenuOnZoom
extends JPopupMenu {
    private final ZoomWin zoomWin;
    private final JMenuItem jMenuItemZoom = new JMenuItem();
    private final ButtonGroup buttonMagnify = new ButtonGroup();
    private final int[] magnify = new int[]{1, 2, 3, 4, 6};
    private JRadioButtonMenuItem[] jRadioButtonMenuItemMagnify;
    private final ActionListener magnifyListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PopUpMenuOnZoom.this.magnifyActionPerformed(e);
        }
    };
    private final JMenu jMenuMagnify = new JMenu();
    private final JMenu jMenuImage = new JMenu();
    private final JRadioButtonMenuItem jMenuItemMagnifyOther = new JRadioButtonMenuItem();
    private final JCheckBoxMenuItem jCheckBoxMenuItemDraw = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem jCheckBoxMenutemSychronize = new JCheckBoxMenuItem();
    private final JMenuItem resetFreeze = new JMenuItem(Messages.getString("PopUpMenuOnZoom.reset"));

    public PopUpMenuOnZoom(ZoomWin zoomWin) {
        if (zoomWin == null) {
            throw new IllegalArgumentException("ZoomWin cannot be null");
        }
        this.zoomWin = zoomWin;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jMenuItemZoom.setText(Messages.getString("PopUpMenuOnZoom.hide"));
        this.jMenuItemZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpMenuOnZoom.this.zoomWin.hideZoom();
            }
        });
        this.jCheckBoxMenuItemDraw.setText(Messages.getString("PopUpMenuOnZoom.showDraw"));
        this.jCheckBoxMenuItemDraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpMenuOnZoom.this.zoomWin.setActionInView(ActionW.DRAW.cmd(), PopUpMenuOnZoom.this.jCheckBoxMenuItemDraw.isSelected());
                PopUpMenuOnZoom.this.zoomWin.repaint();
            }
        });
        this.jMenuImage.setText(Messages.getString("PopUpMenuOnZoom.image"));
        JMenuItem freezParams = new JMenuItem(Messages.getString("PopUpMenuOnZoom.freeze"));
        freezParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpMenuOnZoom.this.zoomWin.setFreezeImage(PopUpMenuOnZoom.this.zoomWin.freezeParentParameters(), ZoomWin.SYNCH_TYPE.ParentParameters);
            }
        });
        this.jMenuImage.add(freezParams);
        JMenuItem freeze = new JMenuItem(Messages.getString("PopUpMenuOnZoom.freezeImg"));
        freeze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpMenuOnZoom.this.zoomWin.setFreezeImage(PopUpMenuOnZoom.this.zoomWin.freezeParentImage(), ZoomWin.SYNCH_TYPE.ParentImage);
            }
        });
        this.jMenuImage.add(freeze);
        this.jMenuImage.addSeparator();
        this.resetFreeze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpMenuOnZoom.this.zoomWin.setFreezeImage(null, ZoomWin.SYNCH_TYPE.None);
            }
        });
        this.jMenuImage.add(this.resetFreeze);
        this.jMenuMagnify.setText(Messages.getString("PopUpMenuOnZoom.magnify"));
        this.jCheckBoxMenutemSychronize.setText(Messages.getString("PopUpMenuOnZoom.synch"));
        this.jCheckBoxMenutemSychronize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpMenuOnZoom.this.zoomWin.setActionInView("synchronize", PopUpMenuOnZoom.this.jCheckBoxMenutemSychronize.isSelected());
                PopUpMenuOnZoom.this.zoomWin.updateZoom();
            }
        });
        this.add(this.jMenuItemZoom);
        this.addSeparator();
        this.add(this.jCheckBoxMenutemSychronize);
        this.add(this.jCheckBoxMenuItemDraw);
        this.add(this.jMenuImage);
        this.add(this.jMenuMagnify);
        this.iniMenuItemZoomMagnify();
        this.addSeparator();
    }

    public void iniMenuItemZoomMagnify() {
        this.jRadioButtonMenuItemMagnify = new JRadioButtonMenuItem[this.magnify.length];
        for (int i = 0; i < this.jRadioButtonMenuItemMagnify.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            item.setText(this.magnify[i] + "X");
            this.buttonMagnify.add(item);
            item.addActionListener(this.magnifyListener);
            this.jMenuMagnify.add(item);
            this.jRadioButtonMenuItemMagnify[i] = item;
        }
    }

    public void enableMenuItem() {
        Double ratio;
        this.jCheckBoxMenutemSychronize.setSelected((Boolean)this.zoomWin.getActionValue("synchronize"));
        this.jCheckBoxMenuItemDraw.setSelected((Boolean)this.zoomWin.getActionValue(ActionW.DRAW.cmd()));
        Object img = this.zoomWin.getActionValue("freeze");
        this.resetFreeze.setEnabled(img != null);
        boolean noselection = true;
        if (this.jRadioButtonMenuItemMagnify.length < this.jMenuMagnify.getItemCount()) {
            this.jMenuMagnify.remove(this.jMenuItemMagnifyOther);
        }
        if ((ratio = (Double)this.zoomWin.getActionValue(ActionW.ZOOM.cmd())) == null) {
            ratio = 1.0;
        }
        int currentZoomRatio = (int)(ratio * 100.0);
        for (int i = 0; i < this.jRadioButtonMenuItemMagnify.length; ++i) {
            if (this.magnify[i] * 100 != currentZoomRatio) continue;
            JRadioButtonMenuItem item3 = this.jRadioButtonMenuItemMagnify[i];
            item3.setSelected(true);
            noselection = false;
            break;
        }
        if (noselection) {
            ratio = Math.abs(ratio);
            this.jMenuItemMagnifyOther.setText(ratio + "X");
            this.buttonMagnify.add(this.jMenuItemMagnifyOther);
            if ((double)this.magnify[this.magnify.length - 1] < ratio) {
                this.jMenuMagnify.add(this.jMenuItemMagnifyOther);
            } else {
                int k = 0;
                for (int i = 0; i < this.magnify.length; ++i) {
                    if (!((double)this.magnify[i] > ratio)) continue;
                    k = i;
                    break;
                }
                this.jMenuMagnify.add((Component)this.jMenuItemMagnifyOther, k);
            }
            this.jMenuItemMagnifyOther.setSelected(true);
        }
    }

    private void magnifyActionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)e.getSource();
            for (int i = 0; i < this.jRadioButtonMenuItemMagnify.length; ++i) {
                if (!item.equals(this.jRadioButtonMenuItemMagnify[i])) continue;
                ImageViewerEventManager manager = this.zoomWin.getView2d().getEventManager();
                ActionState zoomAction = manager.getAction(ActionW.LENSZOOM);
                if (!(zoomAction instanceof SliderChangeListener)) break;
                ((SliderChangeListener)zoomAction).setValue(manager.viewScaleToSliderValue(this.magnify[i]));
                break;
            }
        }
    }
}

