/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.MouseActionAdapter;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.DragPoint;

public abstract class PannerListener
extends MouseActionAdapter
implements ActionState,
KeyListener {
    protected final ActionW action;
    private boolean enable;
    private final boolean triggerAction = true;
    private Point pickPoint;
    private Point2D point;

    public PannerListener(ActionW action, Point2D point) {
        this.action = action;
        this.point = point == null ? new Point2D.Double() : point;
        this.enable = true;
    }

    public void enableAction(boolean enabled) {
        this.enable = enabled;
    }

    public Point2D getPoint() {
        return (Point2D)this.point.clone();
    }

    public void setPoint(Point2D point) {
        if (point != null) {
            this.point = point;
            this.pointChanged(point);
        }
    }

    public boolean isTriggerAction() {
        return true;
    }

    public ActionW getActionW() {
        return this.action;
    }

    public String getValueToDisplay() {
        return "x:" + this.point.getX() + ", y:" + this.point.getY();
    }

    public abstract void pointChanged(Point2D var1);

    public String toString() {
        return this.action.getTitle();
    }

    private DefaultView2d getDefaultView2d(InputEvent e) {
        Object source = e.getSource();
        if (source instanceof DefaultView2d) {
            return (DefaultView2d)source;
        }
        return null;
    }

    public void mousePressed(MouseEvent e) {
        DefaultView2d panner;
        int buttonMask = this.getButtonMaskEx();
        if ((e.getModifiersEx() & buttonMask) != 0 && (panner = this.getDefaultView2d(e)) != null) {
            this.pickPoint = e.getPoint();
            double scale = panner.getViewModel().getViewScale();
            this.setPoint(new DragPoint(DragPoint.STATE.Started, -(this.pickPoint.getX() / scale), -(this.pickPoint.getY() / scale)));
        }
    }

    public void mouseDragged(MouseEvent e) {
        DefaultView2d panner;
        int buttonMask = this.getButtonMaskEx();
        if ((e.getModifiersEx() & buttonMask) != 0 && (panner = this.getDefaultView2d(e)) != null && this.pickPoint != null) {
            double scale = panner.getViewModel().getViewScale();
            this.setPoint(new DragPoint(DragPoint.STATE.Dragged, -(((double)e.getX() - this.pickPoint.getX()) / scale), -(((double)e.getY() - this.pickPoint.getY()) / scale)));
            panner.setPointerType(1);
        }
    }

    public void mouseReleased(MouseEvent e) {
        DefaultView2d panner;
        int buttonMask = this.getButtonMask();
        if ((e.getModifiers() & buttonMask) != 0 && (panner = this.getDefaultView2d(e)) != null) {
            panner.setPointerType(0);
            panner.repaint();
        }
    }

    public void reset() {
        this.pickPoint = null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            this.setPoint(new Point(5, 0));
        } else if (e.getKeyCode() == 38) {
            this.setPoint(new Point(0, 5));
        } else if (e.getKeyCode() == 39) {
            this.setPoint(new Point(-5, 0));
        } else if (e.getKeyCode() == 40) {
            this.setPoint(new Point(0, -5));
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

