/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.impl.PropertyImpl;

public class CapabilityImpl
implements Capability {
    private String m_name = null;
    private final Map m_map = new HashMap();
    private final List m_list = new ArrayList();

    public CapabilityImpl() {
    }

    public CapabilityImpl(String name) {
        this.setName(name);
    }

    public CapabilityImpl(String name, PropertyImpl[] properties) {
        this.setName(name);
        for (int i = 0; properties != null && i < properties.length; ++i) {
            this.addProperty(properties[i]);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    public Map getPropertiesAsMap() {
        return this.m_map;
    }

    public Property[] getProperties() {
        return this.m_list.toArray(new Property[this.m_list.size()]);
    }

    public void addProperty(Property prop) {
        this.m_map.put(prop.getName().toLowerCase(), prop.getConvertedValue());
        this.m_list.add(prop);
    }

    public void addProperty(String name, String value) {
        this.addProperty(name, null, value);
    }

    public void addProperty(String name, String type, String value) {
        this.addProperty(new PropertyImpl(name, type, value));
    }

    public String toString() {
        return this.m_name + ":" + this.m_map.toString();
    }
}

