/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.sling.commons.log.internal.slf4j.FileRotator;

final class SizeLimitedFileRotator
implements FileRotator {
    private final int maxIndex;
    private final long maxSize;

    SizeLimitedFileRotator(int maxNum, long maxSize) {
        this.maxIndex = maxNum - 1;
        this.maxSize = maxSize;
    }

    int getMaxIndex() {
        return this.maxIndex;
    }

    long getMaxSize() {
        return this.maxSize;
    }

    public boolean isRotationDue(File file) {
        return file.length() > this.maxSize;
    }

    public void rotate(File file) {
        if (this.maxIndex >= 0) {
            String baseName = file.getAbsolutePath();
            File dstFile = new File(baseName + "." + this.maxIndex);
            if (dstFile.exists()) {
                dstFile.delete();
            }
            for (int i = this.maxIndex - 1; i >= 0; --i) {
                File srcFile = new File(baseName + "." + i);
                if (srcFile.exists()) {
                    srcFile.renameTo(dstFile);
                }
                dstFile = srcFile;
            }
            file.renameTo(dstFile);
        } else {
            file.delete();
        }
    }

    public File[] getRotatedFiles(File file) {
        File dir = file.getParentFile();
        final String baseName = file.getName();
        File[] logFiles = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(baseName);
            }
        });
        return logFiles;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": maxSize=" + this.getMaxSize() + ", generations=" + (this.getMaxIndex() + 1);
    }
}

