/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.base.ui.gui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerListener;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentManagerUIListener;
import org.noos.xing.mydoggy.MultiSplitConstraint;
import org.noos.xing.mydoggy.TabbedContentManagerUI;
import org.noos.xing.mydoggy.TabbedContentUI;
import org.noos.xing.mydoggy.event.ContentManagerEvent;
import org.noos.xing.mydoggy.event.ContentManagerUIEvent;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyMultiSplitContentManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.base.ui.Messages;
import org.weasis.base.ui.action.ExitAction;
import org.weasis.base.ui.action.OpenPreferencesAction;
import org.weasis.base.ui.gui.WeasisAboutBox;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.explorer.model.TreeModel;
import org.weasis.core.api.explorer.model.TreeModelNode;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.gui.util.GhostGlassPane;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.media.data.Thumbnail;
import org.weasis.core.api.service.BundleTools;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.MimeSystemAppViewer;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.core.ui.editor.ViewerPluginBuilder;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.core.ui.util.ToolBarContainer;
import org.weasis.core.ui.util.UriListFlavor;
import org.weasis.core.ui.util.WtoolBar;

public class WeasisWin
extends JFrame
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(WeasisWin.class);
    private static final JMenu menuFile = new JMenu(Messages.getString("WeasisWin.file"));
    private static final JMenu menuSelectedPlugin = new JMenu();
    private static ViewerPlugin selectedPlugin = null;
    private static final WeasisWin instance = new WeasisWin();
    private final ToolBarContainer toolbarContainer;
    private volatile boolean busy = false;

    private WeasisWin() {
        this.setJMenuBar(this.createMenuBar());
        this.toolbarContainer = new ToolBarContainer();
        this.getContentPane().add((Component)this.toolbarContainer, "North");
        this.setTitle("Weasis v" + AbstractProperties.WEASIS_VERSION);
        this.setIconImage(new ImageIcon(UIManager.class.getResource("/icon/logo-button.png")).getImage());
    }

    public static WeasisWin getInstance() {
        return instance;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && !this.closeWindow()) {
            return;
        }
        super.processWindowEvent(e);
    }

    public boolean closeWindow() {
        if (this.busy) {
            return false;
        }
        if (BundleTools.SYSTEM_PREFERENCES.getBooleanProperty("weasis.confirm.closing", true)) {
            int option = JOptionPane.showConfirmDialog(instance, Messages.getString("WeasisWin.exit_mes"));
            if (option == 0) {
                System.exit(0);
                return true;
            }
        } else {
            System.exit(0);
            return true;
        }
        return false;
    }

    private void initToolWindowManager() throws Exception {
        this.initContentManager();
        this.getContentPane().add((Component)UIManager.toolWindowManager, "Center");
    }

    protected void initContentManager() throws Exception {
        ContentManager contentManager = UIManager.toolWindowManager.getContentManager();
        MyDoggyMultiSplitContentManagerUI contentManagerUI = new MyDoggyMultiSplitContentManagerUI();
        contentManager.setContentManagerUI((ContentManagerUI)contentManagerUI);
        contentManagerUI.setMinimizable(false);
        contentManagerUI.setShowAlwaysTab(true);
        contentManagerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.TOP);
        JComponent mainContainer = (JComponent)UIManager.toolWindowManager.getMainContainer();
        mainContainer.setDropTarget(null);
        mainContainer.setTransferHandler(new SequenceHandler());
        contentManagerUI.addContentManagerUIListener(new ContentManagerUIListener(){

            public boolean contentUIRemoving(ContentManagerUIEvent event) {
                Component c = event.getContentUI().getContent().getComponent();
                if (c instanceof ViewerPlugin) {
                    ((ViewerPlugin)c).close();
                }
                return true;
            }

            public void contentUIDetached(ContentManagerUIEvent event) {
            }
        });
        contentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentSelected(ContentManagerEvent event) {
                Component plugin = event.getContent().getComponent();
                if (plugin instanceof ViewerPlugin && ContentManagerEvent.ActionId.CONTENT_SELECTED.equals((Object)event.getId())) {
                    WeasisWin.this.setSelectedPlugin((ViewerPlugin)plugin);
                }
            }

            public void contentRemoved(ContentManagerEvent event) {
            }

            public void contentAdded(ContentManagerEvent event) {
            }
        });
    }

    public void createMainPanel() throws Exception {
        this.initToolWindowManager();
        this.setGlassPane((Component)AbstractProperties.glassPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof ObservableEvent) {
            ObservableEvent event = (ObservableEvent)evt;
            ObservableEvent.BasicAction action = event.getActionCommand();
            Object source = event.getNewValue();
            if (evt.getSource() instanceof DataExplorerModel) {
                if (ObservableEvent.BasicAction.Select.equals((Object)action)) {
                    if (source instanceof DataExplorerModel) {
                        DataExplorerModel model = (DataExplorerModel)source;
                        DataExplorerView view = null;
                        List list = UIManager.EXPLORER_PLUGINS;
                        synchronized (list) {
                            List explorers = UIManager.EXPLORER_PLUGINS;
                            for (DataExplorerView dataExplorerView : explorers) {
                                if (dataExplorerView.getDataExplorerModel() != model) continue;
                                view = dataExplorerView;
                                break;
                            }
                            if (view instanceof PluginTool) {
                                ((PluginTool)view).showDockable();
                            }
                        }
                    } else if (source instanceof MediaSeriesGroup) {
                        MediaSeriesGroup group = (MediaSeriesGroup)source;
                        List view = UIManager.VIEWER_PLUGINS;
                        synchronized (view) {
                            for (int i = UIManager.VIEWER_PLUGINS.size() - 1; i >= 0; --i) {
                                ViewerPlugin p = (ViewerPlugin)UIManager.VIEWER_PLUGINS.get(i);
                                if (!group.equals(p.getGroupID())) continue;
                                p.setSelectedAndGetFocus();
                                break;
                            }
                        }
                    }
                } else if (ObservableEvent.BasicAction.Register.equals((Object)action)) {
                    if (source instanceof ViewerPlugin) {
                        this.registerPlugin((ViewerPlugin)source);
                    } else if (source instanceof ViewerPluginBuilder) {
                        ViewerPluginBuilder builder = (ViewerPluginBuilder)source;
                        SeriesViewerFactory factory = builder.getFactory();
                        DataExplorerModel model = builder.getModel();
                        MediaSeries[] series = builder.getSeries();
                        if (builder.isCompareEntryToBuildNewViewer() && model.getTreeModelNodeForNewPlugin() != null) {
                            TreeModel treeModel = (TreeModel)model;
                            if (series.length == 1) {
                                MediaSeries s = series[0];
                                MediaSeriesGroup group = treeModel.getParent((MediaSeriesGroup)s, model.getTreeModelNodeForNewPlugin());
                                this.openSeriesInViewerPlugin(factory, model, group, series);
                            } else if (series.length > 1) {
                                HashMap<MediaSeriesGroup, List<MediaSeries>> map = this.getSeriesByEntry(treeModel, series, model.getTreeModelNodeForNewPlugin());
                                for (Map.Entry<MediaSeriesGroup, List<MediaSeries>> entry : map.entrySet()) {
                                    MediaSeriesGroup group = entry.getKey();
                                    List<MediaSeries> seriesList = entry.getValue();
                                    this.openSeriesInViewerPlugin(factory, model, group, seriesList.toArray(new MediaSeries[seriesList.size()]));
                                }
                            }
                        } else {
                            this.openSeriesInViewerPlugin(factory, model, null, series);
                        }
                    }
                } else if (ObservableEvent.BasicAction.Unregister.equals((Object)action) && source instanceof SeriesViewerFactory) {
                    SeriesViewerFactory viewerFactory = (SeriesViewerFactory)source;
                    final ArrayList<ViewerPlugin> pluginsToRemove = new ArrayList<ViewerPlugin>();
                    String name = viewerFactory.getUIName();
                    List list = UIManager.VIEWER_PLUGINS;
                    synchronized (list) {
                        for (ViewerPlugin plugin : UIManager.VIEWER_PLUGINS) {
                            if (!name.equals(plugin.getName())) continue;
                            pluginsToRemove.add(plugin);
                        }
                    }
                    GuiExecutor.instance().execute(new Runnable(){

                        @Override
                        public void run() {
                            for (ViewerPlugin viewerPlugin : pluginsToRemove) {
                                viewerPlugin.close();
                                Content content = UIManager.toolWindowManager.getContentManager().getContent((Object)viewerPlugin.getDockableUID());
                                if (content == null) continue;
                                UIManager.toolWindowManager.getContentManager().removeContent(content);
                            }
                        }
                    });
                }
            }
        }
    }

    private HashMap<MediaSeriesGroup, List<MediaSeries>> getSeriesByEntry(TreeModel treeModel, MediaSeries[] series, TreeModelNode entry) {
        HashMap<MediaSeriesGroup, List<MediaSeries>> map = new HashMap<MediaSeriesGroup, List<MediaSeries>>();
        for (MediaSeries s : series) {
            MediaSeriesGroup entry1 = treeModel.getParent((MediaSeriesGroup)s, entry);
            List<MediaSeries> seriesList = map.get(entry1);
            if (seriesList == null) {
                seriesList = new ArrayList<MediaSeries>();
            }
            seriesList.add(s);
            map.put(entry1, seriesList);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSeriesInViewerPlugin(SeriesViewerFactory factory, DataExplorerModel model, MediaSeriesGroup group, MediaSeries[] seriesList) {
        SeriesViewer seriesViewer;
        if (factory == null || seriesList == null || seriesList.length == 0) {
            return;
        }
        if (factory != null && group != null) {
            List list = UIManager.VIEWER_PLUGINS;
            synchronized (list) {
                for (ViewerPlugin p : UIManager.VIEWER_PLUGINS) {
                    if (!(p instanceof ImageViewerPlugin) || !p.getName().equals(factory.getUIName()) || !group.equals(p.getGroupID())) continue;
                    ImageViewerPlugin viewer = (ImageViewerPlugin)p;
                    viewer.changeLayoutModel(viewer.getBestDefaultViewLayout(seriesList.length));
                    p.setSelectedAndGetFocus();
                    this.selectLayoutPositionForAddingSeries(viewer, seriesList.length);
                    for (int i = 0; i < seriesList.length; ++i) {
                        viewer.addSeries(seriesList[i]);
                    }
                    p.setSelected(true);
                    p.repaint();
                    return;
                }
            }
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put(DataExplorerModel.class.getName(), model);
        if (seriesList.length > 1) {
            properties.put(DefaultView2d.class.getName(), seriesList.length);
        }
        if ((seriesViewer = factory.createSeriesViewer(properties)) instanceof MimeSystemAppViewer) {
            for (MediaSeries m : seriesList) {
                seriesViewer.addSeries(m);
            }
        } else if (seriesViewer instanceof ViewerPlugin) {
            ViewerPlugin viewer = (ViewerPlugin)seriesViewer;
            if (group != null) {
                viewer.setGroupID(group);
                viewer.setPluginName(group.toString());
            }
            this.registerPlugin(viewer);
            viewer.setSelectedAndGetFocus();
            if (seriesViewer instanceof ImageViewerPlugin) {
                this.selectLayoutPositionForAddingSeries((ImageViewerPlugin)viewer, seriesList.length);
            }
            for (MediaSeries m : seriesList) {
                viewer.addSeries(m);
            }
            viewer.setSelected(true);
        }
    }

    private void selectLayoutPositionForAddingSeries(ImageViewerPlugin viewer, int seriesNumber) {
        ArrayList view2ds = viewer.getImagePanels();
        int pos = view2ds.size() - seriesNumber;
        if (pos < 0) {
            pos = 0;
        }
        viewer.setSelectedImagePane((DefaultView2d)view2ds.get(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(ViewerPlugin plugin) {
        List list = UIManager.VIEWER_PLUGINS;
        synchronized (list) {
            if (plugin == null || UIManager.VIEWER_PLUGINS.contains(plugin)) {
                return;
            }
            UIManager.VIEWER_PLUGINS.add(plugin);
            ContentManager contentManager = UIManager.toolWindowManager.getContentManager();
            if (contentManager.getContentCount() > 0) {
                Content win = contentManager.getContent((Object)plugin.getDockableUID());
                if (win == null) {
                    contentManager.addContent(plugin.getDockableUID(), plugin.getPluginName(), plugin.getIcon(), (Component)plugin, null, new Object[]{new MultiSplitConstraint(contentManager.getContent(0), 0)});
                }
            } else {
                contentManager.addContent(plugin.getDockableUID(), plugin.getPluginName(), plugin.getIcon(), (Component)plugin);
                TabbedContentUI contentUI = (TabbedContentUI)UIManager.toolWindowManager.getContentManager().getContent(0).getContentUI();
                contentUI.setCloseable(true);
                contentUI.setDetachable(true);
                contentUI.setTransparentMode(true);
                contentUI.setTransparentRatio(0.7f);
                contentUI.setTransparentDelay(1000);
                contentUI.setMinimizable(false);
            }
        }
    }

    public synchronized ViewerPlugin getSelectedPlugin() {
        return selectedPlugin;
    }

    public synchronized void setSelectedPlugin(ViewerPlugin plugin) {
        WtoolBar[] oldToolBar;
        PluginTool[] oldTool;
        if (plugin == null) {
            return;
        }
        if (selectedPlugin == plugin) {
            plugin.requestFocusInWindow();
            return;
        }
        ViewerPlugin oldPlugin = selectedPlugin;
        selectedPlugin = plugin;
        selectedPlugin.setSelected(true);
        selectedPlugin.fillSelectedPluginMenu(menuSelectedPlugin);
        PluginTool[] tool = selectedPlugin.getToolPanel();
        PluginTool[] pluginToolArray = oldTool = oldPlugin == null ? null : oldPlugin.getToolPanel();
        if (tool == null) {
            if (oldTool != null) {
                for (PluginTool p : oldTool) {
                    p.closeDockable();
                }
            }
        } else if (tool != oldTool) {
            if (oldTool != null) {
                for (PluginTool p : oldTool) {
                    p.closeDockable();
                }
            }
            for (PluginTool p : tool) {
                p.registerToolAsDockable();
            }
        }
        WtoolBar[] toolBar = selectedPlugin.getToolBar();
        WtoolBar[] wtoolBarArray = oldToolBar = oldPlugin == null ? null : oldPlugin.getToolBar();
        if (toolBar == null) {
            if (oldToolBar != null) {
                this.toolbarContainer.unregisterAll();
            }
            this.toolbarContainer.registerToolBar(ToolBarContainer.EMPTY);
            this.toolbarContainer.revalidate();
            this.toolbarContainer.repaint();
        } else if (toolBar != oldToolBar) {
            if (oldToolBar != null) {
                this.toolbarContainer.unregisterAll();
            }
            for (WtoolBar t : toolBar) {
                this.toolbarContainer.registerToolBar(t);
            }
            this.toolbarContainer.revalidate();
            this.toolbarContainer.repaint();
        }
    }

    public GhostGlassPane getGlassPane() {
        return AbstractProperties.glassPane;
    }

    public void showWindow() throws Exception {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Toolkit kit = Toolkit.getDefaultToolkit();
        int minScreen = 0;
        int maxScreen = 0;
        Rectangle bound = null;
        GraphicsDevice[] gs = ge.getScreenDevices();
        int n = minScreen = minScreen < gs.length ? minScreen : gs.length - 1;
        maxScreen = maxScreen < minScreen ? minScreen : (maxScreen < gs.length ? maxScreen : gs.length - 1);
        for (int j = minScreen; j <= maxScreen; ++j) {
            GraphicsConfiguration config = gs[j].getDefaultConfiguration();
            Rectangle b = config.getBounds();
            Insets inset = kit.getScreenInsets(config);
            b.x -= inset.left;
            b.y -= inset.top;
            b.width -= inset.right;
            b.height -= inset.bottom;
            bound = bound == null ? b : bound.union(b);
        }
        this.setMaximizedBounds(bound);
        this.setLocation(bound.x, bound.y);
        this.setSize(bound.width - 100, bound.height - 100);
        this.setVisible(true);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.setExtendedState(6);
        log.info("End of loading the GUI...");
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        WeasisWin.buildMenuFile();
        menuBar.add(menuFile);
        menuBar.add(menuSelectedPlugin);
        JMenu helpMenuItem = new JMenu(Messages.getString("WeasisWin.help"));
        final String helpURL = System.getProperty("weasis.help.url");
        if (helpURL != null) {
            final JMenuItem helpContentMenuItem = new JMenuItem(Messages.getString("WeasisWin.guide"));
            helpContentMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        JMVUtils.OpenInDefaultBrowser((Component)helpContentMenuItem, (URL)new URL(helpURL));
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            helpMenuItem.add(helpContentMenuItem);
        }
        final JMenuItem webMenuItem = new JMenuItem(Messages.getString("WeasisWin.release"));
        webMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL("http://www.dcm4che.org/jira/browse/WEA#selectedTab=com.atlassian.jira.plugin.system.project%3Achangelog-panel");
                    JMVUtils.OpenInDefaultBrowser((Component)webMenuItem, (URL)url);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        helpMenuItem.add(webMenuItem);
        JMenuItem aboutMenuItem = new JMenuItem(Messages.getString("WeasisAboutBox.title"));
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WeasisAboutBox about = new WeasisAboutBox();
                JMVUtils.showCenterScreen((Window)about, (Window)instance);
            }
        });
        helpMenuItem.add(aboutMenuItem);
        menuBar.add(helpMenuItem);
        return menuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildImportSubMenu(JMenu importMenu) {
        List list = UIManager.EXPLORER_PLUGINS;
        synchronized (list) {
            List explorers = UIManager.EXPLORER_PLUGINS;
            for (DataExplorerView dataExplorerView : explorers) {
                Action action = dataExplorerView.getOpenImportDialogAction();
                if (action == null) continue;
                JMenuItem item = new JMenuItem(action);
                importMenu.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildExportSubMenu(JMenu exportMenu) {
        List list = UIManager.EXPLORER_PLUGINS;
        synchronized (list) {
            Action[] actions;
            if (selectedPlugin != null && (actions = selectedPlugin.getExportActions()) != null) {
                for (Action action : actions) {
                    JMenuItem item = new JMenuItem(action);
                    exportMenu.add(item);
                }
            }
            List explorers = UIManager.EXPLORER_PLUGINS;
            for (DataExplorerView dataExplorerView : explorers) {
                Action action = dataExplorerView.getOpenExportDialogAction();
                if (action == null) continue;
                JMenuItem item = new JMenuItem(action);
                exportMenu.add(item);
            }
        }
    }

    private static void buildMenuFile() {
        menuFile.removeAll();
        final JMenu importMenu = new JMenu(Messages.getString("WeasisWin.import"));
        JPopupMenu menuImport = importMenu.getPopupMenu();
        if (AbstractProperties.isMacNativeLookAndFeel()) {
            importMenu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (importMenu.isSelected()) {
                        WeasisWin.buildImportSubMenu(importMenu);
                    } else {
                        importMenu.removeAll();
                    }
                }
            });
        } else {
            menuImport.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    WeasisWin.buildImportSubMenu(importMenu);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    importMenu.removeAll();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        menuFile.add(importMenu);
        final JMenu exportMenu = new JMenu(Messages.getString("WeasisWin.export"));
        JPopupMenu menuExport = exportMenu.getPopupMenu();
        if (AbstractProperties.isMacNativeLookAndFeel()) {
            exportMenu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (exportMenu.isSelected()) {
                        WeasisWin.buildExportSubMenu(exportMenu);
                    } else {
                        exportMenu.removeAll();
                    }
                }
            });
        } else {
            menuExport.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    WeasisWin.buildExportSubMenu(exportMenu);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    exportMenu.removeAll();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        menuFile.add(exportMenu);
        menuFile.add(new JSeparator());
        menuFile.add(new JMenuItem((Action)((Object)OpenPreferencesAction.getInstance())));
        menuFile.add(new JSeparator());
        menuFile.add(new JMenuItem((Action)((Object)ExitAction.getInstance())));
    }

    private class SequenceHandler
    extends TransferHandler {
        public SequenceHandler() {
            super("series");
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            MediaSeries t;
            if (comp instanceof Thumbnail && (t = ((Thumbnail)comp).getSeries()) instanceof Series) {
                return t;
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            return support.isDataFlavorSupported(Series.sequenceDataFlavor) || support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || support.isDataFlavorSupported(UriListFlavor.uriListFlavor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            block13: {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable transferable = support.getTransferable();
                List files = null;
                if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return this.dropFiles(files, null);
                }
                if (support.isDataFlavorSupported(UriListFlavor.uriListFlavor)) {
                    try {
                        String val = (String)transferable.getTransferData(UriListFlavor.uriListFlavor);
                        files = UriListFlavor.textURIListToFileList((String)val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return this.dropFiles(files, null);
                }
                try {
                    Series seq = (Series)transferable.getTransferData(Series.sequenceDataFlavor);
                    if (seq == null) break block13;
                    List list = UIManager.SERIES_VIEWER_FACTORIES;
                    synchronized (list) {
                        for (SeriesViewerFactory factory : UIManager.SERIES_VIEWER_FACTORIES) {
                            if (!factory.canReadMimeType(seq.getMimeType())) continue;
                            DataExplorerModel model = (DataExplorerModel)seq.getTagValue(TagW.ExplorerModel);
                            if (!(model instanceof TreeModel)) break;
                            TreeModel treeModel = (TreeModel)model;
                            MediaSeriesGroup group = treeModel.getParent((MediaSeriesGroup)seq, model.getTreeModelNodeForNewPlugin());
                            WeasisWin.this.openSeriesInViewerPlugin(factory, model, group, new MediaSeries[]{seq});
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }

        private boolean dropFiles(List<File> files, DataExplorerView explorer) {
            return files != null;
        }
    }
}

