/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.base.ui;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.io.IOException;
import org.weasis.base.ui.gui.WeasisWin;
import org.weasis.core.api.command.Option;
import org.weasis.core.api.command.Options;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.gui.util.GuiExecutor;

public class WeasisApp {
    public static final String[] functions = new String[]{"info", "ui"};
    private static final WeasisApp instance = new WeasisApp();

    private WeasisApp() {
    }

    public static final WeasisApp getInstance() {
        return instance;
    }

    public void info(String[] argv) throws IOException {
        String[] usage = new String[]{"Show information about Weasis", "Usage: weasis:info [Options]", "  -v --version\t\tshow version", "  -? --help\t\tshow help"};
        Option opt = Options.compile((String[])usage).parse((Object[])argv);
        if (opt.isSet("version")) {
            System.out.println(AbstractProperties.WEASIS_VERSION);
        } else {
            opt.usage();
        }
    }

    public void ui(String[] argv) throws IOException {
        String[] usage = new String[]{"Manage user interface", "Usage: weasis:ui [Options]", "  -q --quit\t\tshutdown Weasis", "  -v --visible\t\tset window on top", "  -? --help\t\tshow help"};
        Option opt = Options.compile((String[])usage).parse((Object[])argv);
        if (opt.isSet("quit")) {
            System.exit(0);
        } else if (opt.isSet("visible")) {
            GuiExecutor.instance().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WeasisWin app = WeasisWin.getInstance();
                    app.setVisible(true);
                    int state = app.getExtendedState();
                    app.setExtendedState(state &= 0xFFFFFFFE);
                    app.setVisible(true);
                    if (app.isAlwaysOnTopSupported()) {
                        app.setAlwaysOnTop(true);
                        try {
                            Thread.sleep(500L);
                            Robot robot = new Robot();
                            Point p = app.getLocationOnScreen();
                            robot.mouseMove(p.x + app.getWidth() / 2, p.y + 5);
                            robot.mousePress(16);
                            robot.mouseRelease(16);
                        }
                        catch (AWTException e1) {
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            app.setAlwaysOnTop(false);
                        }
                    } else {
                        app.toFront();
                    }
                }
            });
        } else {
            opt.usage();
        }
    }
}

