/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.geom.Area;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class GlassPanel
extends JPanel
implements ContainerListener {
    protected RootPaneContainer rootPaneContainer;
    protected Component oldGlassPanel;
    protected Image draggingImage = null;
    protected Point location = new Point(0, 0);
    protected Point oldLocation = new Point(0, 0);
    protected int width;
    protected int height;
    protected Rectangle visibleRect = null;

    public GlassPanel(RootPaneContainer rootPaneContainer) {
        this.rootPaneContainer = rootPaneContainer;
        this.setOpaque(false);
        this.setVisible(false);
        this.setLayout(null);
        this.addContainerListener(this);
    }

    protected void paintComponent(Graphics g) {
        int y;
        int x;
        Graphics2D g2 = (Graphics2D)g;
        if (this.draggingImage == null || !this.isVisible() || this.location == null) {
            return;
        }
        if (SwingUtil.getBoolean("drag.icon.transparency.enabled", true)) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.draggingImage != null) {
            x = (int)(this.location.getX() - (double)this.width / 2.0);
            y = (int)(this.location.getY() - (double)this.height / 2.0);
        } else {
            x = (int)this.location.getX();
            y = (int)this.location.getY();
        }
        if (this.visibleRect != null) {
            g2.setClip(new Area(this.visibleRect));
        }
        g2.drawImage(this.draggingImage, x, y, this.width, this.height, null);
    }

    public void componentAdded(ContainerEvent e) {
        this.setVisible(true);
    }

    public void componentRemoved(ContainerEvent e) {
        if (this.getComponentCount() == 0) {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean aFlag) {
        if (!aFlag) {
            if (this.getComponentCount() == 0) {
                super.setVisible(aFlag);
                this.unmount();
            }
        } else {
            this.mount();
            super.setVisible(aFlag);
        }
    }

    public void setDraggingImage(Image draggingImage) {
        this.setDraggingImage(draggingImage, draggingImage == null ? 0 : draggingImage.getWidth(this));
    }

    public void setDraggingImage(Image draggingImage, int width) {
        if (draggingImage != null) {
            float ratio = (float)draggingImage.getWidth(this) / (float)draggingImage.getHeight(this);
            this.width = width;
            this.height = (int)((float)width / ratio);
        }
        this.draggingImage = draggingImage;
    }

    public Image getDraggingImage() {
        return this.draggingImage;
    }

    public void setPoint(Point location) {
        this.oldLocation = this.location;
        this.location = location;
    }

    public Rectangle getRepaintRect() {
        if (this.location == null || this.oldLocation == null) {
            return this.getBounds();
        }
        int x = (int)(this.location.getX() - (double)this.width / 2.0);
        int y = (int)(this.location.getY() - (double)this.height / 2.0);
        int x2 = (int)(this.oldLocation.getX() - (double)this.width / 2.0);
        int y2 = (int)(this.oldLocation.getY() - (double)this.height / 2.0);
        int width = this.width;
        int height = this.height;
        return new Rectangle(x, y, width, height).union(new Rectangle(x2, y2, width, height));
    }

    public GlassPanel mount() {
        if (this.rootPaneContainer.getGlassPane() == this) {
            return this;
        }
        this.oldGlassPanel = this.rootPaneContainer.getGlassPane();
        this.rootPaneContainer.setGlassPane(this);
        return this;
    }

    public void unmount() {
        if (this.oldGlassPanel != null) {
            this.rootPaneContainer.setGlassPane(this.oldGlassPanel);
        }
    }

    public void reset() {
        this.rootPaneContainer = null;
    }
}

