/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerListener;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockableManagerListener;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.event.ContentManagerEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyContent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.util.DockableManager2ContentManagerWrapper;

public class MyDoggyContentManager
extends PropertyChangeEventSource
implements ContentManager {
    protected MyDoggyToolWindowManager toolWindowManager;
    protected List<Content> contents;
    protected Map<Object, Content> contentMap;
    protected Map<Object, Content> aliases;
    protected PlafContentManagerUI plafContentManagerUI;
    protected EventListenerList listeners;
    protected boolean enabled;

    public MyDoggyContentManager(MyDoggyToolWindowManager windowManager) {
        super(windowManager.getFirePublicEvent());
        this.toolWindowManager = windowManager;
        this.contents = new ArrayList<Content>();
        this.contentMap = new HashMap<Object, Content>();
        this.aliases = new HashMap<Object, Content>();
        this.listeners = new EventListenerList();
        this.enabled = true;
    }

    public Content[] getDockables() {
        return this.getContents();
    }

    public Content getDockableById(String id) {
        return this.getContent(id);
    }

    public void addAlias(Content content, Object alias) {
        if (this.contentMap.containsKey(alias)) {
            throw new IllegalArgumentException("There is a content whose id is the passed alias. Cannot add that alias.");
        }
        this.aliases.put(alias, content);
    }

    public Object[] getAliases(Content content) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, Content> entry : this.aliases.entrySet()) {
            if (entry.getValue() != content) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    public Content removeAlias(Object alias) {
        return this.aliases.remove(alias);
    }

    public ToolWindowManager getToolWindowManager() {
        return this.toolWindowManager;
    }

    public void setContentManagerUI(ContentManagerUI contentManagerUI) {
        if (!(contentManagerUI instanceof PlafContentManagerUI)) {
            throw new IllegalArgumentException("ContentManagerUI type not supported. See Plaf prescription.");
        }
        if (this.plafContentManagerUI == contentManagerUI) {
            return;
        }
        if (this.plafContentManagerUI != null) {
            this.plafContentManagerUI.uninstall();
        }
        PlafContentManagerUI newContentManagerUI = (PlafContentManagerUI)((Object)contentManagerUI);
        PlafContentManagerUI old = this.plafContentManagerUI;
        this.plafContentManagerUI = newContentManagerUI;
        newContentManagerUI.install((ContentManagerUI)((Object)old), this.toolWindowManager);
    }

    public ContentManagerUI getContentManagerUI() {
        return (ContentManagerUI)((Object)this.plafContentManagerUI);
    }

    public int getContentCount() {
        return this.contents.size();
    }

    public Content addContent(String id, String title, Icon icon, Component component) {
        return this.addContent(id, title, icon, component, null);
    }

    public Content addContent(String id, String title, Icon icon, Component component, String tip) {
        return this.addContentInternal(id, title, icon, component, tip, null, new Object[0]);
    }

    public Content addContent(String id, String title, Icon icon, Component component, String tip, Object ... constraints) {
        return this.addContentInternal(id, title, icon, component, tip, null, constraints);
    }

    public Content addContent(Dockable dockable) {
        if (dockable instanceof ToolWindow) {
            this.toolWindowManager.removeIfDockableDelegator(dockable);
            ((MyDoggyToolWindow)dockable).setTypeInternal(ToolWindowType.EXTERN);
            return this.addContentInternal(dockable.getId(), dockable.getTitle(), dockable.getIcon(), dockable.getComponent(), null, (ToolWindow)dockable, new Object[0]);
        }
        throw new IllegalArgumentException("Dockable not yet supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean removeContent(Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null.");
        }
        content.setFlashing(false);
        content.setMaximized(false);
        content.setSelected(false);
        this.plafContentManagerUI.removeContent((MyDoggyContent)content);
        boolean result = this.contents.remove(content);
        if (result) {
            Object v0;
            Dockable delegator;
            this.contentMap.remove(content.getId());
            this.plafContentManagerUI.selectNextContent(content);
            if (content.getDockableDelegator() != null && (delegator = content.getDockableDelegator()) instanceof ToolWindow) {
                ToolWindow toolWindow = (ToolWindow)delegator;
                toolWindow.setType(ToolWindowType.DOCKED);
            }
            Object var6_5 = null;
            try {
                Iterator<Content> iterator = this.aliases.values().iterator();
                while (iterator.hasNext()) {
                    Content aliasedContent = iterator.next();
                    if (aliasedContent != content) continue;
                    iterator.remove();
                }
                this.fireContentRemoved(content);
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var10_13 = v0;
            ((MyDoggyContent)content).cleanup();
            {
            }
            catch (Throwable throwable) {
                Object v1;
                Object var6_6 = null;
                try {
                    Iterator<Content> iterator = this.aliases.values().iterator();
                    while (iterator.hasNext()) {
                        Content aliasedContent = iterator.next();
                        if (aliasedContent != content) continue;
                        iterator.remove();
                    }
                    this.fireContentRemoved(content);
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var10_14 = v1;
                ((MyDoggyContent)content).cleanup();
                throw throwable;
            }
        }
        return result;
    }

    public boolean removeContent(int index) {
        Content content = this.contents.get(index);
        return this.removeContent(content);
    }

    public void removeAllContents() {
        int size = this.getContentCount();
        for (int i = 0; i < size; ++i) {
            this.removeContent(0);
        }
    }

    public Content getContent(int index) {
        return this.contents.get(index);
    }

    public Content getContent(Object key) {
        Content content = this.contentMap.get(key);
        if (content == null) {
            content = this.aliases.get(key);
        }
        return content;
    }

    public Content getContentByComponent(Component component) {
        for (Content content : this.contents) {
            if (content.getComponent() != component) continue;
            return content;
        }
        throw new IllegalArgumentException("Cannot found content for component. [component : " + component + ']');
    }

    public Content getSelectedContent() {
        for (Content content : this.contents) {
            if (!content.isSelected()) continue;
            return content;
        }
        return null;
    }

    public Content getNextContent() {
        int index;
        if (this.contents.size() == 0) {
            return null;
        }
        if (this.getSelectedContent() == null) {
            return this.contents.get(0);
        }
        int startIndex = index = this.contents.indexOf(this.getSelectedContent()) + 1;
        do {
            Content content;
            if (index >= this.contents.size()) {
                index = 0;
            }
            if (!(content = this.getContent(index)).isEnabled()) continue;
            return content;
        } while (++index != startIndex);
        return null;
    }

    public Content getPreviousContent() {
        int index;
        if (this.contents.size() == 0) {
            return null;
        }
        if (this.getSelectedContent() == null) {
            return this.contents.get(0);
        }
        int startIndex = index = this.contents.indexOf(this.getSelectedContent()) - 1;
        do {
            Content content;
            if (index < 0) {
                index = this.contents.size() - 1;
            }
            if (!(content = this.getContent(index)).isEnabled()) continue;
            return content;
        } while (--index != startIndex);
        return null;
    }

    public Content[] getContents() {
        return this.contents.toArray(new Content[this.contents.size()]);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.plafContentManagerUI.setPopupMenu(popupMenu);
    }

    public JPopupMenu getPopupMenu() {
        if (this.plafContentManagerUI != null) {
            return this.plafContentManagerUI.getPopupMenu();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        boolean old = this.enabled;
        this.enabled = enabled;
        this.firePropertyChangeEvent("enabled", old, enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addContentManagerListener(ContentManagerListener listener) {
        this.listeners.add(ContentManagerListener.class, listener);
    }

    public void removeContentManagerListener(ContentManagerListener listener) {
        this.listeners.remove(ContentManagerListener.class, listener);
    }

    public ContentManagerListener[] getContentManagerListeners() {
        return (ContentManagerListener[])this.listeners.getListeners(ContentManagerListener.class);
    }

    public void addDockableManagerListener(DockableManagerListener listener) {
        this.addContentManagerListener(new DockableManager2ContentManagerWrapper(listener));
    }

    public void removeDockableManagerListener(DockableManagerListener listener) {
        for (ContentManagerListener managerListener : this.getContentManagerListeners()) {
            if (!(managerListener instanceof DockableManager2ContentManagerWrapper) || ((DockableManager2ContentManagerWrapper)managerListener).getListener() != listener) continue;
            this.removeContentManagerListener(managerListener);
        }
    }

    public DockableManagerListener[] getDockableManagerListeners() {
        ArrayList<DockableManagerListener> listeners = new ArrayList<DockableManagerListener>();
        for (ContentManagerListener managerListener : this.getContentManagerListeners()) {
            if (!(managerListener instanceof DockableManager2ContentManagerWrapper)) continue;
            listeners.add(((DockableManager2ContentManagerWrapper)managerListener).getListener());
        }
        return listeners.toArray(new DockableManagerListener[listeners.size()]);
    }

    public void updateUI() {
        for (Content content : this.contents) {
            SwingUtilities.updateComponentTreeUI(content.getComponent());
            if (content.getPopupMenu() == null) continue;
            SwingUtilities.updateComponentTreeUI(content.getPopupMenu());
        }
        if (this.getPopupMenu() != null) {
            SwingUtilities.updateComponentTreeUI(this.getPopupMenu());
        }
        this.plafContentManagerUI.updateUI();
    }

    public PlafContentManagerUI getPlafContentManagerUI() {
        return this.plafContentManagerUI;
    }

    protected Content getMaximizedContent() {
        for (Content content : this.getContents()) {
            if (!content.isMaximized()) continue;
            return content;
        }
        return null;
    }

    protected Content addContentInternal(String id, String title, Icon icon, Component component, String tip, ToolWindow toolWindow, Object ... constraints) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        if (this.toolWindowManager.lookupDockable(id) != null) {
            throw new IllegalArgumentException("Cannot register content with passed id. An already registered dockable exists. [id : " + id + "]");
        }
        MyDoggyContent content = new MyDoggyContent(this, id, title, icon, component, tip, toolWindow);
        content.addPlafPropertyChangeListener("selected", new SelectedContentPropertyChangeListener());
        content.addPlafPropertyChangeListener("maximizedBefore", new MaximizedBeforePropertyChangeListener());
        this.contents.add(content);
        this.contentMap.put(id, content);
        this.plafContentManagerUI.addContent(content, constraints);
        this.fireContentAdded(content);
        return content;
    }

    protected void fireContentAdded(Content content) {
        ContentManagerEvent event = new ContentManagerEvent(this, ContentManagerEvent.ActionId.CONTENT_ADDED, content);
        for (ContentManagerListener listener : (ContentManagerListener[])this.listeners.getListeners(ContentManagerListener.class)) {
            listener.contentAdded(event);
        }
    }

    protected void fireContentRemoved(Content content) {
        ContentManagerEvent event = new ContentManagerEvent(this, ContentManagerEvent.ActionId.CONTENT_REMOVED, content);
        for (ContentManagerListener listener : (ContentManagerListener[])this.listeners.getListeners(ContentManagerListener.class)) {
            listener.contentRemoved(event);
        }
    }

    protected void fireContentSelected(Content content) {
        ContentManagerEvent event = new ContentManagerEvent(this, ContentManagerEvent.ActionId.CONTENT_SELECTED, content);
        for (ContentManagerListener listener : (ContentManagerListener[])this.listeners.getListeners(ContentManagerListener.class)) {
            listener.contentSelected(event);
        }
    }

    protected void fireContentDeselected(Content content) {
        ContentManagerEvent event = new ContentManagerEvent(this, ContentManagerEvent.ActionId.CONTENT_DESELECTED, content);
        for (ContentManagerListener listener : (ContentManagerListener[])this.listeners.getListeners(ContentManagerListener.class)) {
            listener.contentSelected(event);
        }
    }

    public class MaximizedBeforePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() instanceof Content);
            Content source = (Content)evt.getSource();
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                for (Content content : MyDoggyContentManager.this.getContents()) {
                    if (!content.isMaximized() || content == source) continue;
                    content.setMaximized(false);
                    return;
                }
            }
        }
    }

    public class SelectedContentPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() instanceof Content);
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                MyDoggyContentManager.this.fireContentSelected((Content)evt.getSource());
            } else {
                MyDoggyContentManager.this.fireContentDeselected((Content)evt.getSource());
            }
        }
    }
}

