/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.ConfiguredComponentHolder;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigurationComponentRegistry
extends ComponentRegistry
implements ServiceListener,
ConfigurationListener {
    private static final String CONFIGURATION_ADMIN = "org.osgi.service.cm.ConfigurationAdmin";
    private ServiceRegistration m_registration;
    private BundleContext m_bundleContext;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationListener;

    public ConfigurationComponentRegistry(BundleContext context) {
        super(context);
        this.m_bundleContext = context;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Configuration Support Listener");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = context.registerService(new String[]{(class$org$osgi$service$cm$ConfigurationListener == null ? (class$org$osgi$service$cm$ConfigurationListener = ConfigurationComponentRegistry.class$("org.osgi.service.cm.ConfigurationListener")) : class$org$osgi$service$cm$ConfigurationListener).getName()}, (Object)this, props);
        try {
            context.addServiceListener((ServiceListener)this, "(objectclass=org.osgi.service.cm.ConfigurationAdmin)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void dispose() {
        this.m_bundleContext.removeServiceListener((ServiceListener)this);
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHolder createComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        ConfigurationAdmin ca;
        if (metadata.isConfigurationIgnored()) {
            return super.createComponentHolder(activator, metadata);
        }
        ComponentHolder holder = metadata.isFactory() ? new ComponentFactoryImpl(activator, metadata) : new ConfiguredComponentHolder(activator, metadata);
        BundleContext bundleContext = activator.getBundleContext();
        String bundleLocation = bundleContext.getBundle().getLocation();
        String name = metadata.getName();
        ServiceReference caRef = bundleContext.getServiceReference(CONFIGURATION_ADMIN);
        if (caRef != null && (ca = (ConfigurationAdmin)bundleContext.getService(caRef)) != null) {
            try {
                Configuration[] factory = this.findFactoryConfigurations(ca, name);
                if (factory != null) {
                    for (int i = 0; i < factory.length; ++i) {
                        String pid = factory[i].getPid();
                        Dictionary props = this.getConfiguration(ca, pid, bundleLocation);
                        holder.configurationUpdated(pid, props);
                    }
                } else {
                    Configuration singleton = this.findSingletonConfiguration(ca, name);
                    if (singleton != null) {
                        Dictionary props = this.getConfiguration(ca, name, bundleLocation);
                        holder.configurationUpdated(name, props);
                    }
                }
            }
            finally {
                bundleContext.ungetService(caRef);
            }
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            Configuration[] configs = null;
            ServiceReference caRef = event.getServiceReference();
            Object service = this.m_bundleContext.getService(caRef);
            try {
                if (service instanceof ConfigurationAdmin) {
                    configs = this.findConfigurations((ConfigurationAdmin)service, null);
                }
            }
            finally {
                if (service != null) {
                    this.m_bundleContext.ungetService(caRef);
                }
            }
            if (configs != null) {
                for (int i = 0; i < configs.length; ++i) {
                    ConfigurationEvent cfgEvent = new ConfigurationEvent(caRef, 1, configs[i].getFactoryPid(), configs[i].getPid());
                    this.configurationEvent(cfgEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent event) {
        String pid = event.getPid();
        String factoryPid = event.getFactoryPid();
        ComponentHolder cm = factoryPid == null ? this.getComponentHolder(pid) : this.getComponentHolder(factoryPid);
        Activator.log(4, null, "configurationEvent: Handling " + (event.getType() == 2 ? "DELETE" : "UPDATE") + " of Configuration PID=" + pid, null);
        if (cm != null && !cm.getComponentMetadata().isConfigurationIgnored()) {
            switch (event.getType()) {
                case 2: {
                    cm.configurationDeleted(pid);
                    break;
                }
                case 1: {
                    ServiceReference caRef;
                    BundleContext bundleContext;
                    BundleComponentActivator activator = cm.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null || (caRef = bundleContext.getServiceReference(CONFIGURATION_ADMIN)) == null) break;
                    try {
                        ConfigurationAdmin ca = (ConfigurationAdmin)bundleContext.getService(caRef);
                        if (ca == null) break;
                        try {
                            Dictionary dict = this.getConfiguration(ca, pid, bundleContext.getBundle().getLocation());
                            if (dict != null) {
                                cm.configurationUpdated(pid, dict);
                            }
                        }
                        finally {
                            bundleContext.ungetService(caRef);
                        }
                    }
                    catch (IllegalStateException ise) {}
                    break;
                }
                default: {
                    Activator.log(2, null, "Unknown ConfigurationEvent type " + event.getType(), null);
                }
            }
        }
    }

    private Dictionary getConfiguration(ConfigurationAdmin ca, String pid, String bundleLocation) {
        try {
            Configuration cfg = ca.getConfiguration(pid);
            if (bundleLocation.equals(cfg.getBundleLocation()) || Activator.hasCtWorkaround()) {
                return cfg.getProperties();
            }
            Activator.log(1, null, "Cannot use configuration pid=" + pid + " for bundle " + bundleLocation + " because it belongs to bundle " + cfg.getBundleLocation(), null);
        }
        catch (IOException ioe) {
            Activator.log(2, null, "Failed reading configuration for pid=" + pid, ioe);
        }
        return null;
    }

    public Configuration findSingletonConfiguration(ConfigurationAdmin ca, String pid) {
        String filter = "(service.pid=" + pid + ")";
        Configuration[] cfg = this.findConfigurations(ca, filter);
        return cfg == null || cfg.length == 0 ? null : cfg[0];
    }

    public Configuration[] findFactoryConfigurations(ConfigurationAdmin ca, String factoryPid) {
        String filter = "(service.factoryPid=" + factoryPid + ")";
        return this.findConfigurations(ca, filter);
    }

    private Configuration[] findConfigurations(ConfigurationAdmin ca, String filter) {
        try {
            return ca.listConfigurations(filter);
        }
        catch (IOException ioe) {
            Activator.log(2, null, "Problem listing configurations for filter=" + filter, ioe);
        }
        catch (InvalidSyntaxException ise) {
            Activator.log(1, null, "Invalid Configuration selection filter " + filter, ise);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

