/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.CaselessStringKeyHashtable;
import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.util.CaselessStringKey;

class PropertyEnvironment
implements PropertySource {
    Vector pg;
    Vector sources;
    private static final Object PRESENT = new Object();
    CaselessStringKeyHashtable suppressed;
    CaselessStringKeyHashtable sourceForProp;
    private Object op;
    private CaselessStringKeyHashtable propNames;
    private PropertySource defaultPropertySource = null;
    private boolean areDefaultsMapped = true;

    public PropertyEnvironment(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, Object object) {
        this.sources = vector;
        this.pg = vector2 == null ? null : (Vector)vector2.clone();
        this.suppressed = new CaselessStringKeyHashtable();
        if (vector3 != null) {
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                this.suppressed.put(enumeration.nextElement(), PRESENT);
            }
        }
        this.sourceForProp = hashtable == null ? null : new CaselessStringKeyHashtable((Map)hashtable);
        this.op = object;
        this.hashNames();
    }

    public String[] getPropertyNames() {
        this.mapDefaults();
        int n = 0;
        String[] stringArray = new String[this.propNames.size()];
        Enumeration enumeration = this.propNames.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = ((CaselessStringKey)enumeration.nextElement()).getName();
        }
        return stringArray;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        return PropertyUtil.getPropertyNames(stringArray, string);
    }

    public Class getPropertyClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.mapDefaults();
        Object object = this.propNames.get(string);
        Object object2 = null;
        if (object == null) {
            return Image.UndefinedProperty;
        }
        if (object instanceof PropertyGenerator) {
            object2 = ((PropertyGenerator)object).getProperty(string, this.op);
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            PropertySource propertySource = (PropertySource)this.sources.elementAt(n);
            object2 = propertySource.getProperty(string);
        } else if (object instanceof PropertySource) {
            object2 = ((PropertySource)object).getProperty(string);
        }
        return object2;
    }

    public void copyPropertyFromSource(String string, int n) {
        PropertySource propertySource = (PropertySource)this.sources.elementAt(n);
        this.propNames.put(string, (Object)propertySource);
        this.suppressed.remove(string);
    }

    public void suppressProperty(String string) {
        this.suppressed.put(string, PRESENT);
        this.hashNames();
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        if (this.pg == null) {
            this.pg = new Vector();
        }
        this.pg.addElement(propertyGenerator);
        this.removeSuppressedProps(propertyGenerator);
        this.hashNames();
    }

    public void setDefaultPropertySource(PropertySource propertySource) {
        if (propertySource == this.defaultPropertySource) {
            return;
        }
        if (this.defaultPropertySource != null) {
            this.hashNames();
        }
        this.areDefaultsMapped = false;
        this.defaultPropertySource = propertySource;
    }

    private void mapDefaults() {
        if (!this.areDefaultsMapped) {
            String[] stringArray;
            this.areDefaultsMapped = true;
            if (this.defaultPropertySource != null && (stringArray = this.defaultPropertySource.getPropertyNames()) != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    if (this.suppressed.containsKey(stringArray[i]) || (object = this.propNames.get(stringArray[i])) != null && !(object instanceof Integer)) continue;
                    this.propNames.put(stringArray[i], (Object)this.defaultPropertySource);
                }
            }
        }
    }

    private void removeSuppressedProps(PropertyGenerator propertyGenerator) {
        String[] stringArray = propertyGenerator.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.suppressed.remove(stringArray[i]);
        }
    }

    private void hashNames() {
        Object object;
        Object object2;
        this.propNames = new CaselessStringKeyHashtable();
        if (this.sources != null) {
            for (int i = this.sources.size() - 1; i >= 0; --i) {
                String[] stringArray;
                object2 = this.sources.elementAt(i);
                if (!(object2 instanceof PropertySource) || (stringArray = (object = (String[])object2).getPropertyNames()) == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    if (this.suppressed.containsKey(string)) continue;
                    this.propNames.put(string, (Object)new Integer(i));
                }
            }
        }
        if (this.pg != null) {
            object2 = this.pg.iterator();
            while (object2.hasNext()) {
                PropertyGenerator propertyGenerator = (PropertyGenerator)object2.next();
                if (!propertyGenerator.canGenerateProperties(this.op) || (object = propertyGenerator.getPropertyNames()) == null) continue;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    Object object3 = object[i];
                    if (this.suppressed.containsKey((String)object3)) continue;
                    this.propNames.put((String)object3, (Object)propertyGenerator);
                }
            }
        }
        if (this.sourceForProp != null) {
            Enumeration enumeration = this.sourceForProp.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (CaselessStringKey)enumeration.nextElement();
                if (this.suppressed.containsKey((CaselessStringKey)object2)) continue;
                object = (Integer)this.sourceForProp.get((CaselessStringKey)object2);
                PropertySource propertySource = (PropertySource)this.sources.elementAt((Integer)object);
                this.propNames.put((CaselessStringKey)object2, (Object)propertySource);
            }
        }
        this.areDefaultsMapped = false;
    }
}

