/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.osgi.framework.BundleContext;
import org.weasis.launcher.AutoProcessor;
import org.weasis.launcher.Messages;

public class WebStartLoader {
    private static final long serialVersionUID = 2275651212116198327L;
    public static final String LBL_LOADING = Messages.getString("WebStartLoader.load");
    public static final String LBL_DOWNLOADING = Messages.getString("WebStartLoader.download");
    public static final String FRM_TITLE = Messages.getString("WebStartLoader.title");
    public static final String PRG_STRING_FORMAT = Messages.getString("WebStartLoader.end");
    private volatile Window window;
    private JButton cancelButton;
    private JLabel loadingLabel;
    private volatile JProgressBar downloadProgress;

    public void writeLabel(String text) {
        this.loadingLabel.setText(text);
    }

    public void initGUI() {
        this.loadingLabel = new JLabel();
        this.loadingLabel.setFont(new Font("Dialog", 0, 10));
        this.downloadProgress = new JProgressBar();
        Font font = new Font("Dialog", 0, 12);
        this.downloadProgress.setFont(font);
        this.cancelButton = new JButton();
        this.cancelButton.setFont(font);
        this.window = new Window(null);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WebStartLoader.this.closing();
            }
        });
        this.loadingLabel.setText(LBL_LOADING);
        this.loadingLabel.setFocusable(false);
        this.downloadProgress.setFocusable(false);
        this.downloadProgress.setStringPainted(true);
        this.downloadProgress.setString(LBL_LOADING);
        this.cancelButton.setText(Messages.getString("WebStartLoader.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebStartLoader.this.closing();
            }
        });
        JLabel imagePane = new JLabel(FRM_TITLE, new ImageIcon(this.getClass().getResource("/splash.png")), 0);
        imagePane.setFont(new Font("Dialog", 1, 16));
        imagePane.setVerticalTextPosition(1);
        imagePane.setHorizontalTextPosition(0);
        imagePane.setFocusable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        panel.add((Component)imagePane, "Center");
        JPanel panelProgress = new JPanel(new BorderLayout());
        panelProgress.setBackground(Color.WHITE);
        panelProgress.add((Component)this.loadingLabel, "North");
        panelProgress.add((Component)this.downloadProgress, "Center");
        panelProgress.add((Component)this.cancelButton, "East");
        panel.add((Component)panelProgress, "South");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.window.add((Component)panel, "Center");
        this.window.pack();
    }

    public Window getWindow() {
        return this.window;
    }

    public void setMax(final int max) {
        if (this.isClosed()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebStartLoader.this.downloadProgress.setMaximum(max);
            }
        });
    }

    public void setValue(final int val) {
        if (this.isClosed()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebStartLoader.this.downloadProgress.setString(String.format(PRG_STRING_FORMAT, val, WebStartLoader.this.downloadProgress.getMaximum()));
                WebStartLoader.this.downloadProgress.setValue(val);
                WebStartLoader.this.downloadProgress.repaint();
            }
        });
    }

    private void closing() {
        System.exit(0);
    }

    public boolean isClosed() {
        return this.window == null;
    }

    public void open() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (WebStartLoader.this.window == null) {
                        WebStartLoader.this.initGUI();
                    }
                    WebStartLoader.this.displayOnScreen();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebStartLoader.this.window.setVisible(false);
                WebStartLoader.this.window.dispose();
                WebStartLoader.this.window = null;
                WebStartLoader.this.cancelButton = null;
                WebStartLoader.this.downloadProgress = null;
                WebStartLoader.this.loadingLabel = null;
            }
        });
    }

    private void displayOnScreen() {
        try {
            Rectangle bound = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            this.window.setLocation(bound.x + (bound.width - this.window.getWidth()) / 2, bound.y + (bound.height - this.window.getHeight()) / 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.window.setVisible(true);
    }

    public void setFelix(Properties configProps, BundleContext bundleContext) {
        AutoProcessor.process(configProps, bundleContext, this);
    }
}

