/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class ProxyDetector {
    public static final String HTTP_PROXY_HOST_PROPERTY = "http.proxyHost";
    public static final String HTTP_PROXY_PORT_PROPERTY = "http.proxyPort";
    public static final String FTP_PROXY_HOST_PROPERTY = "ftp.proxyHost";
    public static final String FTP_PROXY_PORT_PROPERTY = "ftp.proxyPort";
    public static final String HTTPS_PROXY_HOST_PROPERTY = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT_PROPERTY = "https.proxyPort";
    public static final String SOCKS_PROXY_HOST_PROPERTY = "socksProxyHost";
    public static final String SOCKS_PROXY_PORT_PROPERTY = "socksProxyPort";
    public static final String DEPLOYMENT_PROXY_HTTP_HOST = "deployment.proxy.http.host";
    public static final String DEPLOYMENT_PROXY_HTTP_PORT = "deployment.proxy.http.port";
    public static final String DEPLOYMENT_PROXY_HTTPS_HOST = "deployment.proxy.https.host";
    public static final String DEPLOYMENT_PROXY_HTTPS_PORT = "deployment.proxy.https.port";
    public static final String DEPLOYMENT_PROXY_FTP_HOST = "deployment.proxy.ftp.host";
    public static final String DEPLOYMENT_PROXY_FTP_PORT = "deployment.proxy.ftp.port";
    public static final String DEPLOYMENT_PROXY_SOCKS_HOST = "deployment.proxy.socks.host";
    public static final String DEPLOYMENT_PROXY_SOCKS_PORT = "deployment.proxy.socks.port";
    public static final String DEPLOYMENT_PROXY_BYPASS_LIST = "deployment.proxy.bypass.list";
    public static final String DIRECT_CONNECTION_PROPERTY = "javaplugin.proxy.config.type";
    private static final String PROXY_PROPERTY = "java.net.useSystemProxies";
    private final List<Proxy> proxies = this.initProxies();
    private final Proxy proxyToUse = this.determineProxy();

    private ProxyDetector() {
    }

    public static ProxyDetector getInstance() {
        return ProxyDetectorHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Proxy> initProxies() {
        String valuePropertyBefore = System.getProperty(PROXY_PROPERTY);
        try {
            System.setProperty(PROXY_PROPERTY, "true");
            List<Proxy> list = ProxySelector.getDefault().select(new URI("http://www.google.com"));
            return list;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (valuePropertyBefore != null) {
                System.setProperty(PROXY_PROPERTY, valuePropertyBefore);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean directConnectionAvailable() {
        for (Proxy proxy : this.proxies) {
            if (!Proxy.NO_PROXY.equals(proxy)) continue;
            return true;
        }
        return false;
    }

    public boolean proxyDetected() {
        return this.proxyToUse != null;
    }

    private Proxy determineProxy() {
        if (!this.directConnectionAvailable()) {
            for (Proxy proxy : this.proxies) {
                if (!proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
                return proxy;
            }
        }
        return null;
    }

    public Proxy getHttpProxy() {
        return this.proxyToUse == null ? Proxy.NO_PROXY : this.proxyToUse;
    }

    public String getHostname() {
        SocketAddress socketAddress;
        if (this.proxyToUse != null && (socketAddress = this.proxyToUse.address()) instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            return address.getHostName();
        }
        return null;
    }

    public int getPort() {
        SocketAddress socketAddress;
        if (this.proxyToUse != null && (socketAddress = this.proxyToUse.address()) instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            return address.getPort();
        }
        return -1;
    }

    public static void setProxyFromJavaWebStart() {
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_HTTP_HOST, HTTP_PROXY_HOST_PROPERTY);
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_HTTP_PORT, HTTP_PROXY_PORT_PROPERTY);
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_HTTPS_HOST, HTTPS_PROXY_HOST_PROPERTY);
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_HTTPS_PORT, HTTPS_PROXY_PORT_PROPERTY);
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_FTP_HOST, FTP_PROXY_HOST_PROPERTY);
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_FTP_PORT, FTP_PROXY_PORT_PROPERTY);
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_SOCKS_HOST, SOCKS_PROXY_HOST_PROPERTY);
        ProxyDetector.setProperties(DEPLOYMENT_PROXY_SOCKS_PORT, SOCKS_PROXY_PORT_PROPERTY);
        String nonProxyHosts = System.getProperty(DEPLOYMENT_PROXY_BYPASS_LIST);
        String nonProxyLocal = System.getProperty("deployment.proxy.bypass.local");
        if (nonProxyHosts != null) {
            nonProxyHosts = nonProxyHosts.replace(';', '|');
            if (Boolean.parseBoolean(nonProxyLocal)) {
                nonProxyHosts = nonProxyHosts + "|localhost";
            }
            System.setProperty("http.nonProxyHosts", nonProxyHosts);
        }
    }

    private static void setProperties(String javawsProperties, String javaProperties) {
        String prop = System.getProperty(javawsProperties);
        if (prop != null) {
            System.setProperty(javaProperties, prop);
        }
    }

    private static class ProxyDetectorHolder {
        private static final ProxyDetector INSTANCE = new ProxyDetector();

        private ProxyDetectorHolder() {
        }
    }
}

