/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.media.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.SubsampleAverageDescriptor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.task.CircularProgressBar;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.gui.util.GhostGlassPane;
import org.weasis.core.api.image.util.ImageFiler;
import org.weasis.core.api.image.util.ImageToolkit;
import org.weasis.core.api.media.MimeInspector;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.SeriesImporter;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.util.FileUtil;
import org.weasis.core.api.util.FontTools;

public class Thumbnail<E>
extends JLabel
implements MouseListener,
DragGestureListener,
DragSourceListener,
DragSourceMotionListener,
FocusListener {
    public static final RenderingHints DownScaleQualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    public static final int MIN_SIZE = 48;
    public static final int DEFAULT_SIZE = 112;
    public static final int MAX_SIZE = 256;
    protected SoftReference<BufferedImage> imageSoftRef;
    protected boolean readable = true;
    private File thumbnailPath = null;
    private int thumbnailSize;
    private MediaSeries.MEDIA_POSITION mediaPosition = MediaSeries.MEDIA_POSITION.MIDDLE;
    private final Border onMouseOverBorder = new CompoundBorder(new EmptyBorder(2, 2, 0, 2), new LineBorder(Color.orange, 2));
    private final Border outMouseOverBorder = new EmptyBorder(4, 4, 2, 4);
    private JProgressBar progressBar;
    private final MediaSeries<E> series;
    private Point dragPressed = null;
    private DragSource dragSource = null;

    public Thumbnail(MediaSeries<E> sequence, int thumbnailSize) {
        this(sequence, null, thumbnailSize);
    }

    public Thumbnail(MediaSeries<E> sequence, File thumbnailPath, int thumbnailSize) {
        super(null, null, 0);
        if (sequence == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        this.thumbnailSize = thumbnailSize;
        this.series = sequence;
        this.thumbnailPath = thumbnailPath;
        this.init();
    }

    private void init() {
        this.setFont(FontTools.getFont10());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.buildThumbnail();
        this.setBorder(this.outMouseOverBorder);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.removeMouseListener(this);
        this.progressBar = progressBar;
        if (progressBar != null) {
            this.addMouseListener(this);
        }
    }

    public void registerListeners() {
        if (this.dragSource != null) {
            this.dragSource.removeDragSourceListener(this);
            this.dragSource.removeDragSourceMotionListener(this);
            this.removeFocusListener(this);
        }
        this.addFocusListener(this);
        this.setFocusable(true);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.dragSource.addDragSourceMotionListener(this);
    }

    public synchronized void reBuildThumbnail(MediaSeries.MEDIA_POSITION position) {
        this.mediaPosition = position;
        File old = this.thumbnailPath;
        this.thumbnailPath = null;
        this.readable = true;
        this.buildThumbnail();
        if (old != null) {
            old.delete();
        }
    }

    public synchronized void reBuildThumbnail() {
        File old = this.thumbnailPath;
        this.thumbnailPath = null;
        this.readable = true;
        this.buildThumbnail();
        if (old != null) {
            old.delete();
        }
    }

    private synchronized void buildThumbnail() {
        this.imageSoftRef = null;
        Icon icon = MimeInspector.unknownIcon;
        String type = Messages.getString("Thumbnail.unknown");
        E media = this.series.getMedia(this.mediaPosition);
        if (media instanceof MediaElement) {
            MediaElement m = (MediaElement)media;
            String mime = m.getMimeType();
            if (mime.startsWith("image")) {
                type = Messages.getString("Thumbnail.img");
                icon = MimeInspector.imageIcon;
            } else if (mime.startsWith("video")) {
                type = Messages.getString("Thumbnail.video");
                icon = MimeInspector.videoIcon;
            } else if (mime.startsWith("audio")) {
                type = Messages.getString("Thumbnail.audio");
                icon = MimeInspector.audioIcon;
            } else if (mime.startsWith("txt")) {
                type = Messages.getString("Thumbnail.text");
                icon = MimeInspector.textIcon;
            } else if (mime.endsWith("html")) {
                type = Messages.getString("Thumbnail.html");
                icon = MimeInspector.htmlIcon;
            } else if (mime.equals("application/pdf")) {
                type = Messages.getString("Thumbnail.pdf");
                icon = MimeInspector.pdfIcon;
            } else {
                type = mime;
            }
        }
        this.setIcon(icon, type);
    }

    public synchronized int getThumbnailSize() {
        return this.thumbnailSize;
    }

    public synchronized void setThumbnailSize(int thumbnailSize) {
        boolean update;
        boolean bl = update = this.thumbnailSize != thumbnailSize;
        if (update) {
            this.thumbnailSize = thumbnailSize;
            this.buildThumbnail();
        }
    }

    private void setIcon(final Icon mime, final String type) {
        this.setSize(this.thumbnailSize, this.thumbnailSize);
        ImageIcon icon = new ImageIcon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                int width = Thumbnail.this.thumbnailSize;
                int height = Thumbnail.this.thumbnailSize;
                BufferedImage thumbnail = Thumbnail.this.getImage();
                if (thumbnail == null) {
                    FontMetrics fontMetrics = g2d.getFontMetrics();
                    int fheight = y + (Thumbnail.this.thumbnailSize - fontMetrics.getAscent() + 5 - mime.getIconHeight()) / 2;
                    mime.paintIcon(c, g2d, x + (Thumbnail.this.thumbnailSize - mime.getIconWidth()) / 2, fheight);
                    int startx = x + (Thumbnail.this.thumbnailSize - fontMetrics.stringWidth(type)) / 2;
                    g2d.drawString(type, startx, fheight + mime.getIconHeight() + fontMetrics.getAscent() + 5);
                } else {
                    width = thumbnail.getWidth();
                    height = thumbnail.getHeight();
                    g2d.drawImage(thumbnail, AffineTransform.getTranslateInstance(x += (Thumbnail.this.thumbnailSize - width) / 2, y += (Thumbnail.this.thumbnailSize - height) / 2), null);
                }
                super.paintIcon(c, g2d, x, y);
                Thumbnail.this.paintSeriesState(g2d, x, y, width, height);
            }

            @Override
            public int getIconWidth() {
                return Thumbnail.this.thumbnailSize;
            }

            @Override
            public int getIconHeight() {
                return Thumbnail.this.thumbnailSize;
            }
        };
        this.setIcon(icon);
    }

    private PlanarImage loadImage(File path) throws Exception {
        FileImageInputStream in = new FileImageInputStream(new RandomAccessFile(path, "r"));
        ParameterBlockJAI pb = new ParameterBlockJAI("ImageRead");
        pb.setParameter("Input", (Object)in);
        return JAI.create((String)"ImageRead", (ParameterBlock)pb, null);
    }

    public synchronized BufferedImage getImage() {
        if (this.imageSoftRef == null && this.readable || this.imageSoftRef != null && this.imageSoftRef.get() == null) {
            this.readable = false;
            BufferedImage thumb = null;
            if (this.thumbnailPath == null || !this.thumbnailPath.canRead()) {
                ImageElement image;
                PlanarImage imgPl;
                E media = this.series.getMedia(this.mediaPosition);
                if (media instanceof ImageElement && (imgPl = (image = (ImageElement)media).getImage()) != null) {
                    RenderedImage img = ImageToolkit.getDefaultRenderedImage(image, (RenderedImage)imgPl);
                    double scale = Math.min(256.0 / (double)img.getHeight(), 256.0 / (double)img.getWidth());
                    final PlanarImage t = scale < 1.0 ? SubsampleAverageDescriptor.create((RenderedImage)img, (Double)scale, (Double)scale, (RenderingHints)DownScaleQualityHints).getRendering() : PlanarImage.wrapRenderedImage((RenderedImage)img);
                    try {
                        this.thumbnailPath = File.createTempFile("tumb_", ".jpg", AbstractProperties.APP_TEMP_DIR);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (this.thumbnailPath != null) {
                        ImageElement.IMAGE_LOADER.submit(new Runnable(){

                            @Override
                            public void run() {
                                if (ImageFiler.writeJPG(Thumbnail.this.thumbnailPath, t, 0.75f)) {
                                    Thumbnail.this.readable = true;
                                    Thumbnail.this.repaint(100L);
                                }
                            }
                        });
                        return null;
                    }
                    thumb = t.getAsBufferedImage();
                }
            } else {
                Load ref = new Load(this.thumbnailPath);
                Future<BufferedImage> future = ImageElement.IMAGE_LOADER.submit(ref);
                BufferedImage img = null;
                try {
                    img = future.get();
                    int width = img.getWidth();
                    int height = img.getHeight();
                    if (width > this.thumbnailSize || height > this.thumbnailSize) {
                        double scale = Math.min((double)this.thumbnailSize / (double)height, (double)this.thumbnailSize / (double)width);
                        PlanarImage t = scale < 1.0 ? SubsampleAverageDescriptor.create((RenderedImage)img, (Double)scale, (Double)scale, (RenderingHints)DownScaleQualityHints) : PlanarImage.wrapRenderedImage((RenderedImage)img);
                        thumb = t.getAsBufferedImage();
                        t.dispose();
                    } else {
                        thumb = img;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    future.cancel(true);
                }
                catch (ExecutionException e) {
                    System.err.println("Error: Cannot read pixel data!:" + this.thumbnailPath);
                    e.printStackTrace();
                }
            }
            if (thumb == null && (this.thumbnailPath != null || this.series.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE) != null)) {
                this.readable = false;
            } else {
                this.readable = true;
                this.imageSoftRef = new SoftReference<Object>(thumb);
            }
        }
        if (this.imageSoftRef == null) {
            return null;
        }
        return this.imageSoftRef.get();
    }

    public void dispose() {
        BufferedImage temp;
        if (this.imageSoftRef != null && (temp = this.imageSoftRef.get()) != null) {
            temp.flush();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Component comp = dge.getComponent();
        try {
            GhostGlassPane glassPane = AbstractProperties.glassPane;
            glassPane.setIcon(this.getIcon());
            Point p = (Point)dge.getDragOrigin().clone();
            this.dragPressed = new Point(p.x - 4, p.y - 4);
            SwingUtilities.convertPointToScreen(p, comp);
            this.drawGlassPane(p);
            glassPane.setVisible(true);
            dge.startDrag(null, this.series, this);
            return;
        }
        catch (RuntimeException runtimeException) {
            return;
        }
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dsde) {
        this.drawGlassPane(dsde.getLocation());
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        GhostGlassPane glassPane = AbstractProperties.glassPane;
        this.dragPressed = null;
        glassPane.setImagePosition(null);
        glassPane.setIcon(null);
        glassPane.setVisible(false);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void drawGlassPane(Point p) {
        if (this.dragPressed != null) {
            GhostGlassPane glassPane = AbstractProperties.glassPane;
            SwingUtilities.convertPointFromScreen(p, glassPane);
            p.translate(-this.dragPressed.x, -this.dragPressed.y);
            glassPane.setImagePosition(p);
        }
    }

    public MediaSeries<E> getSeries() {
        return this.series;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            SeriesImporter loader;
            this.setBorder(this.onMouseOverBorder);
            JPanel container = this.getScrollPane();
            if (container != null) {
                Rectangle bound = this.getBounds();
                Point p1 = SwingUtilities.convertPoint(this, this.getX(), this.getY(), container);
                bound.x = p1.x;
                bound.y = p1.y;
                container.scrollRectToVisible(bound);
            }
            if ((loader = this.series.getSeriesLoader()) != null) {
                loader.setPriority();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.setBorder(this.outMouseOverBorder);
        }
    }

    private JPanel getScrollPane() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container.getParent() instanceof JViewport)) continue;
            return (JPanel)container;
        }
        return null;
    }

    @Override
    public String getToolTipText() {
        return this.series.getToolTips();
    }

    public void paintSeriesState(Graphics2D g2d, int x, int y, int width, int height) {
        if (this.series.isOpen()) {
            g2d.setPaint(Color.green);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fillArc(x + 2, y + 2, 7, 7, 0, 360);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        g2d.setPaint(Color.ORANGE);
        if (this.series.isSelected()) {
            g2d.drawRect(x + 12, y + 3, 5, 5);
        }
        Integer splitNb = (Integer)this.series.getTagValue(TagW.SplitSeriesNumber);
        g2d.setFont(FontTools.getFont10());
        int hbleft = y + height - 2;
        if (splitNb != null) {
            g2d.drawString("#" + splitNb + " [" + this.series.getMedias().size() + "]", x + 2, hbleft);
        } else {
            g2d.drawString("[" + this.series.getMedias().size() + "]", x + 2, hbleft);
        }
        JProgressBar bar = this.progressBar;
        if (bar != null) {
            if (this.series.getFileSize() > 0.0) {
                g2d.drawString(FileUtil.formatSize(this.series.getFileSize()), x + 2, hbleft - 12);
            }
            g2d.translate(width - bar.getWidth() + x - 2, height - bar.getHeight() + y - 2);
            bar.paint(g2d);
        }
    }

    public void removeMouseAndKeyListener() {
        int i;
        MouseListener[] listener = this.getMouseListeners();
        MouseMotionListener[] motionListeners = this.getMouseMotionListeners();
        KeyListener[] keyListeners = this.getKeyListeners();
        MouseWheelListener[] wheelListeners = this.getMouseWheelListeners();
        for (i = 0; i < listener.length; ++i) {
            this.removeMouseListener(listener[i]);
        }
        for (i = 0; i < motionListeners.length; ++i) {
            this.removeMouseMotionListener(motionListeners[i]);
        }
        for (i = 0; i < keyListeners.length; ++i) {
            this.removeKeyListener(keyListeners[i]);
        }
        for (i = 0; i < wheelListeners.length; ++i) {
            this.removeMouseWheelListener(wheelListeners[i]);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.progressBar instanceof JProgressBar) {
            SeriesImporter loader;
            CircularProgressBar cricleBar = (CircularProgressBar)this.progressBar;
            Rectangle rect = cricleBar.getBounds();
            rect.x = this.thumbnailSize - rect.width - 2;
            rect.y = this.thumbnailSize - rect.height - 2;
            if (rect.contains(e.getPoint()) && (loader = this.series.getSeriesLoader()) != null) {
                if (loader.isStopped()) {
                    loader.resume();
                } else {
                    loader.stop();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        DownScaleQualityHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
    }

    class Load
    implements Callable<BufferedImage> {
        private final File path;

        public Load(File path) {
            this.path = path;
        }

        @Override
        public BufferedImage call() throws Exception {
            return ImageIO.read(this.path);
        }
    }
}

