/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.media.data;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.weasis.core.api.Messages;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.TagW;

public class MediaSeriesGroupNode
implements MediaSeriesGroup {
    private final TagW tagID;
    private final TagW displayTag;
    private final HashMap<TagW, Object> tags;
    private Comparator<TagW> comparator;

    public MediaSeriesGroupNode(TagW tagID, Object identifier) {
        this(tagID, identifier, null);
    }

    public MediaSeriesGroupNode(TagW tagID, Object identifier, TagW displayTag) {
        if (tagID == null || identifier == null) {
            throw new IllegalArgumentException("tagID or identifier cannot be null");
        }
        this.displayTag = displayTag == null ? tagID : displayTag;
        this.tags = new HashMap();
        this.tagID = tagID;
        this.tags.put(tagID, identifier);
    }

    @Override
    public TagW getTagID() {
        return this.tagID;
    }

    @Override
    public boolean containTagKey(TagW tag) {
        return this.tags.containsKey(tag);
    }

    public String toString() {
        Object val = this.tags.get(this.displayTag);
        if (val instanceof Date) {
            val = new SimpleDateFormat("dd/MM/yyyy").format(val);
        }
        return val == null ? Messages.getString("MediaSeriesGroupNode.no_val") + this.displayTag.getName() : val.toString();
    }

    @Override
    public boolean equals(Object obj) {
        Object value1 = this.tags.get(this.tagID);
        if (value1 == obj) {
            return true;
        }
        if (value1 == null) {
            return false;
        }
        if (obj instanceof MediaSeriesGroupNode) {
            Object value2 = ((MediaSeriesGroupNode)obj).tags.get(this.tagID);
            return value1.equals(value2);
        }
        return value1.equals(obj);
    }

    public int hashCode() {
        Object val = this.tags.get(this.tagID);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val == null) {
            return this.hashCode();
        }
        return val.hashCode();
    }

    @Override
    public void setTag(TagW tag, Object value) {
        if (tag != null) {
            this.tags.put(tag, value);
        }
    }

    @Override
    public void setTagNoNull(TagW tag, Object value) {
        if (tag != null && value != null) {
            this.tags.put(tag, value);
        }
    }

    @Override
    public Object getTagValue(TagW tag) {
        return this.tags.get(tag);
    }

    @Override
    public TagW getTagElement(int id) {
        for (TagW e : this.tags.keySet()) {
            if (e.getId() != id) continue;
            return e;
        }
        return null;
    }

    public Iterator<Map.Entry<TagW, Object>> getTagEntrySetIterator() {
        return this.tags.entrySet().iterator();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Comparator<TagW> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<TagW> comparator) {
        this.comparator = comparator;
    }
}

