/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.util;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;

public class Statistics {
    private int[] x;
    private int[] y;
    private double mx = 0.0;
    private double my = 0.0;
    private double u20 = 0.0;
    private double u02 = 0.0;
    private double u11 = 0.0;

    public Statistics(ArrayList<Point> arrayList) {
        int i;
        this.x = new int[arrayList.size()];
        this.y = new int[arrayList.size()];
        for (i = 0; i < arrayList.size(); ++i) {
            Point p = arrayList.get(i);
            this.x[i] = p.x;
            this.y[i] = p.y;
        }
        this.mx = Statistics.mean(this.x);
        this.my = Statistics.mean(this.y);
        if (this.x.length < 2) {
            return;
        }
        for (i = 0; i < this.x.length; ++i) {
            this.u11 += ((double)this.x[i] - this.mx) * ((double)this.y[i] - this.my);
            this.u20 += ((double)this.x[i] - this.mx) * ((double)this.x[i] - this.mx);
            this.u02 += ((double)this.y[i] - this.my) * ((double)this.y[i] - this.my);
        }
    }

    public static double CorrCoef(double[] xVal, double[] yVal, double xyStDev, double xMean, double yMean) {
        double r = 0.0;
        for (int i = 0; i < xVal.length; ++i) {
            r += (xVal[i] - xMean) * (yVal[i] - yMean) / xyStDev;
        }
        return r /= (double)xVal.length;
    }

    public static double CorrCoef(double[] xVal, double[] yVal) {
        double r = 0.0;
        double mX = Statistics.mean(xVal);
        double mY = Statistics.mean(yVal);
        double sdX = Statistics.stDev(xVal, mX);
        double sdY = Statistics.stDev(yVal, mY);
        for (int i = 0; i < xVal.length; ++i) {
            r += (xVal[i] - mX) * (yVal[i] - mY) / (sdX * sdY);
        }
        return r /= (double)(xVal.length - 1);
    }

    public static double stDev(int[] data) {
        double sHat;
        if (data == null || data.length == 0) {
            sHat = Double.NaN;
        } else {
            double mu = Statistics.mean(data);
            sHat = 0.0;
            for (int i = 0; i < data.length; ++i) {
                sHat += ((double)data[i] - mu) * ((double)data[i] - mu);
            }
            sHat = Math.sqrt(sHat / ((double)data.length - 1.0));
        }
        return sHat;
    }

    public static double stDev(double[] data) {
        double sHat;
        if (data == null || data.length == 0) {
            sHat = Double.NaN;
        } else {
            double mu = Statistics.mean(data);
            sHat = 0.0;
            for (int i = 0; i < data.length; ++i) {
                sHat += (data[i] - mu) * (data[i] - mu);
            }
            sHat = Math.sqrt(sHat / ((double)data.length - 1.0));
        }
        return sHat;
    }

    public static double stDev(double[] data, double mu) {
        double sHat;
        if (data == null || data.length == 0) {
            sHat = Double.NaN;
        } else {
            sHat = 0.0;
            for (int i = 0; i < data.length; ++i) {
                sHat += (data[i] - mu) * (data[i] - mu);
            }
            sHat = Math.sqrt(sHat / ((double)data.length - 1.0));
        }
        return sHat;
    }

    public static double stDev(int[] data, double mu) {
        double sHat;
        if (data == null || data.length == 0) {
            sHat = Double.NaN;
        } else {
            sHat = 0.0;
            for (int i = 0; i < data.length; ++i) {
                sHat += ((double)data[i] - mu) * ((double)data[i] - mu);
            }
            sHat = Math.sqrt(sHat / ((double)data.length - 1.0));
        }
        return sHat;
    }

    public static double mean(double[] data) {
        double mu;
        if (data == null || data.length == 0) {
            mu = Double.NaN;
        } else {
            mu = 0.0;
            for (int i = 0; i < data.length; ++i) {
                mu += data[i];
            }
            mu /= (double)data.length;
        }
        return mu;
    }

    public static double mean(int[] data) {
        if (data == null || data.length < 1) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += (double)data[i];
        }
        return sum / (double)data.length;
    }

    public static double[] normalizeData(double[] data) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double[] out = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        double range = max - min;
        for (int i = 0; i < out.length; ++i) {
            out[i] = (data[i] - min) / range;
        }
        return out;
    }

    public static double median(double[] data) {
        double median = 0.0;
        if (data == null || data.length < 1) {
            return 0.0;
        }
        double[] out = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            out[i] = data[i];
        }
        Arrays.sort(out);
        median = out.length % 2 == 0 ? (out[out.length / 2 - 1] + out[out.length / 2]) / 2.0 : out[out.length / 2];
        return median;
    }

    public static double median(int[] data) {
        double median = 0.0;
        if (data == null || data.length < 1) {
            return 0.0;
        }
        int[] out = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            out[i] = data[i];
        }
        Arrays.sort(out);
        median = out.length % 2 == 0 ? (double)(out[out.length / 2 - 1] + out[out.length / 2]) / 2.0 : (double)out[out.length / 2];
        return median;
    }

    public static double skewness(double[] data) {
        if (data == null || data.length < 2) {
            return 0.0;
        }
        double m3 = Statistics.moment(data, 3);
        double sm2 = Math.sqrt(Statistics.moment(data, 2));
        return m3 / Math.pow(sm2, 3.0);
    }

    public static double kurtosis(double[] data) {
        if (data == null || data.length < 2) {
            return 0.0;
        }
        double m4 = Statistics.moment(data, 4);
        double sm2 = Math.sqrt(Statistics.moment(data, 2));
        return m4 / Math.pow(sm2, 4.0);
    }

    private static double moment(double[] x, int order) {
        if (x == null || order == 1) {
            return 0.0;
        }
        double mu = Statistics.mean(x);
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.pow(x[i] - mu, order);
        }
        return sum / (double)x.length;
    }

    public double orientationInRadian() {
        return 0.5 * Math.atan2(2.0 * this.u11, this.u20 - this.u02);
    }

    public double eccentricity() {
        double sum = (this.u20 + this.u02 + Math.sqrt((this.u20 - this.u02) * (this.u20 - this.u02) + 4.0 * this.u11 * this.u11)) / (this.u20 + this.u02 - Math.sqrt((this.u20 - this.u02) * (this.u20 - this.u02) + 4.0 * this.u11 * this.u11));
        return sum;
    }

    public double getBarycenterX() {
        return this.mx;
    }

    public double getBarycentery() {
        return this.my;
    }

    public void dispose() {
        this.x = null;
        this.y = null;
    }

    public static final double[] averageSmooth(double[] img, int rad) {
        int h = img.length;
        double[] result = new double[h];
        for (int i = 0; i < h; ++i) {
            int by = i - rad;
            int ey = i + rad;
            if (by < 0) {
                by = 0;
            }
            if (ey >= h) {
                ey = h - 1;
            }
            double tmp = 0.0;
            int k = 0;
            int y = by;
            while (y <= ey) {
                tmp += img[y];
                ++y;
                ++k;
            }
            result[i] = tmp / (double)k;
        }
        return result;
    }

    public static double[] regression(double[] x, double[] y, int norder) {
        double[][] a = new double[norder + 1][norder + 1];
        double[] b = new double[norder + 1];
        double[] term = new double[norder + 1];
        double ysquare = 0.0;
        for (int i = 0; i < y.length; ++i) {
            b[0] = b[0] + y[i];
            ysquare += y[i] * y[i];
            double xpower = 1.0;
            int j = 0;
            while (j < norder + 1) {
                term[j] = xpower;
                double[] dArray = a[0];
                int n = j++;
                dArray[n] = dArray[n] + xpower;
                xpower *= x[i];
            }
            for (j = 1; j < norder + 1; ++j) {
                int n = j;
                b[n] = b[n] + y[i] * term[j];
                for (int k = 0; k < b.length; ++k) {
                    double[] dArray = a[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + term[j] * term[k];
                }
            }
        }
        double[] coef = Statistics.gauss(a, b);
        double ss = 0.0;
        double yaverage = b[0] / (double)y.length;
        for (int i = 0; i < norder + 1; ++i) {
            double xaverage = a[0][i] / (double)y.length;
            ss += coef[i] * (b[i] - (double)y.length * xaverage * yaverage);
        }
        double rsquared = ss / (ysquare - (double)y.length * yaverage * yaverage);
        int size = coef.length + 1;
        double[] out = new double[size];
        for (int i = 0; i < coef.length; ++i) {
            out[i] = coef[i];
        }
        out[coef.length] = rsquared;
        return out;
    }

    private static double[] gauss(double[][] ax, double[] bx) {
        int i;
        double[][] a = new double[ax.length][ax[0].length];
        double[] b = new double[bx.length];
        int n = b.length;
        double[] coef = new double[n];
        for (i = 0; i < ax.length; ++i) {
            for (int j = 0; j < ax[i].length; ++j) {
                a[i][j] = ax[i][j];
            }
            b[i] = bx[i];
        }
        for (int j = 0; j < n - 1; ++j) {
            double pivot = a[j][j];
            for (int i2 = j + 1; i2 < n; ++i2) {
                double mult = a[i2][j] / pivot;
                for (int k = j + 1; k < n; ++k) {
                    a[i2][k] = a[i2][k] - mult * a[j][k];
                }
                b[i2] = b[i2] - mult * b[j];
            }
        }
        coef[n - 1] = b[n - 1] / a[n - 1][n - 1];
        for (i = n - 2; i >= 0; --i) {
            double top = b[i];
            for (int k = i + 1; k < n; ++k) {
                top -= a[i][k] * coef[k];
            }
            coef[i] = top / a[i][i];
        }
        return coef;
    }

    public static double[] regression2(double[] x, double[] y) {
        double sumX = x[0];
        double sumXX = 0.0;
        double sumY = y[0];
        double sumYY = 0.0;
        double sumXY = 0.0;
        double xbar = x[0];
        double ybar = y[0];
        for (int i = 1; i < x.length; ++i) {
            double dx = x[i] - xbar;
            double dy = y[i] - ybar;
            sumXX += dx * dx * (double)i / ((double)i + 1.0);
            sumYY += dy * dy * (double)i / ((double)i + 1.0);
            sumXY += dx * dy * (double)i / ((double)i + 1.0);
            xbar += dx / ((double)i + 1.0);
            ybar += dy / ((double)i + 1.0);
            sumX += x[i];
            sumY += y[i];
        }
        double[] val = new double[3];
        val[0] = sumXY / sumXX;
        if (Math.abs(sumXX) < 4.9E-323) {
            val[0] = Double.NaN;
        }
        val[1] = (sumY - val[0] * sumX) / (double)x.length;
        val[2] = Math.sqrt((sumYY - (sumYY - sumXY * sumXY / sumXX)) / sumYY);
        return val;
    }
}

