/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

public class ExtremaRangeLimitOpImage
extends StatisticsOpImage {
    protected double[][] extrema = null;
    protected int[] minCounts;
    protected int[] maxCounts;
    protected double excludedMin;
    protected double excludedMax;
    private boolean isInitialized = false;
    private PixelAccessor srcPA;
    private int srcSampleType;

    private final boolean tileIntersectsROI(int tileX, int tileY) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(tileX), this.tileYToY(tileY), this.tileWidth, this.tileHeight);
    }

    public ExtremaRangeLimitOpImage(RenderedImage source, ROI roi, int xStart, int yStart, int xPeriod, int yPeriod, double excludedMin, double excludedMax) {
        super(source, roi, xStart, yStart, xPeriod, yPeriod);
        this.excludedMin = excludedMin;
        this.excludedMax = excludedMax;
    }

    public Object getProperty(String name) {
        int numBands = this.sampleModel.getNumBands();
        if (this.extrema == null) {
            return super.getProperty(name);
        }
        if (name.equalsIgnoreCase("extrema")) {
            double[][] stats = new double[2][numBands];
            for (int i = 0; i < numBands; ++i) {
                stats[0][i] = this.extrema[0][i];
                stats[1][i] = this.extrema[1][i];
            }
            return stats;
        }
        if (name.equalsIgnoreCase("minimum")) {
            double[] stats = new double[numBands];
            for (int i = 0; i < numBands; ++i) {
                stats[i] = this.extrema[0][i];
            }
            return stats;
        }
        if (name.equalsIgnoreCase("maximum")) {
            double[] stats = new double[numBands];
            for (int i = 0; i < numBands; ++i) {
                stats[i] = this.extrema[1][i];
            }
            return stats;
        }
        return Image.UndefinedProperty;
    }

    protected String[] getStatisticsNames() {
        return new String[]{"extrema", "maximum", "minimum"};
    }

    protected Object createStatistics(String name) {
        int numBands = this.sampleModel.getNumBands();
        Object stats = null;
        stats = name.equalsIgnoreCase("extrema") ? new double[2][numBands] : (name.equalsIgnoreCase("minimum") || name.equalsIgnoreCase("maximum") ? (Object)new double[numBands] : (Object)Image.UndefinedProperty);
        return stats;
    }

    private final int startPosition(int pos, int start, int period) {
        int t = (pos - start) % period;
        return t == 0 ? pos : pos + (period - t);
    }

    protected void accumulateStatistics(String name, Raster source, Object stats) {
        block17: {
            int i;
            block18: {
                block16: {
                    LinkedList rectList;
                    if (!this.isInitialized) {
                        this.srcPA = new PixelAccessor((RenderedImage)this.getSourceImage(0));
                        this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
                        this.isInitialized = true;
                    }
                    Rectangle srcBounds = this.getSourceImage(0).getBounds().intersection(source.getBounds());
                    if (this.roi == null) {
                        rectList = new LinkedList();
                        rectList.addLast(srcBounds);
                    } else {
                        rectList = this.roi.getAsRectangleList(srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height);
                        if (rectList == null) {
                            return;
                        }
                    }
                    ListIterator iterator = rectList.listIterator(0);
                    while (iterator.hasNext()) {
                        Rectangle rect = srcBounds.intersection((Rectangle)iterator.next());
                        int tx = rect.x;
                        int ty = rect.y;
                        rect.x = this.startPosition(tx, this.xStart, this.xPeriod);
                        rect.y = this.startPosition(ty, this.yStart, this.yPeriod);
                        rect.width = tx + rect.width - rect.x;
                        rect.height = ty + rect.height - rect.y;
                        if (rect.isEmpty()) continue;
                        this.initializeState(source);
                        UnpackedImageData uid = this.srcPA.getPixels(source, rect, this.srcSampleType, false);
                        switch (uid.type) {
                            case 0: {
                                this.accumulateStatisticsByte(uid);
                                break;
                            }
                            case 1: {
                                this.accumulateStatisticsUShort(uid);
                                break;
                            }
                            case 2: {
                                this.accumulateStatisticsShort(uid);
                                break;
                            }
                            case 3: {
                                this.accumulateStatisticsInt(uid);
                                break;
                            }
                            case 4: {
                                this.accumulateStatisticsFloat(uid);
                                break;
                            }
                            case 5: {
                                this.accumulateStatisticsDouble(uid);
                            }
                        }
                    }
                    if (!name.equalsIgnoreCase("extrema")) break block16;
                    double[][] ext = (double[][])stats;
                    for (i = 0; i < this.srcPA.numBands; ++i) {
                        ext[0][i] = this.extrema[0][i];
                        ext[1][i] = this.extrema[1][i];
                    }
                    break block17;
                }
                if (!name.equalsIgnoreCase("minimum")) break block18;
                double[] min = (double[])stats;
                for (i = 0; i < this.srcPA.numBands; ++i) {
                    min[i] = this.extrema[0][i];
                }
                break block17;
            }
            if (!name.equalsIgnoreCase("maximum")) break block17;
            double[] max = (double[])stats;
            for (i = 0; i < this.srcPA.numBands; ++i) {
                max[i] = this.extrema[1][i];
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedImageData uid) {
        Rectangle rect = uid.rect;
        byte[][] data = uid.getByteData();
        int lineStride = uid.lineStride;
        int pixelStride = uid.pixelStride;
        int lineInc = lineStride * this.yPeriod;
        int pixelInc = pixelStride * this.xPeriod;
        int exMin = (int)this.excludedMin;
        int exMax = (int)this.excludedMax;
        for (int b = 0; b < this.srcPA.numBands; ++b) {
            int min = (int)this.extrema[0][b];
            int max = (int)this.extrema[1][b];
            byte[] d = data[b];
            int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
            for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineInc) {
                int lastPixel = lo + rect.width * pixelStride;
                for (int po = lo; po < lastPixel; po += pixelInc) {
                    int p = d[po] & 0xFF;
                    if (p < min && (p < exMin || p > exMax)) {
                        min = p;
                    }
                    if (p <= max || p >= exMin && p <= exMax) continue;
                    max = p;
                }
            }
            this.extrema[0][b] = min;
            this.extrema[1][b] = max;
        }
    }

    private void accumulateStatisticsUShort(UnpackedImageData uid) {
        Rectangle rect = uid.rect;
        short[][] data = uid.getShortData();
        int lineStride = uid.lineStride;
        int pixelStride = uid.pixelStride;
        int lineInc = lineStride * this.yPeriod;
        int pixelInc = pixelStride * this.xPeriod;
        int exMin = (int)this.excludedMin;
        int exMax = (int)this.excludedMax;
        for (int b = 0; b < this.srcPA.numBands; ++b) {
            int min = (int)this.extrema[0][b];
            int max = (int)this.extrema[1][b];
            short[] d = data[b];
            int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
            for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineInc) {
                int lastPixel = lo + rect.width * pixelStride;
                for (int po = lo; po < lastPixel; po += pixelInc) {
                    int p = d[po] & 0xFFFF;
                    if (p < min && (p < exMin || p > exMax)) {
                        min = p;
                    }
                    if (p <= max || p >= exMin && p <= exMax) continue;
                    max = p;
                }
            }
            this.extrema[0][b] = min;
            this.extrema[1][b] = max;
        }
    }

    private void accumulateStatisticsShort(UnpackedImageData uid) {
        Rectangle rect = uid.rect;
        short[][] data = uid.getShortData();
        int lineStride = uid.lineStride;
        int pixelStride = uid.pixelStride;
        int lineInc = lineStride * this.yPeriod;
        int pixelInc = pixelStride * this.xPeriod;
        int exMin = (int)this.excludedMin;
        int exMax = (int)this.excludedMax;
        for (int b = 0; b < this.srcPA.numBands; ++b) {
            int min = (int)this.extrema[0][b];
            int max = (int)this.extrema[1][b];
            short[] d = data[b];
            int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
            for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineInc) {
                int lastPixel = lo + rect.width * pixelStride;
                for (int po = lo; po < lastPixel; po += pixelInc) {
                    int p = d[po];
                    if (p < min && (p < exMin || p > exMax)) {
                        min = p;
                    }
                    if (p <= max || p >= exMin && p <= exMax) continue;
                    max = p;
                }
            }
            this.extrema[0][b] = min;
            this.extrema[1][b] = max;
        }
    }

    private void accumulateStatisticsInt(UnpackedImageData uid) {
        Rectangle rect = uid.rect;
        int[][] data = uid.getIntData();
        int lineStride = uid.lineStride;
        int pixelStride = uid.pixelStride;
        int lineInc = lineStride * this.yPeriod;
        int pixelInc = pixelStride * this.xPeriod;
        float exMin = (float)this.excludedMin;
        float exMax = (float)this.excludedMax;
        for (int b = 0; b < this.srcPA.numBands; ++b) {
            int min = (int)this.extrema[0][b];
            int max = (int)this.extrema[1][b];
            int[] d = data[b];
            int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
            for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineInc) {
                int lastPixel = lo + rect.width * pixelStride;
                for (int po = lo; po < lastPixel; po += pixelInc) {
                    int p = d[po];
                    if (p < min && ((float)p < exMin || (float)p > exMax)) {
                        min = p;
                    }
                    if (p <= max || !((float)p < exMin) && !((float)p > exMax)) continue;
                    max = p;
                }
            }
            this.extrema[0][b] = min;
            this.extrema[1][b] = max;
        }
    }

    private void accumulateStatisticsFloat(UnpackedImageData uid) {
        Rectangle rect = uid.rect;
        float[][] data = uid.getFloatData();
        int lineStride = uid.lineStride;
        int pixelStride = uid.pixelStride;
        int lineInc = lineStride * this.yPeriod;
        int pixelInc = pixelStride * this.xPeriod;
        float exMin = (float)this.excludedMin;
        float exMax = (float)this.excludedMax;
        for (int b = 0; b < this.srcPA.numBands; ++b) {
            float min = (float)this.extrema[0][b];
            float max = (float)this.extrema[1][b];
            float[] d = data[b];
            int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
            for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineInc) {
                int lastPixel = lo + rect.width * pixelStride;
                for (int po = lo; po < lastPixel; po += pixelInc) {
                    float p = d[po];
                    if (p < min && (p < exMin || p > exMax)) {
                        min = p;
                    }
                    if (!(p > max) || !(p < exMin) && !(p > exMax)) continue;
                    max = p;
                }
            }
            this.extrema[0][b] = min;
            this.extrema[1][b] = max;
        }
    }

    private void accumulateStatisticsDouble(UnpackedImageData uid) {
        Rectangle rect = uid.rect;
        double[][] data = uid.getDoubleData();
        int lineStride = uid.lineStride;
        int pixelStride = uid.pixelStride;
        int lineInc = lineStride * this.yPeriod;
        int pixelInc = pixelStride * this.xPeriod;
        for (int b = 0; b < this.srcPA.numBands; ++b) {
            double min = this.extrema[0][b];
            double max = this.extrema[1][b];
            double[] d = data[b];
            int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
            for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineInc) {
                int lastPixel = lo + rect.width * pixelStride;
                for (int po = lo; po < lastPixel; po += pixelInc) {
                    double p = d[po];
                    if (p < min && (p < this.excludedMin || p > this.excludedMax)) {
                        min = p;
                    }
                    if (!(p > max) || !(p < this.excludedMin) && !(p > this.excludedMax)) continue;
                    max = p;
                }
            }
            this.extrema[0][b] = min;
            this.extrema[1][b] = max;
        }
    }

    protected void initializeState(Raster source) {
        if (this.extrema == null) {
            int numBands = this.sampleModel.getNumBands();
            this.extrema = new double[2][numBands];
            for (int i = 0; i < numBands; ++i) {
                this.extrema[0][i] = Double.MAX_VALUE;
                this.extrema[1][i] = -1.7976931348623157E308;
            }
        }
    }
}

