/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.image.op.Contrast;

public class EnhancementOp
extends JPanel {
    public static final String[] histoLabels = new String[]{"None", "Manual Enhancement", "Automatic Levels", "Equalized Levels", "Background subtraction"};
    private Contrast contrast;
    private JPanel jPanel1 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JSlider jSlider1 = new JSlider();
    private TitledBorder title1 = new TitledBorder("Luminosity offset : 0");
    private JButton jButtonArtificial = new JButton();

    private EnhancementOp() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jSlider1.setMinimum(0);
        this.jSlider1.setMaximum(255);
        this.jSlider1.setValue(127);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EnhancementOp.this.updateValues();
            }
        });
        this.jSlider1.setBorder(this.title1);
        JMVUtils.setPreferredWidth(this.jSlider1, 80);
        this.jPanel1.add((Component)this.jSlider1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jButtonArtificial, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
    }

    private void updateValues() {
        this.title1.setTitle("Luminosity offset : " + this.jSlider1.getValue() + " ");
        this.jSlider1.repaint();
    }

    private Contrast getContrastPanel() {
        if (this.contrast == null) {
            this.contrast = new Contrast();
        }
        return this.contrast;
    }

    public String getHelpEntry() {
        return "Enhancement";
    }

    public static PlanarImage backgroundSubstraction(PlanarImage image, PlanarImage background, int offset) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.addSource(background);
        pb.add(offset);
        return JAI.create((String)"BackgroundSubstract", (ParameterBlock)pb, null);
    }

    public static int[] getHistogram(PlanarImage image) {
        int[] bins = new int[]{256};
        double[] low = new double[]{0.0};
        double[] high = new double[]{256.0};
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(1);
        pb.add(1);
        pb.add(bins);
        pb.add(low);
        pb.add(high);
        RenderedOp op = JAI.create((String)"histogram", (ParameterBlock)pb, null);
        Histogram histogram = (Histogram)op.getProperty("histogram");
        int[] local_array = new int[histogram.getNumBins(0)];
        for (int i = 0; i < histogram.getNumBins(0); ++i) {
            local_array[i] = histogram.getBinSize(0, i);
        }
        return local_array;
    }

    public PlanarImage equalize(PlanarImage image) {
        int sum = 0;
        byte[] cumulative = new byte[256];
        int[] array = EnhancementOp.getHistogram(image);
        float scale = 255.0f / (float)(image.getWidth() * image.getHeight());
        for (int i = 0; i < 256; ++i) {
            cumulative[i] = (byte)((float)(sum += array[i]) * scale + 0.5f);
        }
        LookupTableJAI lookup = new LookupTableJAI(cumulative);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(lookup);
        return JAI.create((String)"lookup", (ParameterBlock)pb, null);
    }

    public static PlanarImage normalizeAllTypeOfImage(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        RenderedOp dst = JAI.create((String)"extrema", (ParameterBlock)pb, null);
        double[][] extrema = (double[][])dst.getProperty("extrema");
        int numBands = dst.getSampleModel().getNumBands();
        double[] slopes = new double[numBands];
        double[] y_ints = new double[numBands];
        for (int i = 0; i < numBands; ++i) {
            double range = extrema[1][i] - extrema[0][i];
            if (range < 1.0) {
                range = 1.0;
            }
            slopes[i] = 255.0 / range;
            y_ints[i] = 255.0 - slopes[i] * extrema[1][i];
        }
        pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(slopes);
        pb.add(y_ints);
        dst = JAI.create((String)"rescale", (ParameterBlock)pb, null);
        pb = new ParameterBlock();
        pb.addSource(dst);
        pb.add(0);
        return JAI.create((String)"format", (ParameterBlock)pb, null);
    }

    public PlanarImage piecewise(PlanarImage image) {
        float[][][] bp = new float[1][2][];
        bp[0][0] = new float[]{0.0f, 32.0f, 64.0f, 255.0f};
        bp[0][1] = new float[]{0.0f, 128.0f, 112.0f, 255.0f};
        return JAI.create((String)"piecewise", (RenderedImage)image, (Object)bp);
    }

    private PlanarImage updateManualEnhancement(PlanarImage image) {
        return this.getContrastPanel().updateSlider(image);
    }
}

