/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.weasis.core.api.image.op.ByteLut;

public class ByteLutCollection {
    public static final String[] LUT_COLLECTION;
    public static final byte[][] redToYellow;
    public static final byte[][] fire;
    public static final byte[][] ice;
    public static final byte[][] rainbow3;
    public static final byte[][] flag;
    public static final byte[][] hot;
    public static final byte[][] rainbow4;
    public static final byte[][] spectrum;
    public static final byte[][] rainbow2;
    public static final byte[][] rainbow1;
    public static final byte[][] multiColor;
    public static final byte[][] ihs;
    public static final byte[][] grays;
    public static final byte[][] red;
    public static final byte[][] green;
    public static final byte[][] blue;

    public static byte[][] grays() {
        byte[][] lut = new byte[3][256];
        for (int i = 0; i < 256; ++i) {
            lut[0][i] = (byte)i;
            lut[1][i] = (byte)i;
            lut[2][i] = (byte)i;
        }
        return lut;
    }

    public static List<ByteLut> getLutCollection() {
        ArrayList<ByteLut> luts = new ArrayList<ByteLut>();
        luts.add(ByteLut.defaultLUT);
        luts.add(ByteLut.grayLUT);
        luts.add(new ByteLut("Red to yellow", redToYellow, ByteLutCollection.invert(redToYellow)));
        luts.add(new ByteLut("Fire", fire, ByteLutCollection.invert(fire)));
        luts.add(new ByteLut("Ice", ice, ByteLutCollection.invert(ice)));
        luts.add(new ByteLut("Hot", hot, ByteLutCollection.invert(hot)));
        luts.add(new ByteLut("Spectrum", spectrum, ByteLutCollection.invert(spectrum)));
        luts.add(new ByteLut("Rainbow 1", rainbow1, ByteLutCollection.invert(rainbow1)));
        luts.add(new ByteLut("Rainbow 2", rainbow2, ByteLutCollection.invert(rainbow2)));
        luts.add(new ByteLut("Rainbow 3", rainbow3, ByteLutCollection.invert(rainbow3)));
        luts.add(new ByteLut("Rainbow 4", rainbow4, ByteLutCollection.invert(rainbow4)));
        return luts;
    }

    public static byte[][] invert(byte[][] lut) {
        int bands = lut.length;
        int dynamic = lut[0].length - 1;
        byte[][] invertlut = new byte[bands][dynamic + 1];
        for (int j = 0; j < bands; ++j) {
            for (int i = 0; i <= dynamic; ++i) {
                invertlut[j][i] = lut[j][dynamic - i];
            }
        }
        return invertlut;
    }

    public static byte[][] readLutFile(Scanner scan) throws Exception {
        byte[][] lut = new byte[3][256];
        for (int lineIndex = 0; scan.hasNext() && lineIndex < 256; ++lineIndex) {
            String[] line = scan.nextLine().split("\t");
            if (line.length != 3) continue;
            lut[0][lineIndex] = (byte)Integer.parseInt(line[0]);
            lut[1][lineIndex] = (byte)Integer.parseInt(line[1]);
            lut[2][lineIndex] = (byte)Integer.parseInt(line[2]);
        }
        return lut;
    }

    /*
     * Opcode count of 26809 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int i;
        int i2;
        LUT_COLLECTION = new String[]{"Default", "Gray", "Red to yellow", "Fire", "Ice", "Hot", "Spectrum", "Rainbow 1", "Rainbow 2", "Rainbow 3", "Rainbow 4"};
        redToYellow = new byte[3][256];
        int[] g = new int[]{0, 0, 2, 3, 4, 4, 6, 6, 7, 9, 9, 11, 12, 12, 14, 14, 15, 17, 17, 19, 20, 20, 22, 22, 23, 25, 25, 26, 27, 28, 30, 31, 32, 32, 33, 34, 35, 37, 38, 39, 40, 40, 41, 42, 44, 45, 46, 47, 47, 48, 49, 51, 52, 53, 54, 54, 55, 56, 57, 59, 60, 61, 61, 62, 63, 64, 66, 67, 68, 69, 69, 70, 71, 73, 74, 75, 76, 76, 77, 78, 79, 81, 82, 83, 83, 84, 85, 86, 88, 89, 90, 91, 91, 92, 93, 95, 96, 97, 98, 98, 99, 100, 102, 103, 104, 105, 105, 106, 107, 108, 110, 111, 112, 112, 113, 114, 115, 117, 118, 119, 120, 120, 121, 122, 124, 125, 126, 127, 127, 128, 129, 130, 132, 133, 134, 134, 135, 136, 137, 139, 140, 141, 142, 142, 143, 144, 146, 147, 148, 149, 149, 150, 151, 153, 154, 155, 156, 156, 157, 158, 159, 161, 162, 163, 163, 164, 165, 166, 168, 169, 170, 171, 171, 172, 173, 175, 176, 177, 178, 178, 179, 180, 181, 183, 184, 185, 185, 186, 187, 188, 190, 191, 192, 193, 193, 194, 195, 197, 198, 199, 200, 200, 201, 202, 204, 205, 206, 207, 207, 208, 209, 210, 212, 213, 214, 214, 215, 216, 217, 219, 220, 221, 222, 222, 223, 224, 226, 227, 228, 229, 229, 230, 231, 232, 234, 235, 236, 236, 237, 238, 239, 241, 242, 243, 244, 244, 245, 246, 248, 249, 250, 251, 251, 252, 253, 255};
        for (int i3 = 0; i3 < 256; ++i3) {
            ByteLutCollection.redToYellow[0][i3] = -1;
            ByteLutCollection.redToYellow[1][i3] = (byte)g[i3];
            ByteLutCollection.redToYellow[2][i3] = 0;
        }
        fire = new byte[3][256];
        int[] r = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88, 91, 94, 98, 101, 104, 107, 110, 113, 116, 119, 122, 125, 128, 131, 134, 137, 140, 143, 146, 148, 150, 152, 154, 156, 158, 160, 162, 163, 164, 166, 167, 168, 170, 171, 173, 174, 175, 177, 178, 179, 181, 182, 184, 185, 186, 188, 189, 190, 192, 193, 195, 196, 198, 199, 201, 202, 204, 205, 207, 208, 209, 210, 212, 213, 214, 215, 217, 218, 220, 221, 223, 224, 226, 227, 229, 230, 231, 233, 234, 235, 237, 238, 240, 241, 243, 244, 246, 247, 249, 250, 252, 252, 252, 253, 253, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] g2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 7, 8, 10, 12, 14, 16, 19, 21, 24, 27, 29, 32, 35, 37, 40, 43, 46, 48, 51, 54, 57, 59, 62, 65, 68, 70, 73, 76, 79, 81, 84, 87, 90, 92, 95, 98, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 134, 136, 138, 140, 141, 143, 145, 147, 148, 150, 152, 154, 155, 157, 159, 161, 162, 164, 166, 168, 169, 171, 173, 175, 176, 178, 180, 182, 184, 186, 188, 190, 191, 193, 195, 197, 199, 201, 203, 205, 206, 208, 210, 212, 213, 215, 217, 219, 220, 222, 224, 226, 228, 230, 232, 234, 235, 237, 239, 241, 242, 244, 246, 248, 248, 249, 250, 251, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] b = new int[]{31, 34, 38, 42, 46, 49, 53, 57, 61, 65, 69, 74, 78, 82, 87, 91, 96, 100, 104, 108, 113, 117, 121, 125, 130, 134, 138, 143, 147, 151, 156, 160, 165, 168, 171, 175, 178, 181, 185, 188, 192, 195, 199, 202, 206, 209, 213, 216, 220, 220, 221, 222, 223, 224, 225, 226, 227, 224, 222, 220, 218, 216, 214, 212, 210, 206, 202, 199, 195, 191, 188, 184, 181, 177, 173, 169, 166, 162, 158, 154, 151, 147, 143, 140, 136, 132, 129, 125, 122, 118, 114, 111, 107, 103, 100, 96, 93, 89, 85, 82, 78, 74, 71, 67, 64, 60, 56, 53, 49, 45, 42, 38, 35, 31, 27, 23, 20, 16, 12, 8, 5, 4, 3, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 13, 17, 21, 26, 30, 35, 42, 50, 58, 66, 74, 82, 90, 98, 105, 113, 121, 129, 136, 144, 152, 160, 167, 175, 183, 191, 199, 207, 215, 223, 227, 231, 235, 239, 243, 247, 251, 255, 255, 255, 255, 255, 255, 255, 255};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.fire[0][i2] = (byte)r[i2];
            ByteLutCollection.fire[1][i2] = (byte)g2[i2];
            ByteLutCollection.fire[2][i2] = (byte)b[i2];
        }
        ice = new byte[3][256];
        r = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 7, 9, 11, 14, 16, 19, 20, 21, 22, 24, 25, 26, 27, 29, 31, 34, 36, 39, 42, 44, 47, 50, 49, 49, 49, 49, 48, 48, 48, 48, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95, 99, 103, 107, 112, 114, 117, 120, 123, 125, 128, 131, 134, 137, 140, 143, 146, 149, 152, 155, 158, 161, 165, 168, 172, 175, 179, 182, 186, 187, 189, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217, 218, 220, 221, 223, 224, 226, 227, 229, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 245, 246, 247, 248, 249, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 251, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 251, 251, 251, 251, 251, 251, 251, 251, 251, 250, 249, 248, 247, 246, 245, 244, 243, 241, 239, 238, 236, 234, 233, 231, 230, 230, 230, 230, 230, 230, 230, 230};
        g2 = new int[]{156, 157, 158, 159, 160, 161, 162, 163, 165, 166, 167, 169, 170, 171, 173, 174, 176, 177, 178, 179, 180, 181, 182, 183, 184, 184, 185, 186, 187, 187, 188, 189, 190, 190, 191, 192, 193, 193, 194, 195, 196, 195, 195, 194, 194, 194, 193, 193, 193, 191, 190, 189, 188, 187, 186, 185, 184, 182, 180, 179, 177, 175, 174, 172, 171, 169, 168, 167, 166, 165, 164, 163, 162, 160, 158, 156, 154, 152, 150, 148, 146, 143, 140, 138, 135, 132, 130, 127, 125, 122, 120, 118, 116, 113, 111, 109, 107, 105, 103, 101, 100, 98, 96, 94, 93, 91, 90, 88, 87, 85, 84, 82, 81, 81, 82, 83, 84, 84, 85, 86, 87, 87, 88, 88, 89, 90, 90, 91, 92, 92, 93, 93, 94, 95, 95, 96, 97, 96, 96, 96, 96, 95, 95, 95, 95, 94, 94, 94, 94, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 92, 92, 91, 91, 91, 90, 90, 90, 89, 88, 88, 87, 86, 86, 85, 85, 83, 81, 79, 77, 75, 73, 71, 69, 68, 67, 67, 66, 65, 65, 64, 64, 62, 61, 60, 59, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 47, 45, 44, 42, 41, 39, 38, 36, 35, 33, 31, 29, 27, 25, 23, 21, 19, 16, 14, 11, 9, 7, 4, 2, 0, 0, 1, 1, 2, 2, 3, 3, 4, 3, 3, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        b = new int[]{140, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 151, 152, 153, 155, 156, 158, 159, 160, 161, 162, 163, 164, 165, 166, 166, 167, 167, 168, 168, 169, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 180, 184, 188, 192, 196, 200, 204, 209, 210, 211, 213, 214, 215, 217, 218, 220, 221, 223, 225, 227, 228, 230, 232, 234, 232, 231, 230, 229, 228, 227, 226, 225, 226, 227, 229, 230, 231, 233, 234, 236, 237, 238, 239, 241, 242, 243, 244, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 250, 250, 250, 250, 250, 250, 251, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 249, 248, 248, 247, 246, 246, 245, 245, 243, 241, 239, 237, 235, 233, 231, 230, 230, 230, 230, 230, 230, 230, 230, 230, 229, 228, 227, 226, 225, 224, 223, 222, 219, 217, 214, 212, 209, 207, 204, 202, 199, 196, 193, 191, 188, 185, 182, 180, 177, 175, 173, 171, 169, 167, 165, 163, 160, 157, 155, 152, 149, 147, 144, 142, 139, 137, 134, 132, 130, 127, 125, 123, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 104, 103, 101, 100, 98, 97, 95, 94, 92, 91, 90, 89, 87, 86, 85, 84, 81, 79, 76, 74, 71, 69, 66, 64, 59, 54, 49, 45, 40, 35, 30, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.ice[0][i2] = (byte)r[i2];
            ByteLutCollection.ice[1][i2] = (byte)g2[i2];
            ByteLutCollection.ice[2][i2] = (byte)b[i2];
        }
        rainbow3 = new byte[3][256];
        r = new int[]{73, 72, 70, 69, 68, 66, 65, 63, 62, 61, 59, 58, 57, 55, 54, 52, 51, 48, 45, 41, 38, 35, 32, 29, 26, 22, 19, 16, 13, 10, 6, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 21, 22, 22, 23, 24, 25, 25, 26, 27, 28, 28, 29, 30, 31, 31, 32, 36, 39, 43, 47, 50, 54, 57, 61, 65, 68, 72, 76, 79, 83, 86, 90, 95, 99, 104, 109, 113, 118, 123, 128, 132, 137, 142, 146, 151, 156, 160, 165, 169, 172, 176, 179, 183, 186, 190, 194, 197, 201, 204, 208, 211, 215, 218, 222, 224, 226, 228, 230, 232, 234, 236, 239, 241, 243, 245, 247, 249, 251, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 245, 240, 236, 231, 226, 221, 216, 211, 206, 201, 197, 192, 187, 182, 177, 171, 164, 158, 151, 145, 138, 132, 125, 119, 112, 106, 99, 93, 86, 73};
        g2 = new int[]{193, 195, 197, 198, 200, 202, 204, 206, 208, 209, 211, 213, 215, 217, 218, 220, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 216, 211, 205, 200, 194, 188, 183, 177, 171, 166, 160, 155, 149, 143, 138, 132, 128, 125, 121, 118, 114, 110, 107, 103, 99, 96, 92, 89, 85, 81, 78, 74, 70, 67, 63, 60, 56, 52, 49, 45, 41, 38, 34, 31, 27, 23, 20, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 6, 8, 10, 12, 14, 17, 19, 21, 23, 25, 27, 29, 31, 33, 37, 41, 45, 50, 54, 58, 62, 66, 70, 74, 78, 83, 87, 91, 95, 99, 103, 107, 111, 116, 120, 124, 128, 132, 136, 140, 144, 149, 153, 157, 161, 165, 170, 174, 179, 184, 188, 193, 197, 202, 207, 211, 216, 221, 225, 230, 234, 239, 238, 237, 236, 235, 234, 233, 232, 231, 229, 228, 227, 226, 225, 224, 223, 222, 220, 218, 217, 215, 213, 211, 209, 208, 206, 204, 202, 200, 198, 197, 193};
        b = new int[]{3, 12, 20, 29, 37, 46, 54, 63, 71, 80, 88, 97, 105, 114, 122, 131, 139, 146, 154, 161, 168, 175, 183, 190, 197, 204, 212, 219, 226, 233, 241, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 252, 250, 249, 247, 246, 244, 243, 241, 239, 238, 236, 235, 233, 232, 230, 229, 227, 226, 224, 223, 221, 220, 218, 217, 215, 214, 212, 211, 209, 208, 206, 203, 201, 198, 196, 193, 191, 188, 186, 183, 180, 178, 175, 173, 170, 168, 165, 163, 161, 159, 157, 155, 153, 151, 149, 146, 144, 142, 140, 138, 136, 134, 132, 127, 123, 118, 113, 109, 104, 99, 95, 90, 85, 80, 76, 71, 66, 62, 57, 53, 50, 46, 43, 39, 36, 32, 29, 25, 21, 18, 14, 11, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 6, 6, 5, 5, 4, 3};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.rainbow3[0][i2] = (byte)r[i2];
            ByteLutCollection.rainbow3[1][i2] = (byte)g2[i2];
            ByteLutCollection.rainbow3[2][i2] = (byte)b[i2];
        }
        flag = new byte[3][256];
        r = new int[]{255, 255, 0, 0};
        g2 = new int[]{0, 255, 0, 0};
        b = new int[]{0, 255, 255, 0};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.flag[0][i2] = (byte)r[i2 % 4];
            ByteLutCollection.flag[1][i2] = (byte)g2[i2 % 4];
            ByteLutCollection.flag[2][i2] = (byte)b[i2 % 4];
        }
        hot = new byte[3][256];
        r = new int[]{0, 1, 2, 4, 5, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 21, 22, 23, 25, 26, 28, 29, 30, 32, 33, 35, 36, 37, 39, 40, 42, 43, 44, 46, 47, 49, 50, 51, 53, 54, 56, 57, 58, 60, 61, 63, 64, 65, 67, 68, 70, 71, 72, 74, 75, 77, 78, 79, 81, 82, 84, 85, 86, 88, 89, 91, 92, 93, 95, 96, 98, 99, 100, 102, 103, 105, 106, 107, 109, 110, 112, 113, 114, 116, 117, 119, 120, 121, 123, 124, 126, 127, 128, 130, 131, 133, 134, 135, 137, 138, 140, 141, 142, 144, 145, 147, 148, 149, 151, 152, 154, 155, 156, 158, 159, 161, 162, 163, 165, 166, 168, 169, 170, 172, 173, 175, 176, 177, 179, 180, 182, 183, 184, 186, 187, 189, 190, 191, 193, 194, 196, 197, 198, 200, 201, 203, 204, 205, 207, 208, 210, 211, 212, 214, 215, 217, 218, 219, 221, 222, 224, 225, 226, 228, 229, 231, 232, 233, 235, 236, 238, 239, 240, 242, 243, 245, 246, 247, 249, 250, 252, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        g2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 8, 11, 14, 16, 19, 22, 25, 28, 30, 33, 36, 39, 42, 44, 47, 50, 53, 56, 58, 61, 64, 67, 70, 72, 75, 78, 81, 84, 86, 89, 92, 95, 98, 100, 103, 106, 109, 112, 114, 117, 120, 123, 126, 128, 131, 134, 137, 140, 142, 145, 148, 151, 154, 156, 159, 162, 165, 168, 170, 173, 176, 179, 182, 184, 187, 190, 193, 196, 198, 201, 204, 207, 210, 212, 215, 218, 221, 224, 226, 229, 232, 235, 238, 240, 243, 246, 249, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        b = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95, 99, 103, 107, 111, 115, 119, 123, 127, 131, 135, 139, 143, 147, 151, 155, 159, 163, 167, 171, 175, 179, 183, 187, 191, 195, 199, 203, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.hot[0][i2] = (byte)r[i2];
            ByteLutCollection.hot[1][i2] = (byte)g2[i2];
            ByteLutCollection.hot[2][i2] = (byte)b[i2];
        }
        rainbow4 = new byte[3][256];
        r = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 62, 60, 58, 56, 54, 52, 50, 48, 46, 44, 42, 40, 38, 36, 34, 32, 30, 28, 26, 24, 22, 20, 18, 16, 14, 12, 10, 8, 6, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 148, 152, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 200, 204, 208, 212, 216, 220, 224, 228, 232, 236, 240, 244, 248, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        g2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96, 104, 112, 120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232, 240, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 251, 249, 247, 245, 243, 241, 239, 237, 235, 233, 231, 229, 227, 225, 223, 221, 219, 217, 215, 213, 211, 209, 207, 205, 203, 201, 199, 197, 195, 193, 192, 189, 186, 183, 180, 177, 174, 171, 168, 165, 162, 159, 156, 153, 150, 147, 144, 141, 138, 135, 132, 129, 126, 123, 120, 117, 114, 111, 108, 105, 102, 99, 96, 93, 90, 87, 84, 81, 78, 75, 72, 69, 66, 63, 60, 57, 54, 51, 48, 45, 42, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3};
        b = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 148, 152, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 200, 204, 208, 212, 216, 220, 224, 228, 232, 236, 240, 244, 248, 252, 255, 247, 239, 231, 223, 215, 207, 199, 191, 183, 175, 167, 159, 151, 143, 135, 127, 119, 111, 103, 95, 87, 79, 71, 63, 55, 47, 39, 31, 23, 15, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.rainbow4[0][i2] = (byte)r[i2];
            ByteLutCollection.rainbow4[1][i2] = (byte)g2[i2];
            ByteLutCollection.rainbow4[2][i2] = (byte)b[i2];
        }
        spectrum = new byte[3][256];
        r = new int[]{255, 250, 245, 240, 235, 230, 225, 220, 215, 210, 205, 200, 195, 190, 185, 180, 175, 170, 165, 160, 155, 150, 145, 140, 135, 130, 125, 120, 115, 110, 105, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 105, 110, 115, 120, 125, 130, 135, 140, 145, 150, 155, 160, 165, 170, 175, 180, 185, 190, 195, 200, 205, 210, 215, 220, 225, 230, 235, 240, 245, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        g2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 105, 110, 115, 120, 125, 130, 135, 140, 145, 150, 155, 160, 165, 170, 175, 180, 185, 190, 195, 200, 205, 210, 215, 220, 225, 230, 235, 240, 245, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 245, 240, 235, 230, 225, 220, 215, 210, 205, 200, 195, 190, 185, 180, 175, 170, 165, 160, 155, 150, 145, 140, 135, 130, 125, 120, 115, 110, 105, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5, 0};
        b = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 245, 240, 235, 230, 225, 220, 215, 210, 205, 200, 195, 190, 185, 180, 175, 170, 165, 160, 155, 150, 145, 140, 135, 130, 125, 120, 115, 110, 105, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.spectrum[0][i2] = (byte)r[i2];
            ByteLutCollection.spectrum[1][i2] = (byte)g2[i2];
            ByteLutCollection.spectrum[2][i2] = (byte)b[i2];
        }
        rainbow2 = new byte[3][256];
        r = new int[]{0, 12, 25, 38, 51, 63, 76, 89, 102, 114, 127, 140, 153, 165, 178, 191, 204, 216, 229, 242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 246, 242, 237, 232, 228, 223, 218, 214, 209, 204, 200, 195, 191, 186, 181, 177, 172, 167, 163, 158, 153, 149, 144, 140, 135, 130, 126, 121, 116, 112, 107, 102, 98, 93, 89, 84, 79, 75, 70, 65, 61, 56, 51, 47, 42, 38, 33, 28, 24, 19, 14, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 17, 26, 35, 44, 53, 62, 71, 80, 89, 98, 107, 116, 125, 134, 143, 152, 161, 170, 179, 188, 197, 202, 206, 211, 215, 220, 224, 229, 233, 238, 242, 247, 251, 255};
        g2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 15, 22, 30, 37, 44, 51, 59, 66, 73, 81, 88, 95, 102, 110, 117, 124, 132, 139, 146, 153, 161, 168, 175, 183, 190, 197, 204, 212, 219, 226, 234, 241, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 246, 242, 237, 232, 228, 223, 218, 214, 209, 204, 200, 195, 191, 186, 181, 177, 172, 167, 163, 158, 153, 149, 144, 140, 135, 130, 126, 121, 116, 112, 107, 102, 98, 93, 89, 84, 79, 75, 70, 65, 61, 56, 51, 47, 42, 38, 33, 28, 24, 19, 14, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 40, 59, 79, 99, 118, 138, 157, 177, 197, 216, 236, 255};
        b = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 14, 19, 24, 28, 33, 38, 42, 47, 51, 56, 61, 65, 70, 75, 79, 84, 89, 93, 98, 102, 107, 112, 116, 121, 126, 130, 135, 140, 144, 149, 153, 158, 163, 167, 172, 177, 181, 186, 191, 195, 200, 204, 209, 214, 218, 223, 228, 232, 237, 242, 246, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.rainbow2[0][i2] = (byte)r[i2];
            ByteLutCollection.rainbow2[1][i2] = (byte)g2[i2];
            ByteLutCollection.rainbow2[2][i2] = (byte)b[i2];
        }
        rainbow1 = new byte[3][256];
        r = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 15, 22, 29, 36, 43, 50, 57, 64, 71, 78, 85, 93, 100, 107, 114, 121, 128, 135, 142, 149, 156, 163, 170, 178, 185, 192, 199, 206, 213, 220, 227, 234, 241, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255};
        g2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 16, 21, 27, 32, 37, 43, 48, 54, 59, 65, 70, 75, 81, 86, 92, 97, 103, 108, 113, 119, 124, 130, 135, 141, 146, 151, 157, 162, 168, 173, 179, 184, 189, 195, 200, 206, 211, 217, 222, 227, 233, 238, 244, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 245, 240, 235, 230, 225, 220, 215, 210, 204, 199, 194, 189, 184, 179, 174, 169, 164, 159, 153, 148, 143, 138, 133, 128, 123, 118, 113, 108, 102, 97, 92, 87, 82, 77, 72, 67, 62, 57, 51, 46, 41, 36, 31, 26, 21, 16, 11, 6, 0, 3, 5, 8, 10, 13, 15, 17, 20, 22, 25, 27, 30, 32, 34, 37, 39, 42, 44, 47, 49, 51, 54, 56, 59, 61, 64, 66, 68, 71, 73, 76, 78, 81, 83, 85, 88, 90, 93, 95, 98, 100, 102, 105, 107, 110, 112, 115, 117, 119, 122, 125, 128, 131, 135, 138, 141, 144, 148, 151, 154, 157, 161, 164, 167, 170, 174, 177, 180, 183, 187, 190, 193, 196, 199, 203, 206, 209, 212, 216, 219, 222, 225, 229, 232, 235, 238, 242, 245, 248, 251, 255};
        b = new int[]{0, 9, 17, 25, 33, 42, 50, 58, 66, 75, 83, 91, 99, 107, 116, 124, 132, 140, 149, 157, 165, 173, 181, 190, 198, 206, 214, 223, 231, 239, 247, 255, 250, 245, 239, 234, 228, 223, 218, 212, 207, 201, 196, 190, 185, 180, 174, 169, 163, 158, 152, 147, 142, 136, 131, 125, 120, 114, 109, 104, 98, 93, 87, 82, 76, 71, 66, 60, 55, 49, 44, 38, 33, 28, 22, 17, 11, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 85, 91, 97, 103, 109, 115, 121, 127, 133, 139, 145, 151, 157, 163, 170, 176, 182, 188, 194, 200, 206, 212, 218, 224, 230, 236, 242, 248, 255};
        for (i2 = 0; i2 < 256; ++i2) {
            ByteLutCollection.rainbow1[0][i2] = (byte)r[i2];
            ByteLutCollection.rainbow1[1][i2] = (byte)g2[i2];
            ByteLutCollection.rainbow1[2][i2] = (byte)b[i2];
        }
        multiColor = new byte[3][256];
        r = new int[]{255, 0, 255, 0, 255, 128, 64, 255, 0, 128, 236, 189, 250, 154, 221, 255, 128, 255, 0, 128, 228, 131, 189, 0, 36, 66, 40, 132, 156, 135, 98, 194, 217, 251, 255, 0};
        g2 = new int[]{3, 255, 245, 0, 0, 0, 128, 128, 0, 0, 83, 228, 202, 172, 160, 128, 128, 200, 187, 88, 93, 209, 89, 255, 137, 114, 202, 106, 235, 85, 216, 226, 182, 247, 195, 173};
        b = new int[]{0, 0, 55, 255, 255, 0, 64, 0, 128, 128, 153, 170, 87, 216, 246, 128, 64, 188, 236, 189, 39, 96, 212, 255, 176, 215, 204, 221, 255, 70, 182, 84, 172, 176, 142, 95};
        for (i2 = 0; i2 < 256; ++i2) {
            int p = i2 % 36;
            ByteLutCollection.multiColor[0][i2] = (byte)r[p];
            ByteLutCollection.multiColor[1][i2] = (byte)g2[p];
            ByteLutCollection.multiColor[2][i2] = (byte)b[p];
        }
        ihs = new byte[3][256];
        for (int i4 = 0; i4 < 256; ++i4) {
            Color c = Color.getHSBColor((float)i4 / 255.0f, 1.0f, 1.0f);
            ByteLutCollection.ihs[0][i4] = (byte)c.getRed();
            ByteLutCollection.ihs[1][i4] = (byte)c.getGreen();
            ByteLutCollection.ihs[2][i4] = (byte)c.getBlue();
        }
        grays = new byte[3][256];
        for (i = 0; i < 256; ++i) {
            ByteLutCollection.grays[0][i] = (byte)i;
            ByteLutCollection.grays[1][i] = (byte)i;
            ByteLutCollection.grays[2][i] = (byte)i;
        }
        red = new byte[3][256];
        for (i = 0; i < 256; ++i) {
            ByteLutCollection.red[0][i] = (byte)i;
            ByteLutCollection.red[1][i] = 0;
            ByteLutCollection.red[2][i] = 0;
        }
        green = new byte[3][256];
        for (i = 0; i < 256; ++i) {
            ByteLutCollection.green[0][i] = 0;
            ByteLutCollection.green[1][i] = (byte)i;
            ByteLutCollection.green[2][i] = 0;
        }
        blue = new byte[3][256];
        for (i = 0; i < 256; ++i) {
            ByteLutCollection.blue[0][i] = 0;
            ByteLutCollection.blue[1][i] = 0;
            ByteLutCollection.blue[2][i] = (byte)i;
        }
    }
}

