/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.awt.image.RenderedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.AbstractOperation;
import org.weasis.core.api.image.util.ImageToolkit;
import org.weasis.core.api.media.data.ImageElement;

public class WindowLevelOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowLevelOperation.class);
    public static final String name = Messages.getString("WindowLevelOperation.title");

    @Override
    public RenderedImage getRenderedImage(RenderedImage source, ImageOperation imageOperation) {
        ImageElement image = imageOperation.getImage();
        Float window = (Float)imageOperation.getActionValue(ActionW.WINDOW.cmd());
        Float level = (Float)imageOperation.getActionValue(ActionW.LEVEL.cmd());
        if (image == null || window == null || level == null) {
            this.result = source;
            LOGGER.warn("Cannot apply \"{}\" because a parameter is null", (Object)name);
        } else {
            this.result = ImageToolkit.getDefaultRenderedImage(image, source, image.getPixelWindow(window.floatValue()), image.getPixelLevel(level.floatValue()));
        }
        return this.result;
    }

    @Override
    public String getOperationName() {
        return name;
    }
}

