/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.core.api.gui.util.PageProps;
import org.weasis.core.api.gui.util.TreeSelection;

public abstract class AbstractWizardDialog
extends JDialog {
    protected String settingTitle;
    protected AbstractItemDialogPage currentPage = null;
    protected DefaultMutableTreeNode pagesRoot = new DefaultMutableTreeNode("root");
    private final JPanel jPanelRootPanel = new JPanel();
    private final BorderLayout borderLayout3 = new BorderLayout();
    protected final JButton jButtonClose = new JButton();
    private final BorderLayout borderLayout2 = new BorderLayout();
    private final TreeSelection tree = new TreeSelection();
    protected JPanel jPanelButtom = new JPanel();
    private final JPanel jPanelMain = new JPanel();
    protected JScrollPane jScrollPanePage = new JScrollPane();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final JScrollPane jScrollPane1 = new JScrollPane();

    public AbstractWizardDialog(Frame frame, String title, boolean modal, Dimension pageSize) {
        super(frame, title, modal);
        this.settingTitle = title;
        try {
            this.jScrollPanePage.setPreferredSize(pageSize);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.jPanelMain.setLayout(this.borderLayout2);
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizardDialog.this.cancel();
            }
        });
        this.jButtonClose.setText(Messages.getString("AbstractWizardDialog.close"));
        this.jPanelRootPanel.setLayout(this.borderLayout3);
        this.jScrollPanePage.setAutoscrolls(false);
        this.jPanelButtom.setLayout(this.gridBagLayout1);
        this.getContentPane().add((Component)this.jPanelRootPanel, null);
        this.jPanelRootPanel.add((Component)this.jPanelMain, "Center");
        this.jPanelMain.add((Component)this.jScrollPanePage, "Center");
        this.jPanelRootPanel.add((Component)this.jPanelButtom, "South");
        this.jPanelButtom.add((Component)this.jButtonClose, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 15), 0, 0));
        this.jPanelRootPanel.add((Component)this.jScrollPane1, "West");
        this.jScrollPane1.getViewport().add(this.tree);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    protected abstract void initializePages();

    public void showPageFirstPage() {
        if (this.pagesRoot.getChildCount() > 0) {
            this.tree.setSelectionRow(0);
        }
    }

    public AbstractItemDialogPage getCurrentPage() {
        Component object = null;
        try {
            object = this.jScrollPanePage.getViewport().getComponent(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof AbstractItemDialogPage) {
            return (AbstractItemDialogPage)object;
        }
        return null;
    }

    private void rowslection(AbstractItemDialogPage page) {
        if (page != null) {
            if (this.currentPage != null) {
                this.currentPage.deselectPageAction();
            }
            this.currentPage = page;
            this.currentPage.selectPageAction();
            this.jScrollPanePage.setViewportView(this.currentPage);
        }
    }

    protected void iniTree() {
        Enumeration<TreeNode> children = this.pagesRoot.children();
        while (children.hasMoreElements()) {
            PageProps[] subpages = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object object = node.getUserObject();
            if (object instanceof AbstractItemDialogPage) {
                subpages = ((AbstractItemDialogPage)object).getSubPages();
            }
            if (subpages == null) continue;
            for (int j = 0; j < subpages.length; ++j) {
                node.add(new DefaultMutableTreeNode(subpages[j]));
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(this.pagesRoot, false);
        this.tree.constructTree(model);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode object;
                if (e.getNewLeadSelectionPath() != null && (object = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getUserObject() instanceof AbstractItemDialogPage) {
                    AbstractWizardDialog.this.rowslection((AbstractItemDialogPage)object.getUserObject());
                }
            }
        });
        Dimension dim = this.tree.getPreferredSize().getSize();
        dim.width += 5;
        this.jScrollPane1.setPreferredSize(dim);
    }

    public void closeAllPages() {
        Enumeration<TreeNode> children = this.pagesRoot.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode page = (DefaultMutableTreeNode)children.nextElement();
            Object object = page.getUserObject();
            if (!(object instanceof AbstractItemDialogPage)) continue;
            try {
                ((AbstractItemDialogPage)object).closeAdditionalWindow();
            }
            catch (Exception ex) {}
        }
    }

    protected void resetAlltoDefault() {
        Enumeration<TreeNode> children = this.pagesRoot.children();
        while (children.hasMoreElements()) {
            PageProps[] subpages = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object object = node.getUserObject();
            if (!(object instanceof AbstractItemDialogPage)) continue;
            try {
                AbstractItemDialogPage page = (AbstractItemDialogPage)object;
                subpages = page.getSubPages();
                if (subpages != null) {
                    for (int j = 0; j < subpages.length; ++j) {
                        subpages[j].resetoDefaultValues();
                    }
                }
                page.resetoDefaultValues();
            }
            catch (Exception ex) {}
        }
    }

    public abstract void cancel();

    public void expandNode(int position) {
        this.tree.expandRow(position);
    }
}

