/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.p2.rcpupdate.utils;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipselabs.p2.rcpupdate.utils.AccumulatingProgressMonitor;
import org.eclipselabs.p2.rcpupdate.utils.plugin.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class P2Util {
    public static void checkForUpdates() {
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(null);
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    P2Util.doCheckForUpdates((IProgressMonitor)new AccumulatingProgressMonitor(monitor, Display.getDefault()));
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
    }

    private static void doCheckForUpdates(IProgressMonitor monitor) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (reference == null) {
            Activator.log((IStatus)new Status(4, "org.eclipselabs.p2.rcpupdate.utils", "No provisioning agent found.  This application is not set up for updates."));
            return;
        }
        IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(reference);
        try {
            IStatus updateStatus = P2Util.checkForUpdates(agent, monitor);
            Activator.log(updateStatus);
            if (updateStatus.getCode() == 10000) {
                return;
            }
            if (updateStatus.getSeverity() != 4) {
                PlatformUI.getWorkbench().restart();
            }
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }

    static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for application updates...", (int)200);
        IStatus status = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        if (status.getCode() == 10000) {
            return status;
        }
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status.getSeverity() != 4) {
            ProvisioningJob job = operation.getProvisioningJob(monitor);
            if (job == null) {
                return new Status(4, "org.eclipselabs.p2.rcpupdate.utils", "ProvisioningJob could not be created - does this application support p2 software installation?");
            }
            status = job.runModal((IProgressMonitor)sub.newChild(100));
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
        }
        return status;
    }
}

