/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewElement
extends QuickAccessElement {
    private final IViewDescriptor viewDescriptor;
    private String category;

    ViewElement(IViewDescriptor viewDescriptor, ViewProvider viewProvider) {
        super(viewProvider);
        this.viewDescriptor = viewDescriptor;
        IViewCategory[] categories = PlatformUI.getWorkbench().getViewRegistry().getCategories();
        int i = 0;
        while (i < categories.length) {
            IViewDescriptor[] views = categories[i].getViews();
            int j = 0;
            while (j < views.length) {
                if (views[j] == viewDescriptor) {
                    this.category = categories[i].getLabel();
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void execute() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            try {
                activePage.showView(this.viewDescriptor.getId());
            }
            catch (PartInitException partInitException) {}
        }
    }

    public String getId() {
        return this.viewDescriptor.getId();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.viewDescriptor.getImageDescriptor();
    }

    public String getLabel() {
        if (this.category == null) {
            return this.viewDescriptor.getLabel();
        }
        return String.valueOf(this.viewDescriptor.getLabel()) + " - " + this.category;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.viewDescriptor == null ? 0 : this.viewDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewElement other = (ViewElement)obj;
        return !(this.viewDescriptor == null ? other.viewDescriptor != null : !this.viewDescriptor.equals(other.viewDescriptor));
    }
}

