/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ninnik.util.Utils;

public class Image {
    private Long imageID;
    private Integer uploaderID;
    private String extension;
    private Integer width;
    private Integer height;
    private Date birthday;
    private String delFlg;
    private Integer used;
    private List<String> tags;

    public String getJSON() {
        String JSON = "{'imageID':" + getImageID() + "," + "'width':"
                + getWidth() + "," + "'height':" + getHeight() + ","
                + "'uploaderID':" + getUploaderID() + "," + "'extension':'"
                + getExtension() + "'," + "'birthday':new Date('"
                + getBirthday() + "')," + "'src':'" + "/images/uploaded"
                + Utils.get画像名(this) + "'," + "'tmnSrc':'"
                + Utils.getサムネイル絶対URL(this) + "'," + "'used':" + getUsed()
                + "}";
        return JSON;
    }

    private String makeTagsJSON() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        String tag;
        for (Iterator<String> localIterator = getTags().iterator(); localIterator
                .hasNext(); sb.append("'tags[" + i + "]':'" + tag + "',"))
            tag = (String) localIterator.next();
        return sb.toString();
    }

    public Image() {
        setBirthday(new Date());
        setDelFlg("0");
        setUsed(Integer.valueOf(0));
    }

    public String getDelFlg() {
        return this.delFlg;
    }

    public void setDelFlg(String delFlg) {
        this.delFlg = delFlg;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getImageID() {
        return this.imageID;
    }

    public void setImageID(Long imageID) {
        this.imageID = imageID;
    }

    public Integer getUploaderID() {
        return this.uploaderID;
    }

    public void setUploaderID(Integer uploaderID) {
        this.uploaderID = uploaderID;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Integer getUsed() {
        return this.used;
    }

    public void setUsed(Integer used) {
        this.used = used;
    }
}
